/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.BitSet;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.merge.AbstractMergeEditor;
import oracle.jdeveloper.resource.MergeArb;

public class MergeURLFileSystemHelper
extends URLFileSystemHelper {
    private static final String SEPARATOR = "///";
    public static final String MERGE_PROTOCOL = "ide.merge";

    private static final int getCurrentSequence() {
        BitSet sequences = new BitSet();
        sequences.set(0);
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            URL saveUrl;
            URL url;
            if (!(editor instanceof AbstractMergeEditor) || !(url = editor.getContext().getNode().getURL()).getProtocol().startsWith(MERGE_PROTOCOL) || (saveUrl = MergeURLFileSystemHelper.getSaveURL(url)) != null) continue;
            sequences.set(Integer.parseInt(url.getPath().split(SEPARATOR)[3]));
        }
        return sequences.nextClearBit(0);
    }

    public static URL newMergeURL(URL url) {
        return URLFactory.newIdeURL((String)MERGE_PROTOCOL, (URL)url);
    }

    public static URL newMergeURL(CompareContributor source, CompareContributor target, CompareContributor ancestor) {
        return URLFactory.newURL((String)MERGE_PROTOCOL, (String)(source.getLongLabel() + SEPARATOR + target.getLongLabel() + SEPARATOR + ancestor.getLongLabel() + SEPARATOR + String.valueOf(MergeURLFileSystemHelper.getCurrentSequence())));
    }

    public static URL getSaveURL(URL url) {
        String protocol = url.getProtocol();
        if (protocol.length() <= MERGE_PROTOCOL.length() + 1) {
            return null;
        }
        return URLFactory.replaceProtocolPart((URL)url, (String)protocol.substring(MERGE_PROTOCOL.length() + 1));
    }

    public String getFileName(URL url) {
        URL saveUrl = MergeURLFileSystemHelper.getSaveURL(url);
        if (saveUrl != null) {
            return MergeArb.format(28, URLFileSystem.getFileName((URL)saveUrl));
        }
        return MergeArb.format(28, url.getPath().split(SEPARATOR)[3]);
    }

    public String getPlatformPathName(URL url) {
        return this.getFileName(url);
    }

    public InputStream openInputStream(URL url) {
        return new ByteArrayInputStream(new byte[0]);
    }

    public boolean isReadOnly(URL url) {
        return this.canWrite(url) ^ true;
    }

    public boolean canWrite(URL url) {
        return true;
    }

    public boolean exists(URL url) {
        return false;
    }

    public long lastModified(URL url) {
        return 0L;
    }
}

