/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.io.IOException;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorPath;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.jdeveloper.merge.AbstractMergeEditor;

public class MergeUtil {
    private MergeUtil() {
    }

    public static final Editor reopenMergeEditor(Node node, Class editorClass) throws IOException {
        Object existingEditor = null;
        for (Object editor : EditorManager.getEditorManager().findEditors(Context.newIdeContext((Node)node))) {
            if (!editorClass.isInstance(editor)) continue;
            existingEditor = editor;
        }
        Editor editor = MergeUtil.openMergeEditor(node, editorClass);
        if (existingEditor == null || existingEditor != editor) {
            return editor;
        }
        if (!(editor instanceof AbstractMergeEditor)) {
            return editor;
        }
        AbstractMergeEditor mergeEditor = (AbstractMergeEditor)editor;
        if (!mergeEditor.isCompleteState()) {
            return editor;
        }
        ((AbstractMergeEditor)editor).restartMergeImpl();
        return editor;
    }

    public static final Editor openMergeEditor(Node node, Class editorClass) {
        return MergeUtil.openMergeEditor(MergeUtil.createMergeEditorContext(node), editorClass);
    }

    public static final Context createMergeEditorContext(Node node) {
        Editor editor2 = null;
        for (Editor editor2 : EditorManager.getEditorManager().findEditors(Context.newIdeContext((Node)node))) {
        }
        Context context = Context.newIdeContext((Node)node);
        if (editor2 != null) {
            context.setProject(editor2.getContext().getProject());
        }
        return context;
    }

    public static final Editor openMergeEditor(Context context, Class editorClass) {
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, editorClass);
        EditorPath editorPath = EditorManager.getEditorManager().searchEditor(context.getNode());
        if (editorPath != null) {
            openEditorOptions.setPosition(editorPath, 4);
        }
        return EditorManager.getEditorManager().openEditor(openEditorOptions);
    }
}

