/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.ceditor.UndoWrapperCommand;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.diffmerge.diff3.Diff3Format;
import oracle.ide.diffmerge.diff3.Diff3Model;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.CompareToolTipProvider;
import oracle.javatools.compare.view.ViewEdit;
import oracle.javatools.compare.view.wedge.WedgeCompareView;
import oracle.javatools.editor.BasicDocument;
import oracle.jdeveloper.merge.AbstractMergeEditor;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdeveloper.merge.TextMergeContributor;
import oracle.jdeveloper.merge.TextMergeNode;
import oracle.jdeveloper.merge.TextMergeNodeContributor;
import oracle.jdeveloper.resource.MergeArb;
import oracle.jdevimpl.merge.MergeValidator;
import oracle.jdevimpl.merge.MergeValidatorFactory;

public class TextMergeEditor
extends AbstractMergeEditor
implements CompareToolTipProvider {
    private NodeUpdater _ancestorUpdater;
    private TextMergeNode _textMergeNode;
    private Diff3Model _diff3Model;
    private MergeValidator _validator;

    protected Diff3Model getDiff3Model() {
        return this._diff3Model;
    }

    protected void initializeMergeView(CompareView mergeView) {
        if (mergeView instanceof WedgeCompareView) {
            ((WedgeCompareView)mergeView).setToolTipProvider((CompareToolTipProvider)this);
        }
    }

    private void clearAnnotationsSS() {
        if (this._diff3Model == null) {
            return;
        }
        if (this._diff3Model.getSourceAnnotations() != null) {
            this._diff3Model.getSourceAnnotations().clear();
        }
        if (this._diff3Model.getTargetAnnotations() != null) {
            this._diff3Model.getTargetAnnotations().clear();
        }
    }

    protected Class getAnnotationClassSS() {
        return Diff3Model.Annotation.class;
    }

    protected String createFirstContributorLabelSS() {
        StringBuffer labelBuffer = new StringBuffer();
        for (Object annotation : this._diff3Model.getSourceAnnotations().values()) {
            if (labelBuffer.length() > 0) {
                labelBuffer.append(',');
            }
            labelBuffer.append(annotation.toString());
        }
        return labelBuffer.toString();
    }

    public String getToolTipText(ContributorKind contributorKind, CompareDifference difference) {
        if (this._diff3Model == null) {
            return null;
        }
        if (!(difference instanceof SequenceCompareDifference)) {
            return null;
        }
        Object annotation = null;
        if (contributorKind == ContributorKind.FIRST) {
            annotation = this._diff3Model.getSourceAnnotations().get(((SequenceCompareDifference)difference).getId());
        }
        if (contributorKind == ContributorKind.SECOND) {
            annotation = this._diff3Model.getTargetAnnotations().get(((SequenceCompareDifference)difference).getId());
        }
        if (annotation != null) {
            return MergeArb.format(3, annotation.toString());
        }
        return null;
    }

    public void close() {
        super.close();
        this.clearAnnotationsSS();
    }

    protected boolean validateContent(CompareModel model) throws IOException {
        return this.getValidator().isValid(this.owner().getGUI(), (Node)this.getTextMergeNode(), model);
    }

    protected void installUndoableEditListener() {
        Node node;
        Document jdkDoc;
        super.installUndoableEditListener();
        Document document = jdkDoc = this.getCompareView() != null && this.getCompareView() instanceof WedgeCompareView ? ((WedgeCompareView)this.getCompareView()).getDocument(ContributorKind.ANCESTOR) : null;
        if (jdkDoc instanceof BasicDocument && (node = this.getContext().getNode()) != null) {
            this._ancestorUpdater = NodeUpdater.getUpdater((Subject)node, (TextBuffer)((BasicDocument)jdkDoc).getTextBuffer());
        }
    }

    protected void deinstallUndoableEditListener() {
        super.deinstallUndoableEditListener();
        this._ancestorUpdater = null;
    }

    protected CompareModel createMergeModelImpl(Context context) {
        SequenceCompareModel textMergeModel = null;
        try {
            try {
                textMergeModel = this.createTextMergeModel(context);
            }
            catch (UnsupportedOperationException uoe) {
                textMergeModel = MergeContext.isClientSideMerge(context) ? this.createMergeModelCS(context) : this.createMergeModelSS(context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TextMergeContributor emptyContributor = new TextMergeContributor(TextBufferFactory.createTextBuffer(), "", "");
            SequenceCompareModel sequenceCompareModel = new SequenceCompareModel((SequenceCompareContributor)emptyContributor, (SequenceCompareContributor)emptyContributor, (SequenceCompareContributor)emptyContributor, new SequenceCompareDifference[0]);
            return sequenceCompareModel;
        }
        if (textMergeModel == null) {
            return null;
        }
        TextMergeNode mergeNode = this.getTextMergeNode();
        TextBuffer mergeTextBuffer = mergeNode.acquireTextBuffer();
        mergeNode.acquireTextBuffer().addTextBufferListener((TextBufferListener)new 1(this, mergeTextBuffer));
        if (URLFileSystem.isReadOnly((URL)this.getSaveURL(context))) {
            mergeNode.acquireTextBuffer().setReadOnly(true);
        }
        return textMergeModel;
    }

    protected boolean restartMergeImpl(Context context) throws IOException {
        this.reopen();
        return true;
    }

    protected boolean saveMergeImpl(Context context, CompareModel compareModel) throws IOException {
        if (compareModel instanceof SequenceCompareModel) {
            return this.saveTextMerge(context, (SequenceCompareModel)compareModel);
        }
        return this._saveMerge(context, compareModel);
    }

    protected boolean saveTextMerge(Context context, SequenceCompareModel textMergeModel) throws IOException {
        return this._saveMerge(context, (CompareModel)textMergeModel);
    }

    private boolean _saveMerge(Context context, CompareModel textMergeModel) throws IOException {
        URL url = this.getSaveURL(context);
        if (URLFileSystem.isReadOnly((URL)url)) {
            return false;
        }
        TextBuffer ancestorTextBuffer = ((TextCompareContributor)textMergeModel.getContributor(ContributorKind.ANCESTOR)).getTextBuffer();
        ancestorTextBuffer.write((Writer)new BufferedWriter(new OutputStreamWriter(URLFileSystem.openOutputStream((URL)url), IdeUtil.getIdeEncoding())));
        if (url.getProtocol().startsWith("ide.")) {
            URLFileSystem.setLastModified((URL)url, (long)System.currentTimeMillis());
        } else {
            new File(URLFileSystem.getPlatformPathName((URL)url)).setLastModified(System.currentTimeMillis());
        }
        VirtualFileSystemHelper.invalidateDirectory((URL)URLFileSystem.getParent((URL)url));
        if (context.getNode() != null) {
            RevertNodeCommand.reload((Node)context.getNode());
        }
        return true;
    }

    protected Command createEditCommand(ViewEdit viewEdit) {
        return new UndoWrapperCommand((UndoableEdit)viewEdit, (Object)this._ancestorUpdater);
    }

    protected boolean getClientSideMergeSetting() {
        return this.getClass() == TextMergeEditor.class;
    }

    protected SequenceCompareModel createTextMergeModel(Context context) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected CompareModel createMergeModelSS(Context context) throws IOException {
        this.clearAnnotationsSS();
        URL url = context.getNode().getURL();
        Diff3Format diff3Format = new Diff3Format();
        diff3Format.setAnnotationClass(this.getAnnotationClassSS());
        this._diff3Model = diff3Format.parse(this.createReader());
        String compareType = URLFileSystem.getSuffix((URL)url);
        String firstContributorLabel = this.createFirstContributorLabelSS();
        String fileName = URLFileSystem.getFileName((URL)url);
        TextMergeContributor firstContributor = new TextMergeContributor(this._diff3Model.getFirstTextBuffer(), compareType, firstContributorLabel);
        TextMergeContributor secondContributor = new TextMergeContributor(this._diff3Model.getSecondTextBuffer(), compareType, fileName);
        this.setTextMergeNode(new TextMergeNode(url, this._diff3Model.getAncestorTextBuffer()));
        TextMergeNodeContributor ancestorContributor = new TextMergeNodeContributor(this.getTextMergeNode(), MergeArb.getString(29));
        return new SequenceCompareModel((SequenceCompareContributor)firstContributor, (SequenceCompareContributor)secondContributor, (SequenceCompareContributor)ancestorContributor, this._diff3Model.getDifferenceBlocks());
    }

    private MergeValidator getValidator() {
        if (this._validator == null) {
            this._validator = MergeValidatorFactory.getMergeValidatorFactory().createValidator();
        }
        return this._validator;
    }

    private CompareModel createMergeModelCS(Context context) throws IOException, CompareFailedException {
        CompareModel compareModel = MergeContext.getModel(context);
        if (compareModel == null) {
            CompareContributor contributor1 = MergeContext.getFirstContributor(context);
            CompareContributor contributor2 = MergeContext.getSecondContributor(context);
            CompareContributor contributorA = MergeContext.getAncestorContributor(context);
            if (contributor1 == null || contributor2 == null || contributorA == null) {
                throw new IllegalArgumentException();
            }
            MergeEngine mergeEngine = MergeContext.getMergeEngine(context);
            if (mergeEngine == null) {
                mergeEngine = MergeEngine.getInstance();
            }
            mergeEngine.prepareMerge(contributor1, contributor2, contributorA);
            this.setProgressCancelable(mergeEngine.isCancelable());
            compareModel = mergeEngine.executeMerge();
            if (compareModel == null) {
                return null;
            }
            compareModel.getContributor(ContributorKind.ANCESTOR).setShortLabel(MergeArb.getString(31));
            compareModel.getContributor(ContributorKind.ANCESTOR).setLongLabel(MergeArb.getString(31));
            compareModel.getContributor(ContributorKind.ANCESTOR).setType(contributor1.getType().equals(contributor2.getType()) ? contributor1.getType() : "");
        }
        TextBuffer textBuffer = ((TextCompareContributor)compareModel.getContributor(ContributorKind.ANCESTOR)).getTextBuffer();
        Node node = context.getNode();
        TextMergeNode textMergeNode = node instanceof TextMergeNode ? (TextMergeNode)node : new TextMergeNode(context.getNode().getURL());
        textMergeNode.setTextBuffer(textBuffer);
        this.setTextMergeNode(textMergeNode);
        return compareModel;
    }

    protected void setTextMergeNode(TextMergeNode textMergeNode) {
        this._textMergeNode = textMergeNode;
    }

    protected TextMergeNode getTextMergeNode() {
        return this._textMergeNode;
    }

    final class 1
    implements TextBufferListener {
        private final /* synthetic */ TextBuffer v$mergeTextBuffer;
        final /* synthetic */ TextMergeEditor this$0;

        public void attributeUpdate(TextBuffer buffer, int attribute) {
            if (attribute == 5) {
                this.this$0.updateMergeAttributes(this.v$mergeTextBuffer);
            }
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
        }

        public 1(TextMergeEditor textMergeEditor, TextBuffer textBuffer) {
            this.v$mergeTextBuffer = textBuffer;
            this.this$0 = textMergeEditor;
        }
    }
}

