/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TimerTask;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.changelist.AsynchronousChangeList;
import oracle.jdeveloper.vcs.changelist.AsynchronousStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListProjectContent;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsynchronousStatusTask
extends TimerTask {
    private final AsynchronousStatusCache _changeListStatusCache;
    private final AsynchronousChangeList.EventQueueImpl _changeListEventQueue;
    private final ChangeList _changeList;
    private final VCSThreadPool _threadPool;
    private boolean _cancelled;

    protected AsynchronousStatusTask(ChangeList changeList, VCSThreadPool threadPool) {
        this._changeListStatusCache = (AsynchronousStatusCache)changeList.getStatusCache();
        this._changeListEventQueue = (AsynchronousChangeList.EventQueueImpl)changeList.getEventQueue();
        this._changeList = changeList;
        this._threadPool = threadPool;
    }

    @Override
    public boolean cancel() {
        this._cancelled = true;
        return super.cancel();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        ChangeListEvent cle;
        if (!this.isClientReady()) {
            return;
        }
        if (this._changeListEventQueue.isTaskInProgress()) return;
        if (this._changeList.isBusy()) {
            return;
        }
        this.setChangeListBusy(true);
        LinkedHashSet<URL> directoriesToQuery = new LinkedHashSet<URL>();
        Project[] projects = VCSModelUtils.findCachedProjects();
        int i = 0;
        while (i < projects.length) {
            ArrayList<URL> directoryUrls = null;
            try {
                directoryUrls = new ArrayList<URL>(Arrays.asList(new ChangeListProjectContent(projects[i]).getBaseDirectoryURLs()));
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                this.setChangeListBusy(false);
                return;
            }
            Iterator itr = directoryUrls.iterator();
            while (itr.hasNext()) {
                URL directoryUrl = (URL)itr.next();
                if (URLFileSystem.isDirectory((URL)directoryUrl) && this.isControlled(directoryUrl)) continue;
                itr.remove();
            }
            directoriesToQuery.addAll(Arrays.asList(VCSFileSystemUtils.coalesceURLs(directoryUrls.toArray(new URL[0]))));
            ++i;
        }
        try {
            if (this.canExit()) {
                return;
            }
            HashMap<URL, Object> statusCacheMap = new HashMap<URL, Object>();
            this.populateStatusCacheMap(statusCacheMap, directoriesToQuery);
            if (this.canExit()) {
                return;
            }
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            urls.addAll(Arrays.asList(this._changeListStatusCache.searchValues(VCSURLFilters.createNullFilter())));
            urls.addAll(statusCacheMap.keySet());
            this._changeListStatusCache.setInternalCache(statusCacheMap);
            if (this.canExit()) {
            }
            cle = new ChangeListEvent(0);
            cle.setURLs(urls.toArray(new URL[0]));
            cle.setUpdate(true);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return;
        }
        {
            this._changeListEventQueue.enqueue(cle);
            EventQueue.invokeLater(new 1());
            return;
        }
        finally {
            this.setChangeListBusy(false);
        }
    }

    protected boolean isClientReady() {
        return true;
    }

    protected abstract void populateStatusCacheMap(Map<URL, Object> var1, Collection<URL> var2) throws Exception;

    protected abstract boolean isControlled(URL var1);

    protected abstract String getViewId();

    protected abstract boolean isChangeListVisible();

    protected VCSThreadPool getThreadPool() {
        return this._threadPool;
    }

    private void setChangeListBusy(boolean isBusy) {
        ChangeListEvent cle = new ChangeListEvent(2);
        cle.setRunnable(new 2(this, isBusy));
        this._changeListEventQueue.enqueue(cle);
        this._changeListEventQueue.setTaskInProgress(isBusy);
    }

    protected boolean canExit() {
        return !this.isChangeListVisible() || !this._changeListEventQueue.isAlive() || this._cancelled;
    }

    static AsynchronousChangeList.EventQueueImpl ra$_changeListEventQueue(AsynchronousStatusTask asynchronousStatusTask) {
        return asynchronousStatusTask._changeListEventQueue;
    }

    final class 1
    implements Runnable {
        public void run() {
            DockStation dockStation = DockStation.getDockStation();
            Dockable dockable = dockStation.getDockable(new ViewId(AsynchronousStatusTask.this.getViewId()));
            if (dockable instanceof View) {
                ((View)dockable).updateVisibleActions();
            }
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ boolean v$isBusy;
        final /* synthetic */ AsynchronousStatusTask this$0;

        public void run() {
            AsynchronousStatusTask.ra$_changeListEventQueue(this.this$0).setChangeListBusyImpl(this.v$isBusy);
        }

        public 2(AsynchronousStatusTask asynchronousStatusTask, boolean bl) {
            this.v$isBusy = bl;
            this.this$0 = asynchronousStatusTask;
        }
    }
}

