/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTablePersistentSettings;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListContextMenuListener;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListLocalStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.changelist.ChangeListStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.changelist.IdeObserver;
import oracle.jdeveloper.vcs.changelist.MultiChangeListStatus;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCache;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModelEvent;
import oracle.jdeveloper.vcs.vop.VersionOperationModelListener;
import oracle.jdeveloper.vcs.vop.VersionOperationPanel;

public class ChangeList
extends JPanel {
    private URLFilter _urlFilter;
    private VCSURLBasedCache _statusCache;
    private Observer _statusObserver;
    private EventQueueIdeObserver _projectObserver;
    private VersionOperationPanel _vop;
    private MutableVersionOperationModel _model;
    private Object[] _statuses;
    private boolean _isBusy;
    private boolean _shouldDefaultColumnWidths;
    private VCSOptionsCustomizer _optionsCustomizer;
    private ChangeListEventQueue _eventQueue;
    private VCSOverlayItemProducer _overlayItemProducer;
    private Observer _overlayObserver;
    private ProgressTrackedTask _progressTask;
    private Object[] _filterStatuses;
    private URLFilter _scopeFilter;
    private boolean _excludeDirectories;
    private final Object _modeId;
    private final DisplayProperty[] _displayProperties;
    private ContextMenuListener _contextMenuListener;
    public static final String CHANGELIST_COUNT_PROPERTY = "changeListCount";
    public static final String COMMENTS_VISIBLE_PROPERTY = "optionsVisible";
    public static final String BUSY_PROPERTY = "busy";

    private void $init$() {
        this._urlFilter = VCSURLFilters.createFileProtocolFilter();
        this._vop = new VersionOperationPanel();
        this._isBusy = false;
        this._shouldDefaultColumnWidths = false;
        this._optionsCustomizer = null;
        this._scopeFilter = null;
        this._excludeDirectories = false;
        this._displayProperties = this.createDisplayProperties();
    }

    public ChangeList() {
        this((Object)null);
    }

    public ChangeList(Object modeId) {
        this.$init$();
        this._modeId = modeId;
        this._vop.setBorderLook(1);
        this._vop.setOptionsResizeable(true);
        this.setLayout(new BorderLayout(0, 0));
        this.add(this._vop);
        this._vop.addPropertyChangeListener(new 1());
        this._vop.setSelectOnRightClick(true);
        this._vop.setOptionsLocation(1);
        this.setOptionsVisible(false);
        if (this.isMulti()) {
            this.initializeRenderers();
        }
    }

    public void setExcludeDirectories(boolean excludeDirectories) {
        this._excludeDirectories = excludeDirectories;
    }

    public boolean isExcludeDirectories() {
        return this._excludeDirectories;
    }

    Component getFocusComponent() {
        return this._vop != null ? this._vop.getTable() : null;
    }

    Container getFocusContainer() {
        return this._vop != null ? this._vop : this;
    }

    private void initializeRenderers() {
        2 statusRenderer = new 2();
        3 collectionRenderer = new 3();
        this.setDefaultRenderer(ChangeListStatus.class, (TableCellRenderer)((Object)statusRenderer));
        this.setDefaultRenderer(MultiChangeListStatus.class, (TableCellRenderer)((Object)statusRenderer));
        this.setDefaultRenderer(Collection.class, (TableCellRenderer)((Object)collectionRenderer));
    }

    boolean isMulti() {
        return this._modeId != null;
    }

    protected Object getModeId() {
        return this._modeId;
    }

    protected Icon getModeIcon() {
        return null;
    }

    protected String getModeLabel() {
        return this._modeId != null ? this._modeId.toString() : null;
    }

    protected String getModeLongLabel() {
        return this.getModeLabel();
    }

    protected void initializeChangeList() {
    }

    protected void addToolbarActions(ChangeListWindow window, Toolbar toolbar) {
        toolbar.add((ToggleAction)window.createLocalAction(51));
    }

    protected DisplayProperty[] createDisplayProperties() {
        return null;
    }

    protected Object getModelValue(URL url, DisplayProperty displayProperty) throws Exception {
        if (!ChangeListStatus.class.isAssignableFrom(displayProperty.getType())) {
            return null;
        }
        return this.getStatusCache() != null && url != null ? this.getStatusCache().getValue(url) : null;
    }

    protected String getStatusMessage(int count) {
        return "";
    }

    protected String getBusyStatusMessage() {
        return "";
    }

    protected void addContextMenuListeners(ContextMenu contextMenu) {
        this._contextMenuListener = new ChangeListContextMenuListener(this);
        contextMenu.addContextMenuListener(this._contextMenuListener);
    }

    protected void removeContextMenuListeners(ContextMenu contextMenu) {
        contextMenu.removeContextMenuListener(this._contextMenuListener);
        this._contextMenuListener = null;
    }

    protected void setProgressTask(ProgressTrackedTask progressTask) {
        this._progressTask = progressTask;
    }

    protected ProgressTrackedTask getProgressTask() {
        return this._progressTask;
    }

    public void setItemURLFilter(URLFilter urlFilter) {
        this._urlFilter = urlFilter;
    }

    public URLFilter getItemURLFilter() {
        return this._urlFilter;
    }

    public void setOverlayStatusCache(VCSStatusCache statusCache) {
        this.setOverlayItemProducer(new VCSOverlayItemProducer(statusCache));
    }

    public void setOverlayItemProducer(VCSOverlayItemProducer overlayItemProducer) {
        this._overlayItemProducer = overlayItemProducer;
        if (overlayItemProducer == null) {
            this._overlayObserver = null;
            return;
        }
        this._overlayObserver = new 4();
    }

    public VCSStatusCache getOverlayStatusCache() {
        return this._overlayItemProducer != null ? this._overlayItemProducer.getStatusCache() : null;
    }

    public VCSOverlayItemProducer getOverlayItemProducer() {
        return this._overlayItemProducer;
    }

    public ChangeListEventQueue getEventQueue() {
        return this._eventQueue;
    }

    public boolean isFocusInOptions() {
        if (this._optionsCustomizer instanceof ChangeListCommentsCustomizer) {
            return ((ChangeListCommentsCustomizer)this._optionsCustomizer).hasFocus();
        }
        return false;
    }

    void requestFocusInChangeList() {
        this._vop.getTable().requestFocus();
    }

    void requestFocusInOptions() {
        if (this._optionsCustomizer instanceof ChangeListCommentsCustomizer) {
            ((ChangeListCommentsCustomizer)this._optionsCustomizer).requestFocus();
        }
    }

    public boolean isItemAtPosition(Point p) {
        return this._vop.getTable().rowAtPoint(p) >= 0;
    }

    public void addMouseListener(MouseListener ml) {
        this._vop.addMouseListener(ml);
        if (this._optionsCustomizer instanceof ChangeListCommentsCustomizer) {
            ((ChangeListCommentsCustomizer)this._optionsCustomizer).addMouseListener(ml);
        }
    }

    public void removeMouseListener(MouseListener ml) {
        this._vop.removeMouseListener(ml);
        if (this._optionsCustomizer instanceof ChangeListCommentsCustomizer) {
            ((ChangeListCommentsCustomizer)this._optionsCustomizer).removeMouseListener(ml);
        }
    }

    public final Element[] getSelection() {
        return this._vop.getSelection();
    }

    public final Element[] getElements() {
        Element[] elements = new Element[this.getModel().getCount()];
        int i = 0;
        while (i < this.getModel().getCount()) {
            elements[i] = (Element)this.getModel().getItem(i);
            ++i;
        }
        return elements;
    }

    public final boolean isEmpty() {
        return this.getModel().getCount() == 0;
    }

    public final int getCount() {
        return this._model != null ? this._model.getCount() : 0;
    }

    public final void addSelectionListener(ListSelectionListener listener) {
        this._vop.addSelectionListener(listener);
    }

    public final void removeSelectionListener(ListSelectionListener listener) {
        this._vop.removeSelectionListener(listener);
    }

    public void selectAll() {
        this._vop.selectAll();
    }

    void setBorderLook(int vopLookConstant) {
        this._vop.setBorderLook(vopLookConstant);
    }

    public void setDefaultRenderer(Class columnClass, TableCellRenderer renderer) {
        this._vop.getTable().setDefaultRenderer(columnClass, renderer);
    }

    public TableCellRenderer getDefaultRenderer(Class columnClass) {
        return this._vop.getTable().getDefaultRenderer(columnClass);
    }

    public final void setOptionsCustomizer(VCSOptionsCustomizer c) {
        this._vop.setOptionsComponent(c.getComponent());
        this._optionsCustomizer = c;
    }

    public final VCSOptionsCustomizer getOptionsCustomizer() {
        return this._optionsCustomizer;
    }

    public final void setOptionsVisible(boolean isVisible) {
        this._vop.setOptionsVisible(isVisible);
    }

    public final boolean isOptionsVisible() {
        return this._vop.isOptionsVisible();
    }

    void depersistVisualSettings(String persistenceKey) {
        CopyableNiceTablePersistentSettings settings = (CopyableNiceTablePersistentSettings)Ide.getDTCache().getData(persistenceKey);
        if (settings != null) {
            this._vop.getTable().setPersistentSettings(settings.getValue());
        } else {
            this._shouldDefaultColumnWidths = true;
        }
    }

    void persistVisualSettings(String persistenceKey) {
        Ide.getDTCache().putData(persistenceKey, (Copyable)new CopyableNiceTablePersistentSettings(this._vop.getTable().getPersistentSettings()));
    }

    public final void setStatusCache(VCSStatusCache statusCache) {
        this.setStatusCache((VCSURLBasedCache)statusCache);
    }

    public final void setStatusCache(ChangeListStatusCache statusCache) {
        this.setStatusCache((VCSURLBasedCache)statusCache);
    }

    protected final void setStatusCache(VCSURLBasedCache statusCache) {
        this._statusCache = statusCache;
        this.initializeModel();
    }

    protected final void initializeModel() {
        this._model = this.createModel();
        this._model.addVersionOperationModelListener(new 5());
        this.installModel(this._model);
    }

    protected void installModel(MutableVersionOperationModel model) {
        this._vop.installModel(model);
        if (!this.isMulti()) {
            return;
        }
        model.addVersionOperationModelListener(new 6());
    }

    public VCSURLBasedCache getStatusCache() {
        return this._statusCache;
    }

    public final void setVisibleStatuses(VCSStatus[] statuses) {
        this.setVisibleStatuses((Object[])statuses);
    }

    public final void setVisibleStatuses(ChangeListStatus[] statuses) {
        this.setVisibleStatuses((Object[])statuses);
    }

    private final void setVisibleStatuses(Object[] statuses) {
        this._statuses = statuses;
        if (this.isStarted()) {
            this.refresh();
        }
    }

    Object[] getVisibleStatuses() {
        return this._statuses;
    }

    public void refilter(VCSStatus[] filterStatuses) {
        this.setFilterStatuses(filterStatuses);
    }

    public void setFilterStatuses(VCSStatus[] filterStatuses) {
        if (this._eventQueue == null) {
            throw new IllegalStateException();
        }
        ChangeListEvent cle = new ChangeListEvent(2);
        cle.setRunnable(new 7(this, filterStatuses));
        this._eventQueue.enqueue(cle);
        this._refresh();
    }

    void setFilterStatusesImpl(Object[] filterStatuses) {
        this._filterStatuses = filterStatuses;
    }

    public Object[] getFilterStatuses() {
        return this._filterStatuses;
    }

    public void setScopeFilter(URLFilter scopeFilter) {
        if (this._scopeFilter != null && scopeFilter != null && this._scopeFilter == scopeFilter) {
            this.setScopeFilterImpl(scopeFilter);
            return;
        }
        if (this._eventQueue == null) {
            this.setScopeFilterImpl(scopeFilter);
            return;
        }
        ChangeListEvent cle = new ChangeListEvent(2);
        cle.setRunnable(new 8(this, scopeFilter));
        this._eventQueue.enqueue(cle);
        this._refresh();
    }

    void setScopeFilterImpl(URLFilter scopeFilter) {
        this._scopeFilter = scopeFilter;
    }

    public URLFilter getScopeFilter() {
        return this._scopeFilter;
    }

    public final boolean isBusy() {
        return this._isBusy;
    }

    public final void setBusy(boolean isBusy) {
        if (this._isBusy != isBusy) {
            this._isBusy = isBusy;
            this.firePropertyChange(BUSY_PROPERTY, isBusy ^ true, isBusy);
        }
    }

    protected boolean isStarted() {
        return this._statusObserver != null;
    }

    public final void stop() {
        if (this.isStarted()) {
            this.stopImpl();
        }
    }

    protected void stopImpl() {
        this._progressTask = null;
        if (this._statusCache != null && this._statusObserver != null) {
            this._statusCache.deleteObserver(this._statusObserver);
        }
        this._statusObserver = null;
        if (this._projectObserver != null) {
            this._projectObserver.stopObserving();
        }
        this._projectObserver = null;
        if (this._model != null) {
            this._model.replace(Collections.EMPTY_LIST);
        }
        if (this._overlayItemProducer != null) {
            this._overlayItemProducer.getObservable().deleteObserver(this._overlayObserver);
        }
        if (this._eventQueue != null) {
            this._eventQueue.stop();
        }
        this._eventQueue = null;
        if (this.getStatusCache() instanceof ChangeListLocalStatusCache) {
            ((ChangeListLocalStatusCache)this.getStatusCache()).detachGlobalCache();
        }
    }

    public final void start() {
        if (!this.isStarted()) {
            this.startImpl();
        }
    }

    protected void startImpl() {
        this._isBusy = false;
        this._eventQueue = this.createEventQueue();
        if (this._eventQueue != null) {
            this._eventQueue.start();
            this._projectObserver = new EventQueueIdeObserver(null);
            this._projectObserver.startObserving(this._eventQueue);
            this._statusObserver = new 9();
            this._statusCache.addObserver(this._statusObserver);
        }
        this.refresh();
        if (this._overlayItemProducer != null) {
            this._overlayItemProducer.getObservable().addObserver(this._overlayObserver);
        }
        if (this.getStatusCache() instanceof ChangeListLocalStatusCache) {
            ((ChangeListLocalStatusCache)this.getStatusCache()).attachGlobalCache();
        }
    }

    Observer getStatusObserver() {
        return this._statusObserver;
    }

    public void refresh() {
        if (this._eventQueue == null) {
            return;
        }
        ChangeListEvent cle = new ChangeListEvent(2);
        cle.setRunnable(new 10());
        this._eventQueue.enqueue(cle);
        this._refresh();
    }

    void refreshImpl() {
        this._refresh();
    }

    private void _refresh() {
        this._eventQueue.curtail();
        ChangeListEvent cle = new ChangeListEvent(0);
        cle.setWorkspaces(VCSModelUtils.findCachedWorkspaces());
        cle.setProjects(VCSModelUtils.findCachedProjects());
        cle.setReplace(true);
        this._eventQueue.enqueue(cle);
    }

    protected ChangeListEventQueue createEventQueue() {
        return new ChangeListEventQueue(this);
    }

    protected MutableVersionOperationModel getModel() {
        return this._model;
    }

    protected MutableVersionOperationModel createModel() {
        return VCSComponents.createFileListerModel(new ArrayList(), this._displayProperties);
    }

    protected void insertProperties(int firstItem, int lastItem) {
        this.updateDisplayProperties(firstItem, lastItem);
        int i = firstItem;
        while (i <= lastItem) {
            Displayable d = this._model.getItem(i);
            if (d instanceof Locatable) {
                URL url = ((Locatable)d).getURL();
                String location = URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)url));
                this._model.setProperty(i, this._model.getProperties()[0], location);
            }
            ++i;
        }
        if (this._shouldDefaultColumnWidths) {
            try {
                this._vop.autoSizeColumnsToFit();
            }
            finally {
                this._shouldDefaultColumnWidths = false;
            }
        }
    }

    protected void updateProperties(int firstItem, int lastItem) {
        this.updateDisplayProperties(firstItem, lastItem);
    }

    private void updateDisplayProperties(int firstItem, int lastItem) {
        if (this._displayProperties == null) {
            return;
        }
        int i = firstItem;
        while (i <= lastItem) {
            this.updateDisplayProperties(i);
            ++i;
        }
    }

    private void updateDisplayProperties(int itemIndex) {
        Displayable item = this.getModel().getItem(itemIndex);
        if (!(item instanceof Locatable)) {
            return;
        }
        URL url = ((Locatable)item).getURL();
        if (url == null) {
            return;
        }
        try {
            int i = 0;
            while (this._displayProperties != null && i < this._displayProperties.length) {
                Object displayValue = this.getModelValue(url, this._displayProperties[i]);
                this.getModel().setProperty(itemIndex, this._displayProperties[i], displayValue);
                ++i;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    protected void defaultOptionsOnInitialInsert() {
    }

    protected void clearOptions() {
        if (this.getOptionsCustomizer() instanceof ChangeListCommentsCustomizer) {
            ((ChangeListCommentsCustomizer)this.getOptionsCustomizer()).clear();
        }
    }

    protected String getTabToggleKey() {
        return null;
    }

    protected String[] getPreferencesPath() {
        return null;
    }

    static void mav$_refresh(ChangeList changeList) {
        changeList._refresh();
    }

    static Observer ra$_statusObserver(ChangeList changeList) {
        return changeList._statusObserver;
    }

    static VCSURLBasedCache ra$_statusCache(ChangeList changeList) {
        return changeList._statusCache;
    }

    static ChangeListEventQueue ra$_eventQueue(ChangeList changeList) {
        return changeList._eventQueue;
    }

    static MutableVersionOperationModel ra$_model(ChangeList changeList) {
        return changeList._model;
    }

    static void mav$firePropertyChange(ChangeList changeList, String string, Object object, Object object2) {
        changeList.firePropertyChange(string, object, object2);
    }

    final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent pce) {
            ChangeList.mav$firePropertyChange(ChangeList.this, pce.getPropertyName(), pce.getOldValue(), pce.getNewValue());
        }
    }

    final class 2
    extends NiceTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
            if (!isSelected) {
                this.setForeground(UIManager.getColor("controlText"));
            }
            if (value == null) {
                this.setRendererText("");
                return this;
            }
            if (value instanceof ChangeListStatus) {
                ChangeListStatus status = (ChangeListStatus)value;
                this.setRendererText(status.getChangeListLabel());
                if (!isSelected && status.isChangeListCellHighlighted()) {
                    this.setForeground(Color.RED);
                }
            } else {
                this.setRendererText(value.toString());
            }
            return this;
        }

        private void setRendererText(String text) {
            this.setText(text);
            this.setToolTipText(text);
        }
    }

    final class 3
    extends NiceTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
            if (value == null) {
                this.setRendererText("");
                return this;
            }
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                if (c instanceof List) {
                    Collections.sort((List)c);
                }
                StringBuffer itemsBuffer = new StringBuffer();
                Iterator itr = c.iterator();
                while (itr.hasNext()) {
                    if (itemsBuffer.length() > 0) {
                        itemsBuffer.append(',');
                    }
                    itemsBuffer.append(itr.next().toString());
                }
                String text = itemsBuffer.toString();
                if (c.size() > 1) {
                    text = MessageFormat.format("({0}) {1}", Integer.toString(c.size()), text);
                }
                this.setRendererText(text);
            } else {
                this.setRendererText(value.toString());
            }
            return this;
        }

        private void setRendererText(String text) {
            this.setText(text);
            this.setToolTipText(text);
        }
    }

    final class 4
    implements Observer {
        public void update(Observable o, Object arg) {
            if (ChangeList.ra$_eventQueue(ChangeList.this) == null) {
                return;
            }
            ChangeListEvent cle = new ChangeListEvent(1);
            cle.setURLs((URL[])arg);
            ChangeList.ra$_eventQueue(ChangeList.this).enqueue(cle);
        }
    }

    public static class CopyableNiceTablePersistentSettings
    implements Copyable {
        private NiceTablePersistentSettings _value;

        public CopyableNiceTablePersistentSettings() {
        }

        public CopyableNiceTablePersistentSettings(NiceTablePersistentSettings settings) {
            this.setValue(settings);
        }

        public NiceTablePersistentSettings getValue() {
            return this._value;
        }

        public void setValue(NiceTablePersistentSettings settings) {
            this._value = settings;
        }

        public Object copyTo(Object target) {
            CopyableNiceTablePersistentSettings copy = target != null ? (CopyableNiceTablePersistentSettings)target : new CopyableNiceTablePersistentSettings();
            this.copyToImpl(copy);
            return copy;
        }

        protected final void copyToImpl(CopyableNiceTablePersistentSettings copy) {
            copy.setValue(this.getValue());
        }
    }

    final class 5
    implements VersionOperationModelListener {
        private boolean _lock;
        private boolean _isEmpty;

        private void $init$() {
            this._lock = false;
            this._isEmpty = ChangeList.ra$_model(ChangeList.this).getCount() == 0;
        }

        public void itemsChanged(VersionOperationModelEvent event) {
            if (this._lock) {
                return;
            }
            try {
                this._lock = true;
                ChangeList.this.updateProperties(event.getStart(), event.getEnd());
            }
            finally {
                this._lock = false;
            }
        }

        public void itemsInserted(VersionOperationModelEvent event) {
            if (this._lock) {
                return;
            }
            try {
                this._lock = true;
                ChangeList.this.insertProperties(event.getStart(), event.getEnd());
                if (ChangeList.ra$_model(ChangeList.this).getCount() > 0 && this._isEmpty) {
                    ChangeList.this.defaultOptionsOnInitialInsert();
                }
                if (ChangeList.ra$_model(ChangeList.this).getCount() == 0 && !event.isChanging()) {
                    ChangeList.this.clearOptions();
                }
            }
            catch (Throwable throwable) {
                this._lock = false;
                this._isEmpty = ChangeList.ra$_model(ChangeList.this).getCount() == 0;
                throw throwable;
            }
            this._lock = false;
            this._isEmpty = ChangeList.ra$_model(ChangeList.this).getCount() == 0;
        }

        public void itemsRemoved(VersionOperationModelEvent event) {
            if (this._lock) {
                return;
            }
            try {
                this._lock = true;
                if (ChangeList.ra$_model(ChangeList.this).getCount() == 0 && !this._isEmpty && !event.isChanging()) {
                    ChangeList.this.clearOptions();
                }
            }
            catch (Throwable throwable) {
                this._lock = false;
                this._isEmpty = ChangeList.ra$_model(ChangeList.this).getCount() == 0;
                throw throwable;
            }
            this._lock = false;
            this._isEmpty = ChangeList.ra$_model(ChangeList.this).getCount() == 0;
        }

        public void completenessChanged(VersionOperationModelEvent event) {
        }

        public 5() {
            this.$init$();
        }
    }

    final class 6
    implements VersionOperationModelListener {
        private void $init$() {
            ChangeList.this.putClientProperty(ChangeList.CHANGELIST_COUNT_PROPERTY, new Integer(0));
        }

        public void itemsChanged(VersionOperationModelEvent event) {
            this.modelChanged(event);
        }

        public void itemsInserted(VersionOperationModelEvent event) {
            this.modelChanged(event);
        }

        public void itemsRemoved(VersionOperationModelEvent event) {
            this.modelChanged(event);
        }

        public void completenessChanged(VersionOperationModelEvent event) {
            this.modelChanged(event);
        }

        private void modelChanged(VersionOperationModelEvent event) {
            int oldCount = (Integer)ChangeList.this.getClientProperty(ChangeList.CHANGELIST_COUNT_PROPERTY);
            int newCount = ChangeList.this.getCount();
            if (newCount == oldCount) {
                return;
            }
            if (event.isChanging()) {
                return;
            }
            ChangeList.this.putClientProperty(ChangeList.CHANGELIST_COUNT_PROPERTY, new Integer(newCount));
            ChangeList.this.firePropertyChange(ChangeList.CHANGELIST_COUNT_PROPERTY, oldCount, newCount);
        }

        public 6() {
            this.$init$();
        }
    }

    final class 7
    implements Runnable {
        private final /* synthetic */ VCSStatus[] v$filterStatuses;
        final /* synthetic */ ChangeList this$0;

        public void run() {
            this.this$0.setFilterStatusesImpl(this.v$filterStatuses);
        }

        public 7(ChangeList changeList, VCSStatus[] vCSStatusArray) {
            this.v$filterStatuses = vCSStatusArray;
            this.this$0 = changeList;
        }
    }

    final class 8
    implements Runnable {
        private final /* synthetic */ URLFilter v$scopeFilter;
        final /* synthetic */ ChangeList this$0;

        public void run() {
            this.this$0.setScopeFilterImpl(this.v$scopeFilter);
        }

        public 8(ChangeList changeList, URLFilter uRLFilter) {
            this.v$scopeFilter = uRLFilter;
            this.this$0 = changeList;
        }
    }

    final class 9
    implements Observer {
        public void update(Observable o, Object arg) {
            ChangeListEvent cle = new ChangeListEvent(0);
            cle.setURLs((URL[])arg);
            cle.setUpdate(true);
            ChangeList.ra$_eventQueue(ChangeList.this).enqueue(cle);
        }
    }

    final class 10
    implements Runnable {
        public void run() {
            if (ChangeList.ra$_statusObserver(ChangeList.this) != null) {
                ChangeList.ra$_statusCache(ChangeList.this).deleteObserver(ChangeList.ra$_statusObserver(ChangeList.this));
            }
            ChangeList.ra$_statusCache(ChangeList.this).clearValues();
            if (ChangeList.ra$_statusObserver(ChangeList.this) != null) {
                ChangeList.ra$_statusCache(ChangeList.this).addObserver(ChangeList.ra$_statusObserver(ChangeList.this));
            }
        }
    }

    private class EventQueueIdeObserver
    extends IdeObserver {
        private ChangeListEventQueue _eventQueue;

        ChangeListEventQueue getEventQueue() {
            return this._eventQueue;
        }

        public void startObserving(ChangeListEventQueue eventQueue) {
            this._eventQueue = eventQueue;
            super.startObserving();
        }

        public void stopObserving() {
            super.stopObserving();
            this._eventQueue = null;
        }

        protected void updateImpl(Object source, UpdateMessage updateMessage) {
            int msgId = updateMessage.getMessageID();
            if (source == Ide.getWorkspaces() && msgId == UpdateMessage.CHILD_ADDED) {
                ChangeListEvent cle = new ChangeListEvent(0);
                cle.setWorkspaces((Workspace[])VCSCollectionUtils.toArrayType(updateMessage.getAddObjects(), Workspace.class));
                this._eventQueue.enqueue(cle);
            }
            if (source instanceof Workspace && msgId == UpdateMessage.OBJECT_OPENED) {
                ChangeListEvent cle = new ChangeListEvent(0);
                cle.setWorkspaces(new Workspace[]{(Workspace)source});
                this._eventQueue.enqueue(cle);
            }
            if (source instanceof Project) {
                if (msgId == UpdateMessage.CHILD_REMOVED) {
                    ChangeListEvent cle = new ChangeListEvent(0);
                    cle.setObjects(updateMessage.getRemoveObjects().toArray());
                    this._eventQueue.enqueue(cle);
                }
                if (msgId == UpdateMessage.CHILD_ADDED) {
                    ChangeListEvent cle = new ChangeListEvent(0);
                    cle.setObjects(updateMessage.getAddObjects().toArray());
                    this._eventQueue.enqueue(cle);
                }
                if (msgId == UpdateMessage.OBJECT_OPENED) {
                    ChangeListEvent cle = new ChangeListEvent(0);
                    cle.setProjects(new Project[]{(Project)source});
                    this._eventQueue.enqueue(cle);
                }
                if (msgId == UpdateMessage.PROPERTY_SET && updateMessage.containsProperty("contentProvidersPath")) {
                    ChangeList.mav$_refresh(ChangeList.this);
                }
            }
        }

        private EventQueueIdeObserver() {
        }

        EventQueueIdeObserver(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

