/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;

public class ChangeListCommentsCustomizer
extends VCSCommentsCustomizer {
    public static final String KEY_SETTING_COMMENTS = "setting_comments";
    Map m_optionsMap;

    public ChangeListCommentsCustomizer() {
        this.setFlatLook(true);
        this.setDefaultVisibleRows(1);
        this.setSuppressContextMenu(true);
        this.setVisiblePopupRows(3);
    }

    public void addMouseListener(MouseListener ml) {
        this.getTextComponent().addMouseListener(ml);
    }

    public void removeMouseListener(MouseListener ml) {
        this.getTextComponent().removeMouseListener(ml);
    }

    public void setOptions(Map optionsMap) {
        this.m_optionsMap = optionsMap;
    }

    public Map getOptions() {
        this.getComponent();
        if (this.m_optionsMap == null) {
            this.m_optionsMap = new HashMap();
        }
        this.m_optionsMap.put(KEY_SETTING_COMMENTS, this.getTextComponent().getText());
        return new HashMap(this.m_optionsMap);
    }

    boolean hasFocus() {
        return this.getTextComponent().hasFocus();
    }

    void requestFocus() {
        this.getTextComponent().requestFocus();
    }

    void addFocusListener(FocusListener fl) {
        this.getTextComponent().addFocusListener(fl);
    }

    void removeFocusListener(FocusListener fl) {
        this.getTextComponent().removeFocusListener(fl);
    }

    void addCaretListener(CaretListener cl) {
        this.getTextComponent().addCaretListener(cl);
    }

    void removeCaretListener(CaretListener cl) {
        this.getTextComponent().removeCaretListener(cl);
    }

    boolean isEmpty() {
        return this.getTextComponent().getDocument().getLength() == 0;
    }

    boolean isTextSelected() {
        int start = this.getTextComponent().getSelectionStart();
        int end = this.getTextComponent().getSelectionEnd();
        return end - start > 0;
    }

    void delete() throws BadLocationException {
        int start = this.getTextComponent().getSelectionStart();
        int end = this.getTextComponent().getSelectionEnd();
        if (end - start > 0) {
            this.getTextComponent().getDocument().remove(start, end - start);
        }
    }

    void clear() {
        this.getTextComponent().setText("");
    }

    public void setCommentText(String text) {
        this.getTextComponent().setText(text);
    }

    public String getCommentText() {
        return this.getTextComponent().getText();
    }

    void cut() {
        this.getTextComponent().cut();
    }

    void copy() {
        this.getTextComponent().copy();
    }

    void paste() {
        this.getTextComponent().paste();
    }

    void selectAll() {
        this.getTextComponent().selectAll();
    }
}

