/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ideimpl.controls.FlatTabbedWindow;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;

public class ChangeListController
implements Controller {
    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (context.getView() instanceof ChangeListWindow) {
            CustomTab customTab;
            ChangeListWindow window = (ChangeListWindow)context.getView();
            if (cmdId == 17) {
                action.setEnabled(this.hasSelectedText(window));
                return true;
            }
            if (cmdId == 18) {
                action.setEnabled(this.hasSelectedText(window));
                return true;
            }
            if (cmdId == 19 || cmdId == 78) {
                return false;
            }
            if (cmdId == 22) {
                ChangeListCommentsCustomizer customizer = this.getCompatibleCustomizer(window);
                if (customizer == null || !customizer.hasFocus()) {
                    action.setEnabled(window.getContextChangeList().getCount() > 0);
                    return true;
                }
                action.setEnabled(customizer.isEmpty() ^ true);
                return true;
            }
            if (cmdId == 20) {
                action.setEnabled(this.hasSelectedText(window));
                return true;
            }
            if (cmdId == ChangeListWindow.COPY_FILE_LIST_CMD_ID) {
                action.setEnabled(window.getContextChangeList().isEmpty() ^ true);
                return true;
            }
            if (cmdId == ChangeListWindow.TOGGLE_COMMENTS_CMD_ID) {
                action.setState(window.getContextChangeList().isOptionsVisible());
                return true;
            }
            if (cmdId == ChangeListWindow.OPEN_CMD_ID) {
                action.setEnabled(window.getContextChangeList().getSelection().length > 0);
                return true;
            }
            FlatTabbedWindow tabbedWindow = window instanceof ChangeListWindow ? window.getTabbedWindow() : null;
            CustomTab customTab2 = customTab = tabbedWindow != null ? tabbedWindow.getCustomTab() : null;
            if (cmdId == 70) {
                action.setEnabled(customTab != null && customTab.getSelectedPage() > 0);
                return true;
            }
            if (cmdId == 71) {
                action.setEnabled(customTab != null && customTab.getSelectedPage() < customTab.getPageCount() - 1);
                return true;
            }
            if (cmdId == EditorManagerImpl.SHOW_DROPDOWN_CMD_ID) {
                action.setEnabled(customTab != null && customTab.getPageCount() > 1);
                return true;
            }
        }
        return false;
    }

    private boolean hasCompatibleCustomizer(ChangeListWindow window) {
        return this.getCompatibleCustomizer(window) != null;
    }

    private ChangeListCommentsCustomizer getCompatibleCustomizer(ChangeListWindow window) {
        VCSOptionsCustomizer customizer = window.getContextChangeList().getOptionsCustomizer();
        if (customizer instanceof ChangeListCommentsCustomizer) {
            return (ChangeListCommentsCustomizer)customizer;
        }
        return null;
    }

    private boolean hasSelectedText(ChangeListWindow window) {
        ChangeListCommentsCustomizer customizer = this.getCompatibleCustomizer(window);
        if (customizer != null) {
            return customizer.isTextSelected();
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (context.getView() instanceof ChangeListWindow) {
            ChangeListWindow window = (ChangeListWindow)context.getView();
            ChangeListCommentsCustomizer customizer = this.getCompatibleCustomizer(window);
            if (customizer != null && customizer.hasFocus()) {
                if (cmdId == 17) {
                    customizer.cut();
                    return true;
                }
                if (cmdId == 18) {
                    customizer.copy();
                    return true;
                }
                if (cmdId == 19 || cmdId == 78) {
                    customizer.paste();
                    return true;
                }
                if (cmdId == 22) {
                    customizer.selectAll();
                    return true;
                }
                if (cmdId == 20) {
                    try {
                        customizer.delete();
                    }
                    catch (BadLocationException ble) {
                        ExceptionDialog.showExceptionDialog((Context)context, (Throwable)ble);
                    }
                    return true;
                }
            } else {
                if (cmdId == 22) {
                    window.getContextChangeList().selectAll();
                    return true;
                }
                if (window instanceof ChangeListWindow) {
                    FlatTabbedWindow tabbedWindow = window.getTabbedWindow();
                    if (cmdId == 70) {
                        tabbedWindow.navigateLeft();
                        return true;
                    }
                    if (cmdId == 71) {
                        tabbedWindow.navigateRight();
                        return true;
                    }
                    if (cmdId == EditorManagerImpl.SHOW_DROPDOWN_CMD_ID) {
                        tabbedWindow.displayDropdownMenu();
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

