/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.layout.ViewId;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSDockableViewRegistry;

public class ChangeListDockableFactory
implements DockableFactory {
    private final ChangeList _changeList;
    private ChangeListWindow _changeListWindow;
    private final String _windowID;
    private final String _windowClassName;

    public ChangeListDockableFactory(String windowID, ChangeList changeList) {
        this(windowID, changeList, null);
    }

    public ChangeListDockableFactory(String windowID, String className) {
        this(windowID, null, className);
    }

    public ChangeListDockableFactory(String windowID, ChangeList changeList, String className) {
        this._windowID = ViewId.validate((String)windowID);
        this._changeList = changeList;
        this._windowClassName = className;
        DockStation.getDockStation().unregisterDockableFactory(this._windowID);
        DockStation.getDockStation().registerDockableFactory(this._windowID, (DockableFactory)this);
    }

    public Dockable getDockable(ViewId viewId) {
        return this.getChangeListWindow();
    }

    public void install() {
    }

    private ChangeListWindow getChangeListWindow() {
        if (this._changeListWindow == null) {
            this._changeListWindow = this.createChangeListWindow(this._changeList);
            VCSDockableViewRegistry.registerDockableView(this._windowID, 2);
        }
        return this._changeListWindow;
    }

    protected ChangeListWindow createChangeListWindow(ChangeList changeList) {
        if (this._windowClassName == null) {
            return new ChangeListWindow(changeList, this._windowID);
        }
        try {
            Class<?> c = Class.forName(this._windowClassName);
            if (this._changeList != null) {
                Constructor<?> constructor = c.getConstructor(ChangeList.class, String.class);
                ChangeListWindow changeListWindow = (ChangeListWindow)((Object)constructor.newInstance(this._changeList, this._windowID));
                return changeListWindow;
            }
            Constructor<?> constructor = c.getConstructor(String.class);
            ChangeListWindow changeListWindow = (ChangeListWindow)((Object)constructor.newInstance(this.getWindowId()));
            return changeListWindow;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String getWindowClassName() {
        return this._windowClassName;
    }

    protected String getWindowId() {
        return this._windowID;
    }
}

