/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventListener;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.changelist.ChangeListProjectContent;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.vop.DisplayableComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeListEventQueue {
    private final ChangeList _changeList;
    private final List<ChangeListEvent> _queue;
    private boolean _alive;
    private int _updateDelay;
    private Thread _thread;
    private VCSCancellable _cancellable;
    private Collection<ChangeListEventListener> _eventListeners;
    private final Map<URL, Project> _urlToProjectCache;
    private static final Collection<String> _workspaceArtifactPaths = new ArrayList<String>();
    private static final boolean DEBUG = true;

    private void $init$() {
        this._queue = new LinkedList<ChangeListEvent>();
        this._alive = true;
        this._eventListeners = new ArrayList<ChangeListEventListener>();
        this._urlToProjectCache = new WeakHashMap<URL, Project>();
    }

    static {
        ChangeListEventQueue.registerWorkspaceArtifact(".adf/");
        ChangeListEventQueue.registerWorkspaceArtifact("mds/");
    }

    public ChangeListEventQueue(ChangeList changeList) {
        this(changeList, 500);
    }

    public ChangeListEventQueue(ChangeList changeList, int updateDelay) {
        this.$init$();
        this._updateDelay = updateDelay;
        this._changeList = changeList;
    }

    protected ChangeList getChangeList() {
        return this._changeList;
    }

    public synchronized void addEventListener(ChangeListEventListener eventListener) {
        this._eventListeners.add(eventListener);
    }

    public synchronized void removeEventListener(ChangeListEventListener eventListener) {
        this._eventListeners.remove(eventListener);
    }

    public synchronized void setUpdateDelay(int updateDelay) {
        this._updateDelay = updateDelay;
    }

    public synchronized int getUpdateDelay() {
        return this._updateDelay;
    }

    public synchronized boolean isAlive() {
        return this._alive;
    }

    public synchronized void enqueue(ChangeListEvent event) {
        this._queue.add(event);
        this.notifyAll();
    }

    synchronized void curtail() {
        for (ChangeListEvent cle : this._queue) {
            if (cle.getKind() != 0) continue;
            cle.curtail();
        }
    }

    protected ChangeListItem[] createChangeListItems(URL[] urls) {
        ChangeListItem[] items = new ChangeListItem[urls.length];
        int i = 0;
        while (i < urls.length) {
            items[i] = this.createChangeListItem(urls[i]);
            ++i;
        }
        return items;
    }

    protected ChangeListItem createChangeListItem(URL url) {
        VCSOverlayItemProducer overlayItemProducer = this._changeList.getOverlayItemProducer();
        VCSOverlayItem overlayItem = null;
        try {
            overlayItem = overlayItemProducer != null ? overlayItemProducer.getOverlayItems(new URL[]{url})[0] : null;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        return new ChangeListItem(url, this._urlToProjectCache.get(url), overlayItem != null ? overlayItem.getOverlay() : null);
    }

    protected void setChangeListBusy(boolean isBusy) {
        EventQueue.invokeLater(new 1(this, isBusy));
    }

    protected void processEvent(ChangeListEvent cle) throws Exception {
        if (cle.getKind() == 0) {
            this.processRequeryEvent(cle);
        }
        if (cle.getKind() == 1) {
            this.processOverlayChange(cle.getURLs());
        }
        if (cle.getKind() == 2) {
            cle.getRunnable().run();
        }
    }

    protected void processRequeryEvent(ChangeListEvent cle) throws Exception {
        if (cle.isReplace()) {
            this._urlToProjectCache.clear();
        }
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        if (cle.getWorkspaces() != null) {
            Workspace[] workspaceArray = cle.getWorkspaces();
            int n = 0;
            while (n < workspaceArray.length) {
                Workspace workspace = workspaceArray[n];
                urls.add(workspace.getURL());
                urls.addAll(this.getWorkspaceArtifactURLs(workspace));
                if (workspace.isOpen()) {
                    Iterator itr = workspace.getChildren();
                    while (itr.hasNext()) {
                        Object child = itr.next();
                        URL url = VCSModelUtils.getLocatableURL(child);
                        if (url == null) continue;
                        urls.add(url);
                    }
                }
                ++n;
            }
        }
        if (cle.getProjects() != null) {
            Project[] projectArray = cle.getProjects();
            int n = 0;
            while (n < projectArray.length) {
                Project project = projectArray[n];
                Collection<URL> projectUrls = this.listProjectURLs(project);
                for (URL url : projectUrls) {
                    this._urlToProjectCache.put(url, project);
                }
                urls.addAll(projectUrls);
                ++n;
            }
        }
        if (cle.getURLs() != null) {
            urls.addAll(Arrays.asList(cle.getURLs()));
        }
        if (cle.getObjects() != null) {
            URL[] urls0 = VCSModelUtils.convertNodesToURLs(VCSModelUtils.getValidLocatables(cle.getObjects(), null));
            urls.addAll(Arrays.asList(urls0));
            if (!this._changeList.isExcludeDirectories()) {
                URLPath projectUrlPath = new URLPath();
                Project[] projectArray = VCSModelUtils.findCachedProjects();
                int n = 0;
                while (n < projectArray.length) {
                    Project project = projectArray[n];
                    projectUrlPath.add(new ChangeListProjectContent(project).getBaseURLPath());
                    ++n;
                }
                URL[] uRLArray = VCSFileSystemUtils.getParentURLs(urls0);
                int n2 = 0;
                while (n2 < uRLArray.length) {
                    URL url = uRLArray[n2];
                    if (projectUrlPath.getLongestMatchingEntry(url) != null) {
                        urls.add(url);
                    }
                    ++n2;
                }
            }
        }
        ArrayList<URL> urls0 = new ArrayList<URL>(urls);
        this.filterByProtocol(urls0);
        int i = 0;
        while (i < urls0.size()) {
            URL url = (URL)urls0.get(i);
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (suffix.equals(".jws") || suffix.equals(".jpr")) {
                urls0.set(i, URLFileSystem.canonicalize((URL)url));
            }
            ++i;
        }
        ArrayList urls1 = new ArrayList(urls0);
        this.filterByStatus(urls0);
        if (!this.isAlive()) {
            return;
        }
        urls1.removeAll(urls0);
        ArrayList<ChangeListItem> validItems = new ArrayList<ChangeListItem>(Arrays.asList(this.createChangeListItems(urls0.toArray(new URL[0]))));
        List<ChangeListItem> invalidItems = cle.isReplace() ? null : Arrays.asList(this.createChangeListItems(urls1.toArray(new URL[0])));
        Collections.sort(validItems, new DisplayableComparator());
        EventQueue.invokeLater(new 2(this, cle, validItems, invalidItems));
    }

    private Collection<URL> listProjectURLs(Project project) throws Exception {
        this._cancellable = new VCSCancellable();
        Collection urls = this.listProjectURLs(project, new ChangeListProjectContent(project), this._cancellable);
        this._cancellable = null;
        return urls;
    }

    protected Collection listProjectURLs(Project project, ChangeListProjectContent projectContent, VCSCancellable cancellable) throws Exception {
        return new LinkedHashSet<URL>(Arrays.asList(projectContent.listURLs(this._changeList.isExcludeDirectories() ^ true, cancellable)));
    }

    private void filterByProtocol(Collection urls) throws Exception {
        Iterator itr = urls.iterator();
        while (itr.hasNext() && this.isAlive()) {
            URL url = (URL)itr.next();
            if (this._changeList.getItemURLFilter().accept(url)) continue;
            Assert.println((String)("ChangeList: Ignoring URL: " + url));
            itr.remove();
        }
    }

    protected void filterByStatus(Collection urls) throws Exception {
        ChangeListWindow.ScopeFilter scopeFilter;
        if (this._changeList.isExcludeDirectories()) {
            Iterator itr = urls.iterator();
            while (itr.hasNext()) {
                if (!URLFileSystem.isDirectoryPath((URL)((URL)itr.next()))) continue;
                itr.remove();
            }
        }
        if ((scopeFilter = (ChangeListWindow.ScopeFilter)this._changeList.getScopeFilter()) != null) {
            scopeFilter.clearCache();
            Iterator itr = urls.iterator();
            while (itr.hasNext()) {
                if (scopeFilter.accept((URL)itr.next())) continue;
                itr.remove();
            }
        }
        LinkedList urls0 = new LinkedList(urls);
        ArrayList<URL> urls1 = new ArrayList<URL>();
        ArrayList<Object> urlStatuses = new ArrayList<Object>();
        int batchCount = this.getBatchCount(urls);
        while (!urls0.isEmpty() && this.isAlive()) {
            int i = 0;
            while (i < batchCount && !urls0.isEmpty()) {
                urls1.add((URL)urls0.removeFirst());
                ++i;
            }
            urlStatuses.addAll(Arrays.asList(this._changeList.getStatusCache().getValues(urls1.toArray(new URL[0]))));
            urls1.clear();
        }
        if (!this.isAlive()) {
            return;
        }
        List<Object> displayStatuses = this._changeList.getVisibleStatuses() != null ? Arrays.asList(this._changeList.getVisibleStatuses()) : null;
        List<Object> filterStatuses = this._changeList.getFilterStatuses() != null ? Arrays.asList(this._changeList.getFilterStatuses()) : null;
        int i = 0;
        Iterator itr = urls.iterator();
        while (itr.hasNext()) {
            Object url = itr.next();
            if (url != null) {
                if (!this.containStatus(displayStatuses, urlStatuses, i)) {
                    itr.remove();
                } else if (filterStatuses != null && !filterStatuses.contains(urlStatuses.get(i))) {
                    itr.remove();
                }
            }
            ++i;
        }
    }

    protected boolean containStatus(List displayStatuses, ArrayList urlStatuses, int i) {
        return displayStatuses.contains(urlStatuses.get(i));
    }

    protected int getBatchCount(Collection urls) {
        return 10;
    }

    protected void processOverlayChange(URL[] urls) throws Exception {
        VCSOverlayItemProducer overlayItemProducer = this._changeList.getOverlayItemProducer();
        if (overlayItemProducer == null) {
            return;
        }
        VCSOverlayItem[] overlayItems = overlayItemProducer.getOverlayItems(urls);
        EventQueue.invokeLater(new 3(this, urls, overlayItems));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        4 r = new 4();
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            this._thread = new Thread((Runnable)r, "Version Control Changelist Updater");
            this._thread.setPriority(1);
            this._alive = true;
            this._thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            this.setAlive(false);
            this.cancelListProjects();
            this._thread = null;
        }
    }

    private synchronized void setAlive(boolean isAlive) {
        this._alive = isAlive;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cancelListProjects() {
        ChangeListEventQueue changeListEventQueue = this;
        synchronized (changeListEventQueue) {
            if (this._cancellable != null) {
                this._cancellable.cancel();
            }
            this._cancellable = null;
        }
    }

    private void processEvents() throws InterruptedException {
        while (!this.isEmpty()) {
            if (!this.isAlive()) {
                return;
            }
            ChangeListEvent cle = this.dequeue();
            if (cle.isCurtailed()) continue;
            Assert.println((String)("ChangeList: Processing " + cle));
            try {
                this.fireEventDispatched(cle);
                this.processEvent(cle);
                this.fireEventProcessed(cle);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void fireEventDispatched(ChangeListEvent cle) {
        if (this._eventListeners.size() <= 0) {
            return;
        }
        ChangeListEventListener[] l = this._eventListeners.toArray(new ChangeListEventListener[0]);
        int i = l.length - 1;
        while (i >= 0) {
            l[i].eventDispatched(cle);
            --i;
        }
    }

    private synchronized void fireEventProcessed(ChangeListEvent cle) {
        if (this._eventListeners.size() <= 0) {
            return;
        }
        ChangeListEventListener[] l = this._eventListeners.toArray(new ChangeListEventListener[0]);
        int i = l.length - 1;
        while (i >= 0) {
            l[i].eventProcessed(cle);
            --i;
        }
    }

    private synchronized ChangeListEvent peekMajorEvent() {
        for (ChangeListEvent cle : this._queue) {
            if (cle.getKind() != 0) continue;
            return cle;
        }
        return null;
    }

    private synchronized ChangeListEvent dequeue() {
        ChangeListEvent event = this._queue.remove(0);
        this.notifyAll();
        return event;
    }

    private synchronized boolean isEmpty() {
        return this._queue.isEmpty();
    }

    private synchronized void awaitEvents() throws InterruptedException {
        while (this.isEmpty() && this.isAlive()) {
            this.wait();
        }
    }

    private void eventLoop() throws InterruptedException {
        while (true) {
            this.setChangeListBusy(false);
            this.awaitEvents();
            if (!this.isAlive()) {
                return;
            }
            Thread.sleep(this._updateDelay);
            if (this.peekMajorEvent() != null) {
                this.setChangeListBusy(true);
            }
            this.processEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<URL> getWorkspaceArtifactURLs(Workspace workspace) {
        String[] workspaceArtifactPaths;
        ArrayList<URL> urls = new ArrayList<URL>();
        Collection<String> collection = _workspaceArtifactPaths;
        synchronized (collection) {
            workspaceArtifactPaths = _workspaceArtifactPaths.toArray(new String[0]);
        }
        if (!workspace.isOpen()) {
            return Collections.emptySet();
        }
        int j = 0;
        while (j < workspaceArtifactPaths.length) {
            this.getWorkspaceArtifactURLs(URLFactory.newURL((URL)URLFileSystem.getParent((URL)workspace.getURL()), (String)workspaceArtifactPaths[j]), urls);
            ++j;
        }
        return urls;
    }

    private void getWorkspaceArtifactURLs(URL baseUrl, Collection urls) {
        if (!URLFileSystem.exists((URL)baseUrl)) {
            return;
        }
        urls.add(baseUrl);
        if (!URLFileSystem.isDirectoryPath((URL)baseUrl)) {
            return;
        }
        URL[] contentsUrls = URLFileSystem.list((URL)baseUrl);
        int i = 0;
        while (i < contentsUrls.length) {
            this.getWorkspaceArtifactURLs(contentsUrls[i], urls);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerWorkspaceArtifact(String path) {
        Collection<String> collection = _workspaceArtifactPaths;
        synchronized (collection) {
            _workspaceArtifactPaths.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deregisterWorkspaceArtifact(String path) {
        Collection<String> collection = _workspaceArtifactPaths;
        synchronized (collection) {
            _workspaceArtifactPaths.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Collection<String> getWorkspaceArtifacts() {
        Collection<String> collection = _workspaceArtifactPaths;
        synchronized (collection) {
            ArrayList<String> arrayList = new ArrayList<String>(_workspaceArtifactPaths);
            return arrayList;
        }
    }

    static void mav$eventLoop(ChangeListEventQueue changeListEventQueue) {
        changeListEventQueue.eventLoop();
    }

    static void wa$_alive(ChangeListEventQueue changeListEventQueue, boolean bl) {
        changeListEventQueue._alive = bl;
    }

    static void mav$cancelListProjects(ChangeListEventQueue changeListEventQueue) {
        changeListEventQueue.cancelListProjects();
    }

    static ChangeList ra$_changeList(ChangeListEventQueue changeListEventQueue) {
        return changeListEventQueue._changeList;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ boolean v$isBusy;
        final /* synthetic */ ChangeListEventQueue this$0;

        public void run() {
            ChangeListEventQueue.ra$_changeList(this.this$0).setBusy(this.v$isBusy);
        }

        public 1(ChangeListEventQueue changeListEventQueue, boolean bl) {
            this.v$isBusy = bl;
            this.this$0 = changeListEventQueue;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ ChangeListEvent v$cle;
        private final /* synthetic */ ArrayList v$validItems;
        private final /* synthetic */ Collection v$invalidItems;
        final /* synthetic */ ChangeListEventQueue this$0;

        public void run() {
            if (this.v$cle.isReplace()) {
                ChangeListEventQueue.ra$_changeList(this.this$0).getModel().replace(this.v$validItems);
                return;
            }
            ChangeListEventQueue.ra$_changeList(this.this$0).getModel().remove(this.v$invalidItems);
            ChangeListEventQueue.ra$_changeList(this.this$0).getModel().add(this.v$validItems);
            if (this.v$cle.isUpdate()) {
                ChangeListEventQueue.ra$_changeList(this.this$0).getModel().update(this.v$validItems);
            }
        }

        public 2(ChangeListEventQueue changeListEventQueue, ChangeListEvent changeListEvent, ArrayList arrayList, Collection collection) {
            this.v$invalidItems = collection;
            this.v$validItems = arrayList;
            this.v$cle = changeListEvent;
            this.this$0 = changeListEventQueue;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ URL[] v$urls;
        private final /* synthetic */ VCSOverlayItem[] v$overlayItems;
        final /* synthetic */ ChangeListEventQueue this$0;

        public void run() {
            int i = 0;
            while (i < ChangeListEventQueue.ra$_changeList(this.this$0).getModel().getCount()) {
                ChangeListItem changeListItem = (ChangeListItem)ChangeListEventQueue.ra$_changeList(this.this$0).getModel().getItem(i);
                int j = Arrays.asList(this.v$urls).indexOf(changeListItem.getURL());
                if (j >= 0) {
                    changeListItem.setOverlay(this.v$overlayItems[j].getOverlay());
                    ChangeListEventQueue.ra$_changeList(this.this$0).getModel().update(Collections.singleton(changeListItem));
                }
                ++i;
            }
        }

        public 3(ChangeListEventQueue changeListEventQueue, URL[] uRLArray, VCSOverlayItem[] vCSOverlayItemArray) {
            this.v$overlayItems = vCSOverlayItemArray;
            this.v$urls = uRLArray;
            this.this$0 = changeListEventQueue;
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            try {
                ChangeListEventQueue.mav$eventLoop(ChangeListEventQueue.this);
            }
            catch (InterruptedException ie) {
                Assert.printStackTrace((Throwable)ie);
            }
            ChangeListEventQueue.wa$_alive(ChangeListEventQueue.this, false);
            ChangeListEventQueue.mav$cancelListProjects(ChangeListEventQueue.this);
        }
    }
}

