/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.util.VCSNodeIconUtils;

public class ChangeListItem
extends DefaultElement
implements Locatable {
    private final URL _url;
    private final Project _project;
    private IconOverlay _overlay;
    private Icon _icon;

    @Deprecated
    public ChangeListItem(URL url, IconOverlay overlay) {
        this(url, null, overlay);
    }

    ChangeListItem(URL url, Project project, IconOverlay overlay) {
        this._url = url;
        this._project = project;
        this.setOverlay(overlay);
    }

    public Node findNode() {
        return NodeFactory.find((URL)this._url);
    }

    public Node findOrCreateNode() throws IllegalAccessException, InstantiationException {
        return NodeFactory.findOrCreate((URL)this._url);
    }

    public Icon getIcon() {
        return this._icon;
    }

    public String getShortLabel() {
        return URLFileSystem.getFileName((URL)this._url);
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (o instanceof ChangeListItem) {
            return ((ChangeListItem)((Object)o)).getURL().equals(this.getURL());
        }
        return false;
    }

    public int hashCode() {
        return this.getURL().hashCode();
    }

    public IconOverlay getOverlay() {
        return this._overlay;
    }

    public void setOverlay(IconOverlay overlay) {
        this._overlay = overlay;
        this.createIcon();
    }

    public Project getProject() {
        return this._project;
    }

    private void createIcon() {
        Node n = this.findNode();
        Icon baseIcon = null;
        if (baseIcon == null && n != null) {
            baseIcon = n.getIcon();
        }
        if (baseIcon == null) {
            baseIcon = VCSNodeIconUtils.getIconForURL(this._url);
        }
        if (this._overlay == null) {
            this._icon = baseIcon;
            return;
        }
        try {
            this._icon = new OverlayIcon(baseIcon, this._overlay.getDisplayable().getIcon());
        }
        catch (Exception e) {
            this._icon = baseIcon;
        }
    }
}

