/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public class ChangeListProjectContent {
    private static final URLPath EMPTY_PATH = new URLPath();
    private final Project _project;
    private ContentSet _contentSet;
    private URL[] _urls;

    public ChangeListProjectContent(Project project) {
        this._project = project;
    }

    public URL[] getBaseDirectoryURLs() throws InterruptedException {
        return this.getBaseURLPath().getEntries();
    }

    public URLPath getBaseURLPath() throws InterruptedException {
        return this._project.isOpen() ? this.getContentSet().getAllRootDirs() : EMPTY_PATH;
    }

    public URL[] listURLs(boolean includeDirs, VCSCancellable cancellable) throws InterruptedException {
        if (!this._project.isOpen()) {
            return new URL[0];
        }
        if (this._urls == null) {
            this._urls = this._listURLs(includeDirs, cancellable);
        }
        return this._urls;
    }

    public boolean canHaveMember(URL url) throws Exception {
        if (!this._project.isOpen()) {
            return false;
        }
        if (URLFileSystem.equals((URL)URLFileSystem.getParent((URL)url), (URL)URLFileSystem.getParent((URL)this._project.getURL()))) {
            return (GlobalIgnoreList.isGloballyIgnored((URL)url) || URLFileSystem.isDirectoryPath((URL)url)) ^ true;
        }
        return this.getContentSet().canHaveMember(url);
    }

    private URL[] _listURLs(boolean includeDirs, VCSCancellable cancellable) throws InterruptedException {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        if (includeDirs) {
            List directoryRelPaths = this.getContentSet().getAllRootDirs().getAllDirectories();
            URL projectParentUrl = URLFileSystem.getParent((URL)this._project.getURL());
            urls.add(projectParentUrl);
            Iterator itr = directoryRelPaths.iterator();
            while (itr.hasNext()) {
                URL qualifiedUrl = URLFactory.newURL((URL)projectParentUrl, (String)((String)itr.next()));
                if (qualifiedUrl == null) continue;
                urls.add(qualifiedUrl);
            }
        }
        urls.addAll(Arrays.asList(VCSModelUtils.listProjectURLs(this._project, cancellable)));
        return urls.toArray(new URL[0]);
    }

    private ContentSet getContentSet() throws InterruptedException {
        if (this._contentSet == null) {
            this._contentSet = this.getAllProjectContents(this._project);
        }
        return this._contentSet;
    }

    private ContentSet getAllProjectContents(Project project) throws InterruptedException {
        if (!project.isOpen()) {
            return null;
        }
        try {
            ContentSet[] contentSet = new ContentSet[1];
            EventQueue.invokeAndWait(new 1(this, contentSet, project));
            ContentSet contentSet2 = contentSet[0];
            return contentSet2;
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            ContentSet contentSet = null;
            return contentSet;
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ ContentSet[] v$contentSet;
        private final /* synthetic */ Project v$project;
        final /* synthetic */ ChangeListProjectContent this$0;

        public void run() {
            this.v$contentSet[0] = ProjectContent.getInstance((PropertyStorage)this.v$project).getAllContents();
        }

        public 1(ChangeListProjectContent changeListProjectContent, ContentSet[] contentSetArray, Project project) {
            this.v$project = project;
            this.v$contentSet = contentSetArray;
            this.this$0 = changeListProjectContent;
        }
    }
}

