/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.TabbedWindow;
import oracle.ide.controls.TabbedWindowEvent;
import oracle.ide.controls.TabbedWindowListener;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.ideimpl.controls.FlatTabbedWindow;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListController;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.changelist.ChangeListProjectContent;
import oracle.jdeveloper.vcs.changelist.IdeObserver;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.util.PopupMenuListener;

public class ChangeListWindow
extends DockableWindow {
    private static final HelpInfo F1_HELP_INFO = new HelpInfo("f1_scspendingchanges_html");
    public static final int TOGGLE_COMMENTS_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.ToggleCommentsCommand");
    public static final int COPY_FILE_LIST_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.CopyFileListCommand");
    public static final int OPEN_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.OpenCommand");
    public static final int PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.PreferencesCommand");
    public static final int SET_SCOPE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changelist.SetScopeCommand");
    public static final float CTX_GROUP_CONFLICTS = 1.0f;
    public static final float CTX_GROUP_OPERATIONS = 2.0f;
    public static final float CTX_GROUP_CLIPBOARD = 3.0f;
    public static final float CTX_GROUP_DIFF = 4.0f;
    public static final float CTX_GROUP_GENERAL = 5.0f;
    public static final float CTX_GROUP_SELECT_IN_NAV = 10.0f;
    private JPanel _panel;
    private final Controller _controller;
    private ChangeList[] _changeLists;
    private Listener _listener;
    private PropertyChangeListener _propertyChangeListener;
    private Toolbar _toolbar;
    private ContextMenu _contextMenu;
    private ChangeListener _globalIgnoreListListener;
    private IdeListener _ideListener;
    private final String _persistenceKey;
    private ToggleToolButton _toggleToolButton;
    private List _persistenceKeys;
    private Object[] _modeIds;
    private JLabel _busyLabel;
    private Object _modeId;
    private FlatTabbedWindow _tabbedWindow;
    private JComboBox _scopeComboBox;
    private DefaultComboBoxModel _scopeComboBoxModel;
    private IdeObserver _scopeIdeObserver;
    private PropertyChangeListener _multiPropertyChangeListener;
    private static final ScopeFilter ALL_APPLICATIONS_SCOPE = new ScopeFilter();
    private static final ScopeFilter ACTIVE_APPLICATION_SCOPE = new 1();
    private ItemListener _scopeFilterListener;

    private void $init$() {
        this._ideListener = null;
        Ide.getSystem().attach((Observer)new 2());
        ACTIVE_APPLICATION_SCOPE.setWorkspace(Ide.getActiveWorkspace());
        this._scopeFilterListener = new 6();
    }

    static {
        ChangeListWindow.createActions();
    }

    private static void createActions() {
        IdeAction toggleCommentsAction = IdeAction.get((int)TOGGLE_COMMENTS_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.ToggleCommentsCommand", (String)VCSArb.getString(237), (ArrayResourceBundle)VCSArb.getInstance(), (int)126);
        toggleCommentsAction.putValue("Check", (Object)Boolean.TRUE);
        IdeAction.get((int)COPY_FILE_LIST_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.CopyFileListCommand", (String)VCSArb.getString(193));
        IdeAction.get((int)OPEN_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.OpenCommand", (String)VCSArb.getString(84), null, (Integer)new Integer(VCSArb.getMnemonic(114)), null, null, (boolean)true);
        IdeAction.get((int)PREFERENCES_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.PreferencesCommand", (String)VCSArb.getString(76), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, null, (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)true);
        IdeAction.get((int)SET_SCOPE_CMD_ID, (String)"oracle.jdeveloper.vcs.changelist.SetScopeCommand", (String)VCSArb.getString(27), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, null, (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)true);
    }

    public ChangeListWindow(ChangeList changeList, String windowID) {
        this(new ChangeList[]{changeList}, windowID);
    }

    protected ChangeListWindow(ChangeList[] changeLists, String windowID) {
        super(windowID);
        this.$init$();
        this._persistenceKey = this.createDisplayPersistenceKey(changeLists[0]);
        this._changeLists = changeLists;
        IdeAction.find((int)TOGGLE_COMMENTS_CMD_ID).setState(changeLists[0].isOptionsVisible());
        this._controller = this.createController();
        this.setType(32);
        this._busyLabel = new JLabel();
        this._busyLabel.setIcon(VCSArb.getIcon(203));
        this._scopeComboBoxModel = new DefaultComboBoxModel();
        this._scopeComboBox = new JComboBox(this._scopeComboBoxModel);
        3 renderer = new 3();
        this._scopeComboBox.setRenderer(renderer);
        Dimension d = new Dimension(SwingUtilities.computeStringWidth(renderer.getFontMetrics(renderer.getFont()), "ReasonablyLongApplicationNameWithIcon.jws"), this._scopeComboBox.getPreferredSize().height);
        this._scopeComboBox.setMaximumSize(d);
        this._scopeComboBox.setPreferredSize(d);
        this._scopeComboBox.setMinimumSize(d);
        this._scopeIdeObserver = new 4();
        if (this.isMulti()) {
            this.constructMulti();
        }
        this.prefsChanged();
        this.updateScopeFilter();
    }

    protected String[] getPreferencesPath() {
        ChangeList changeList = this.getContextChangeList();
        return changeList != null ? changeList.getPreferencesPath() : null;
    }

    private void constructMulti() {
        this._modeIds = new Object[this._changeLists.length];
        int i = 0;
        while (i < this._changeLists.length) {
            this._modeIds[i] = this._changeLists[i].getModeId();
            ++i;
        }
        this._persistenceKeys = new ArrayList();
        int i2 = 0;
        while (i2 < this._modeIds.length) {
            this._persistenceKeys.add(this.createDisplayPersistenceKey(this._modeIds[i2]));
            ++i2;
        }
        this._tabbedWindow = new FlatTabbedWindow(this.isTabCloseable());
        this._tabbedWindow.getCustomTab().setGapBeforeTabs(-1);
        int i3 = 0;
        while (i3 < this._modeIds.length) {
            ChangeList changeList = this.getChangeList(this._modeIds[i3]);
            changeList.putClientProperty(this.getModePersistenceKey(), this._modeIds[i3]);
            String key = this.getTabToggleKey(changeList);
            if (key == null || Ide.getDTCache().getBoolean(key, true)) {
                this.addToTabbedWindow(this.createModeText(changeList), changeList);
            }
            ++i3;
        }
        this._tabbedWindow.addTabbedWindowListener((TabbedWindowListener)new ModeTabbedWindowListener(null));
        Object modeId = this.getPersistedMode();
        if (modeId == null) {
            modeId = this._modeIds[0];
        }
        this.setModeId(modeId);
        IdeAction showDropdownAction = IdeAction.find((int)EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
        if (showDropdownAction != null) {
            showDropdownAction.addController(this.getController());
        }
        ChangeList[] changeListArray = this.getChangeLists();
        int n = 0;
        while (n < changeListArray.length) {
            ChangeList changeList = changeListArray[n];
            if (this.getTabToggleKey(changeList) != null) {
                this.getTabbedWindow().getCustomTab().addMouseListener((MouseListener)new 5());
                break;
            }
            ++n;
        }
    }

    private boolean isTabCloseable() {
        ChangeList[] changeListArray = this.getChangeLists();
        int n = 0;
        while (n < changeListArray.length) {
            ChangeList changeList = changeListArray[n];
            if (this.getTabToggleKey(changeList) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void addToTabbedWindow(String modeText, ChangeList changelist) {
        this.getTabbedWindow().add(modeText, null, (Component)changelist, modeText, (Object)changelist, false);
        CustomTab customTab = this.getTabbedWindow().getCustomTab();
        customTab.getPage(customTab.getPageCount() - 1).setCloseable(this.getTabToggleKey(changelist) != null);
    }

    protected String getTabToggleKey(ChangeList changeList) {
        return changeList.getTabToggleKey();
    }

    private void updateScopeFilter() {
        ScopeFilter scopeFilter = (ScopeFilter)this._scopeComboBox.getSelectedItem();
        if (scopeFilter != null) {
            ChangeList[] changeListArray = this._changeLists;
            int n = 0;
            while (n < changeListArray.length) {
                ChangeList changeList = changeListArray[n];
                changeList.setScopeFilter(scopeFilter);
                ++n;
            }
            Ide.getDTCache().putString(this.getScopePersistenceKey(), scopeFilter.toExternalForm());
        }
    }

    private void updateScopeComboBoxModel() {
        this._scopeComboBox.removeItemListener(this._scopeFilterListener);
        Object o = this._scopeComboBox.getSelectedItem();
        DefaultComboBoxModel<ScopeFilter> scopeComboBoxModel = new DefaultComboBoxModel<ScopeFilter>();
        scopeComboBoxModel.addElement(ACTIVE_APPLICATION_SCOPE);
        scopeComboBoxModel.addElement(ALL_APPLICATIONS_SCOPE);
        7 nodeComparator = new 7();
        Workspace[] workspaces = VCSModelUtils.findCachedWorkspaces();
        Arrays.sort(workspaces, nodeComparator);
        Project[] projects0 = VCSModelUtils.findCachedProjects();
        Arrays.sort(projects0, nodeComparator);
        ArrayList<Project> projects = new ArrayList<Project>(Arrays.asList(projects0));
        Workspace[] workspaceArray = workspaces;
        int n = 0;
        while (n < workspaceArray.length) {
            Workspace workspace = workspaceArray[n];
            scopeComboBoxModel.addElement(new ScopeFilter(workspace));
            for (Project project : projects) {
                if (!workspace.containsChild((Element)project)) continue;
                scopeComboBoxModel.addElement(new ScopeFilter(project));
            }
            ++n;
        }
        this._scopeComboBox.setModel(scopeComboBoxModel);
        this._scopeComboBoxModel = scopeComboBoxModel;
        this._scopeComboBox.setSelectedItem(o);
        this._scopeComboBox.addItemListener(this._scopeFilterListener);
        this.updateScopeFilter();
    }

    boolean isMulti() {
        return this._changeLists.length > 1;
    }

    FlatTabbedWindow getTabbedWindow() {
        return this._tabbedWindow;
    }

    private ChangeList[] getChangeLists() {
        return this._changeLists;
    }

    public boolean isChangeListVisible(ChangeList changeList) {
        TabbedWindow.PageInfo[] pageInfoArray = this.getTabbedWindow().getPages();
        int n = 0;
        while (n < pageInfoArray.length) {
            TabbedWindow.PageInfo pageInfo = pageInfoArray[n];
            if (pageInfo._gui == changeList) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected ChangeList[] createChangeLists() {
        return this._changeLists;
    }

    public IdeAction createLocalAction(int cmdId) {
        return this.getLocalAction(cmdId);
    }

    public void prefsChanged() {
        this.updateEllipsisItems();
        this.preferencesChanged();
    }

    protected void updateEllipsisItems() {
    }

    protected void preferencesChanged() {
    }

    protected String getModePersistenceKey() {
        return this.getClass().getName() + ".Mode";
    }

    protected String getScopePersistenceKey() {
        return this.getClass().getName() + ".Scope";
    }

    protected String createDisplayPersistenceKey(ChangeList changeList) {
        return this.createDisplayPersistenceKey(changeList.getModeId());
    }

    protected String createDisplayPersistenceKey(Object modeId) {
        String key = this.getClass().getName();
        if (modeId != null) {
            key = key + "." + this.getModePersistenceValue(modeId);
        }
        key = key + ".DisplaySettings";
        return key;
    }

    protected ChangeList getChangeList(Object modeId) {
        if (!this.isMulti()) {
            return this.getChangeList();
        }
        int i = Arrays.asList(this._modeIds).indexOf(modeId);
        return i < 0 ? this.getChangeList() : this._changeLists[i];
    }

    protected String getModePersistenceValue(Object modeId) {
        return modeId.toString();
    }

    protected Object getModePersistenceObject(String value) {
        return value;
    }

    protected ChangeList createChangeList(Object modeId) {
        return new ChangeList(modeId);
    }

    protected Object getModeId() {
        return this._modeId;
    }

    protected void setModeId(Object modeId) {
        this.setModeIdInternal(modeId);
        if (modeId == null) {
            return;
        }
        this._tabbedWindow.setActive((Component)this.getChangeList(modeId));
    }

    private Object getModeIdInternal() {
        return this._modeId;
    }

    private void setModeIdInternal(Object modeId) {
        this._modeId = modeId;
    }

    private String createModeText(ChangeList changeList) {
        return MessageFormat.format("{0}: {1}", changeList.getModeLabel().replaceAll("&", ""), Integer.toString(changeList.getCount()));
    }

    private Object getPersistedMode() {
        String persistedMode = Ide.getDTCache().getString(this.getModePersistenceKey());
        return persistedMode != null ? this.getModePersistenceObject(persistedMode) : null;
    }

    private void updateControlsFromMode() {
        this._updateVisibleToolbarActions(this.getToolbar());
        this.updateVisibleChangeList();
        this.updateStatusMessage();
        this.updateBusyTickerVisible();
        this.updateRefreshEnabled();
        this.updatePersistedMode();
        this.updateEllipsisItems();
        this.updateVisibleActions();
    }

    private void updateVisibleChangeList() {
    }

    protected void updateBusyTickerVisible() {
        if (this._busyLabel != null) {
            this._busyLabel.setVisible(this.getContextChangeList().isBusy());
        }
        if (this._toolbar == null) {
            return;
        }
        this._toolbar.validate();
        this._toolbar.invalidate();
        this._toolbar.repaint();
    }

    private void updateRefreshEnabled() {
        this.getController().update(this.getLocalAction(51), this.getContext());
    }

    private void updatePersistedMode() {
        Ide.getDTCache().putString(this.getModePersistenceKey(), this.getModePersistenceValue(this.getModeIdInternal()));
    }

    private JPanel getPanel() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this.layoutPanel(this._panel);
        }
        return this._panel;
    }

    protected void layoutPanel(JPanel panel) {
        panel.setLayout(new BorderLayout());
        if (!this.isMulti()) {
            panel.add((Component)this._changeLists[0], "Center");
        } else {
            panel.add((Component)this._tabbedWindow, "Center");
        }
    }

    protected Controller createController() {
        return new 8();
    }

    public ChangeList getChangeList() {
        return this._changeLists[0];
    }

    public ChangeList getContextChangeList() {
        return this.getChangeList(this.getModeIdInternal());
    }

    protected void setEllipsisVisible(IdeAction localAction, boolean visible) {
        String text = (String)localAction.getValue("Name");
        boolean hasEllipsis = text.endsWith("...");
        if (hasEllipsis && !visible) {
            localAction.putValueDirectly("Name", (Object)text.substring(0, text.length() - 3));
        } else if (!hasEllipsis && visible) {
            localAction.putValueDirectly("Name", (Object)(text + "..."));
        }
    }

    protected IdeAction getLocalAction(int cmdId) {
        IdeAction ideAction = IdeAction.find((int)cmdId);
        if (ideAction != null) {
            IdeAction local = ideAction.newLocalAction((View)this);
            return local;
        }
        throw new IllegalArgumentException("CMDID " + cmdId + " not found");
    }

    public HelpInfo getHelpInfo() {
        return F1_HELP_INFO;
    }

    public Icon getTabIcon() {
        return VCSIconArb.getIcon(18);
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public String getTitleName() {
        return VCSArb.getString(233);
    }

    public final Controller getController() {
        return this._controller;
    }

    public Component getGUI() {
        return this.getPanel();
    }

    public final Context getContext(EventObject eo) {
        Context context = super.getContext(eo);
        Element[] selection = this.getContextChangeList().getSelection();
        Project[] projects = new Project[selection.length];
        int i = 0;
        while (i < selection.length) {
            if (selection[i] instanceof ChangeListItem) {
                ChangeListItem changeListItem = (ChangeListItem)selection[i];
                projects[i] = changeListItem.getProject();
                Node n = changeListItem.findNode();
                if (n != null) {
                    selection[i] = n;
                }
                if (projects[i] == null && n instanceof Project) {
                    projects[i] = (Project)n;
                }
            }
            ++i;
        }
        context.setSelection(selection);
        if (selection.length == 1) {
            context.setNode(selection[0] instanceof Node ? (Node)selection[0] : null);
            Project project = projects[0] != null ? projects[0] : context.getProject();
            context.setProject(project);
            context.setWorkspace(project != null ? this.findWorkspaceForProject(project) : context.getWorkspace());
        } else {
            ArrayList<Context> contexts = new ArrayList<Context>();
            int i2 = 0;
            while (i2 < selection.length) {
                if (selection[i2] != null) {
                    Context context2 = new Context(context);
                    context2.setNode(selection[i2] instanceof Node ? (Node)selection[i2] : null);
                    context2.setSelection(new Element[]{selection[i2]});
                    Project project = projects[i2] != null ? projects[i2] : context2.getProject();
                    context2.setProject(project);
                    context2.setWorkspace(project != null ? this.findWorkspaceForProject(project) : context2.getWorkspace());
                    contexts.add(context2);
                }
                ++i2;
            }
            context.setProperty("ChangeListWindow.CONTEXTS", (Object)contexts.toArray(new Context[0]));
        }
        return context;
    }

    private Workspace findWorkspaceForProject(Project project) {
        Workspace[] workspaceArray = VCSModelUtils.findCachedWorkspaces();
        int n = 0;
        while (n < workspaceArray.length) {
            Workspace workspace = workspaceArray[n];
            if (workspace.isOpen() && workspace.projects().contains(project)) {
                return workspace;
            }
            ++n;
        }
        return null;
    }

    protected Element[] getSelectionFromUI() {
        return this.getContextChangeList().getSelection();
    }

    public boolean isActive() {
        return this._listener != null;
    }

    public final void dockableShown(DockableEvent event) {
        super.dockableShown(event);
        this.initialize();
    }

    protected boolean authenticate() {
        return true;
    }

    public void refresh() {
        if (this._listener == null) {
            return;
        }
        int i = 0;
        while (i < this.getChangeLists().length) {
            this.getChangeLists()[i].refresh();
            ++i;
        }
    }

    protected void addToolbarToPanel(JPanel panel, Toolbar toolbar) {
        panel.add((Component)toolbar, "North");
    }

    protected void removeToolbarFromPanel(JPanel panel, Toolbar toolbar) {
        if (toolbar != null) {
            panel.remove((Component)toolbar);
        }
    }

    private void addChangeListListener(ChangeList changeList) {
        String persistenceKey;
        changeList.addSelectionListener(this._listener);
        changeList.addMouseListener(this._listener);
        if (changeList.getOptionsCustomizer() instanceof ChangeListCommentsCustomizer) {
            ChangeListCommentsCustomizer customizer = (ChangeListCommentsCustomizer)changeList.getOptionsCustomizer();
            customizer.addCaretListener(this._listener);
            customizer.addFocusListener(this._listener);
        }
        if ((persistenceKey = this.getPersistenceKey(changeList)) != null) {
            changeList.depersistVisualSettings(persistenceKey);
        }
    }

    protected String getPersistenceKey(ChangeList changeList) {
        if (!this.isMulti()) {
            return this._persistenceKey;
        }
        int i = Arrays.asList(this._modeIds).indexOf(changeList.getModeId());
        return i < 0 ? null : (String)this._persistenceKeys.get(i);
    }

    public void stateChange(int newState) {
        if (newState == 3) {
            EventQueue.invokeLater(new 9());
        }
        super.stateChange(newState);
    }

    protected void initialize() {
        if (this._listener != null) {
            return;
        }
        this.addToolbarToPanel(this.getPanel(), this.getToolbar());
        this._propertyChangeListener = new PropertyListener(null);
        int i = 0;
        while (i < this.getChangeLists().length) {
            this.getChangeLists()[i].addPropertyChangeListener(this._propertyChangeListener);
            ++i;
        }
        if (this.isMulti()) {
            this._multiPropertyChangeListener = new MultiPropertyListener(null);
            int i2 = 0;
            while (i2 < this._modeIds.length) {
                this.getChangeList(this._modeIds[i2]).addPropertyChangeListener(this._multiPropertyChangeListener);
                ++i2;
            }
        }
        if (!this.isMulti()) {
            this.getChangeList().initializeChangeList();
        } else {
            int i3 = 0;
            while (i3 < this._modeIds.length) {
                this.getChangeList(this._modeIds[i3]).initializeChangeList();
                ++i3;
            }
        }
        if (this.isMulti()) {
            this.updateControlsFromMode();
        }
        this.updateScopeComboBoxModel();
        String scopeExternalForm = Ide.getDTCache().getString(this.getScopePersistenceKey());
        if (scopeExternalForm == null) {
            scopeExternalForm = ACTIVE_APPLICATION_SCOPE.toExternalForm();
        }
        int i4 = 0;
        while (i4 < this._scopeComboBox.getItemCount()) {
            ScopeFilter scopeFilter = (ScopeFilter)this._scopeComboBox.getItemAt(i4);
            if (scopeFilter.toExternalForm().equals(scopeExternalForm)) {
                this._scopeComboBox.setSelectedItem(scopeFilter);
                break;
            }
            ++i4;
        }
        if (this._scopeComboBox.getSelectedItem() == null) {
            this._scopeComboBox.setSelectedItem(ACTIVE_APPLICATION_SCOPE);
        }
        this._scopeIdeObserver.startObserving();
        this.delayedInitialization();
        int i5 = 0;
        while (i5 < this.getChangeLists().length) {
            this.getChangeLists()[i5].start();
            ++i5;
        }
        this._listener = new Listener(null);
        int i6 = 0;
        while (i6 < this.getChangeLists().length) {
            this.addChangeListListener(this.getChangeLists()[i6]);
            ++i6;
        }
        this._globalIgnoreListListener = new GlobalIgnoreListListener(null);
        ((ChangeEventSource)Ide.getSettings().getData("global-ignore-list")).addChangeListener(this._globalIgnoreListListener);
        this._ideListener = new MainWindowClosingListener(null);
        Ide.addIdeListener((IdeListener)this._ideListener);
    }

    protected void deinitialize() {
        if (this._listener != null) {
            int i = 0;
            while (i < this.getChangeLists().length) {
                this.removeChangeListListener(this.getChangeLists()[i]);
                ++i;
            }
            this._listener = null;
        }
        if (this._ideListener != null) {
            Ide.removeIdeListener((IdeListener)this._ideListener);
            this._ideListener = null;
        }
        if (this._globalIgnoreListListener != null) {
            ((ChangeEventSource)Ide.getSettings().getData("global-ignore-list")).removeChangeListener(this._globalIgnoreListListener);
            this._globalIgnoreListListener = null;
        }
        int i = 0;
        while (i < this.getChangeLists().length) {
            this.getChangeLists()[i].stop();
            ++i;
        }
        if (this._propertyChangeListener != null) {
            int i2 = 0;
            while (i2 < this.getChangeLists().length) {
                this.getChangeLists()[i2].removePropertyChangeListener(this._propertyChangeListener);
                ++i2;
            }
            this._propertyChangeListener = null;
        }
        if (this.isMulti() && this._multiPropertyChangeListener != null) {
            int i3 = 0;
            while (i3 < this._modeIds.length) {
                this.getChangeList(this._modeIds[i3]).removePropertyChangeListener(this._multiPropertyChangeListener);
                ++i3;
            }
            this._multiPropertyChangeListener = null;
        }
        if (this._toolbar != null) {
            this._toolbar.removeAll();
            this.removeToolbarFromPanel(this.getPanel(), this._toolbar);
            this._toolbar = null;
        }
        if (this._contextMenu != null) {
            this.removeContextMenuListeners(this._contextMenu);
            this._contextMenu = null;
        }
        this._toggleToolButton = null;
        this._scopeComboBox.removeItemListener(this._scopeFilterListener);
        this._scopeComboBoxModel.removeAllElements();
        this._scopeIdeObserver.stopObserving();
        this.postDeinitialization();
    }

    protected void delayedInitialization() {
    }

    protected void postDeinitialization() {
    }

    private void removeChangeListListener(ChangeList changeList) {
        String persistenceKey = this.getPersistenceKey(changeList);
        if (persistenceKey != null) {
            changeList.persistVisualSettings(persistenceKey);
        }
        changeList.removeSelectionListener(this._listener);
        changeList.removeMouseListener(this._listener);
        if (changeList.getOptionsCustomizer() instanceof ChangeListCommentsCustomizer) {
            ChangeListCommentsCustomizer customizer = (ChangeListCommentsCustomizer)changeList.getOptionsCustomizer();
            customizer.removeCaretListener(this._listener);
            customizer.removeFocusListener(this._listener);
        }
    }

    public final Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            this._toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.addToolbarActions(this._toolbar);
            this._toolbar.setFocusCycleRoot(true);
            this._toolbar.setFocusable(true);
            this._toolbar.setFocusTraversalPolicy((FocusTraversalPolicy)new 10());
        }
        return this._toolbar;
    }

    public final ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu(new MnemonicSolver());
            this.addContextMenuListeners(this._contextMenu);
        }
        return this._contextMenu;
    }

    protected void addContextMenuListeners(ContextMenu contextMenu) {
        if (!this.isMulti()) {
            this.getChangeList().addContextMenuListeners(contextMenu);
        } else {
            int i = 0;
            while (i < this._modeIds.length) {
                this.getChangeList(this._modeIds[i]).addContextMenuListeners(contextMenu);
                ++i;
            }
        }
    }

    protected void removeContextMenuListeners(ContextMenu contextMenu) {
        if (!this.isMulti()) {
            this.getChangeList().removeContextMenuListeners(contextMenu);
        } else {
            int i = 0;
            while (i < this._modeIds.length) {
                this.getChangeList(this._modeIds[i]).removeContextMenuListeners(contextMenu);
                ++i;
            }
        }
    }

    protected void addToolbarActions(Toolbar toolbar) {
        if (!this.isMulti()) {
            toolbar.add((Component)this._scopeComboBox);
            toolbar.add((ToggleAction)this.createLocalAction(51));
            toolbar.addSeparator();
            this.addCommentsToolbarAction(toolbar);
            if (!(toolbar.getComponentAtIndex(toolbar.getComponentCount() - 1) instanceof JToolBar.Separator)) {
                toolbar.addSeparator();
            }
            toolbar.add((Component)this._busyLabel);
            this.updateBusyTickerVisible();
            return;
        }
        this._updateVisibleToolbarActions(toolbar);
    }

    private void _updateVisibleToolbarActions(Toolbar toolbar) {
        toolbar.removeAll();
        this.updateVisibleToolbarActions(toolbar);
        if (toolbar.getComponentCount() > 0) {
            toolbar.add((Component)toolbar.newSeparator(), 0);
        }
        toolbar.add((Component)this._scopeComboBox, 0);
        if (!this.containsGlue((Container)toolbar)) {
            toolbar.add(Box.createGlue());
        }
        toolbar.add((Component)this._busyLabel);
        toolbar.validate();
        toolbar.invalidate();
        toolbar.repaint();
        this.updateBusyTickerVisible();
    }

    private boolean containsGlue(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component c = componentArray[n];
            if (c instanceof Box.Filler) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void updateVisibleToolbarActions(Toolbar toolbar) {
        toolbar.add((ToggleAction)this.createLocalAction(51));
        toolbar.addSeparator();
        this.getChangeList(this.getModeIdInternal()).addToolbarActions(this, toolbar);
    }

    protected void addCommentsToolbarAction(Toolbar toolbar) {
        if (this._toggleToolButton == null) {
            this._toggleToolButton = new ToggleToolButton((ToggleAction)this.getLocalAction(TOGGLE_COMMENTS_CMD_ID));
        }
        toolbar.add((Component)this._toggleToolButton);
    }

    protected void setCommentsVisible(boolean commentsVisible) {
        this.getChangeList().setOptionsVisible(commentsVisible);
    }

    protected void requestFocusInChangeList() {
        this.getContextChangeList().requestFocusInChangeList();
    }

    protected void requestFocusInComments() {
        this.getContextChangeList().requestFocusInOptions();
    }

    protected String getBusyStatusMessage() {
        return this.getBusyStatusMessage(null);
    }

    protected String getBusyStatusMessage(ChangeList changeList) {
        if (!this.isMulti() || changeList == null) {
            return VCSArb.getString(88);
        }
        return this.getBusyStatusMessage(changeList.getModeId());
    }

    protected String getBusyStatusMessage(Object modeId) {
        return this.getChangeList(modeId).getBusyStatusMessage();
    }

    protected void updateStatusMessage() {
        ChangeList[] changeLists = this.getChangeLists();
        int i = 0;
        while (i < changeLists.length) {
            if (changeLists[i].isBusy() && changeLists[i].getProgressTask() == null) {
                String message = this.getBusyStatusMessage(changeLists[i]);
                ChangeListProgressTask progressTask = new ChangeListProgressTask(changeLists[i], this.createProgressMessageText(message), this.createProgressTaskText(message));
                changeLists[i].setProgressTask(progressTask);
                Ide.getStatusBar().getProgressTracker().addTask((ProgressTrackedTask)progressTask);
            }
            ++i;
        }
    }

    private String createProgressMessageText(String message) {
        return message.endsWith("...") ? message.substring(0, message.length() - 3) : message;
    }

    private String createProgressTaskText(String message) {
        return this.getTitleName() + ": " + message;
    }

    void doSetScope() {
        this._scopeComboBox.requestFocus();
        this._scopeComboBox.showPopup();
    }

    static ScopeFilter ra$ALL_APPLICATIONS_SCOPE() {
        return ALL_APPLICATIONS_SCOPE;
    }

    static ScopeFilter ra$ACTIVE_APPLICATION_SCOPE() {
        return ACTIVE_APPLICATION_SCOPE;
    }

    static void mav$setModeIdInternal(ChangeListWindow changeListWindow, Object object) {
        changeListWindow.setModeIdInternal(object);
    }

    static void mav$updateControlsFromMode(ChangeListWindow changeListWindow) {
        changeListWindow.updateControlsFromMode();
    }

    static void mav$updateRefreshEnabled(ChangeListWindow changeListWindow) {
        changeListWindow.updateRefreshEnabled();
    }

    static FlatTabbedWindow ra$_tabbedWindow(ChangeListWindow changeListWindow) {
        return changeListWindow._tabbedWindow;
    }

    static String mav$createModeText(ChangeListWindow changeListWindow, ChangeList changeList) {
        return changeListWindow.createModeText(changeList);
    }

    static ChangeList[] mav$getChangeLists(ChangeListWindow changeListWindow) {
        return changeListWindow.getChangeLists();
    }

    static void mav$updateScopeFilter(ChangeListWindow changeListWindow) {
        changeListWindow.updateScopeFilter();
    }

    static JComboBox ra$_scopeComboBox(ChangeListWindow changeListWindow) {
        return changeListWindow._scopeComboBox;
    }

    static void mav$addToTabbedWindow(ChangeListWindow changeListWindow, String string, ChangeList changeList) {
        changeListWindow.addToTabbedWindow(string, changeList);
    }

    static void mav$updateScopeComboBoxModel(ChangeListWindow changeListWindow) {
        changeListWindow.updateScopeComboBoxModel();
    }

    static final class 1
    extends ScopeFilter {
        public boolean accept(URL url) {
            return this.getWorkspace() != null && super.accept(url);
        }
    }

    final class 2
    implements Observer {
        public void update(Object observed, UpdateMessage change) {
            if (change.getMessageID() != IdeConstants.ACTIVE_PROJECT_CHANGED) {
                return;
            }
            Workspace workspace = (Workspace)change.getModifyObjects().get(1);
            if (workspace == ChangeListWindow.ra$ACTIVE_APPLICATION_SCOPE().getWorkspace()) {
                return;
            }
            ChangeListWindow.ra$ACTIVE_APPLICATION_SCOPE().setWorkspace(workspace);
            if (ChangeListWindow.ra$_scopeComboBox(ChangeListWindow.this).getSelectedItem() != null && ChangeListWindow.ra$_scopeComboBox(ChangeListWindow.this).getSelectedItem() != ChangeListWindow.ra$ACTIVE_APPLICATION_SCOPE()) {
                return;
            }
            ChangeList[] changeListArray = ChangeListWindow.mav$getChangeLists(ChangeListWindow.this);
            int n = 0;
            while (n < changeListArray.length) {
                ChangeList changeList = changeListArray[n];
                changeList.refresh();
                ++n;
            }
        }
    }

    static class ScopeFilter
    implements URLFilter {
        private Workspace _workspace;
        private Project _project;
        private final Map _projectContentCache;

        private void $init$() {
            this._projectContentCache = Collections.synchronizedMap(new WeakHashMap());
        }

        ScopeFilter() {
            this(null, null);
        }

        ScopeFilter(Project project) {
            this(null, project);
        }

        ScopeFilter(Workspace workspace) {
            this(workspace, null);
        }

        private ScopeFilter(Workspace workspace, Project project) {
            this.$init$();
            this._workspace = workspace;
            this._project = project;
        }

        Workspace getWorkspace() {
            return this._workspace;
        }

        void setWorkspace(Workspace workspace) {
            this._workspace = workspace;
        }

        String getShortLabel() {
            return this._workspace != null ? this._workspace.getShortLabel() : (this._project != null ? this._project.getShortLabel() : null);
        }

        Icon getIcon() {
            return this._workspace != null ? this._workspace.getIcon() : (this._project != null ? this._project.getIcon() : null);
        }

        public boolean accept(URL url) {
            try {
                if (this._project != null) {
                    boolean bl = this.getProjectContent(this._project).canHaveMember(url);
                    return bl;
                }
                if (this._workspace != null) {
                    if (!this._workspace.isOpen()) {
                        boolean bl = false;
                        return bl;
                    }
                    Iterator itr = this._workspace.getChildren();
                    while (itr.hasNext()) {
                        Object o = itr.next();
                        if (o instanceof Project && this.getProjectContent((Project)o).canHaveMember(url)) {
                            boolean bl = true;
                            return bl;
                        }
                        URL url2 = VCSModelUtils.getLocatableURL(o);
                        if (url2 == null || !URLFileSystem.equals((URL)url, (URL)url2)) continue;
                        boolean bl = GlobalIgnoreList.isGloballyIgnored((URL)url) ^ true;
                        return bl;
                    }
                    if (GlobalIgnoreList.isGloballyIgnored((URL)url)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (URLFileSystem.equals((URL)this._workspace.getURL(), (URL)url)) {
                        boolean bl = true;
                        return bl;
                    }
                    for (String path : ChangeListEventQueue.getWorkspaceArtifacts()) {
                        if (!URLFileSystem.isBaseURLFor((URL)URLFactory.newURL((URL)URLFileSystem.getParent((URL)this._workspace.getURL()), (String)path), (URL)url)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return GlobalIgnoreList.isGloballyIgnored((URL)url) ^ true;
        }

        private synchronized ChangeListProjectContent getProjectContent(Project project) {
            ChangeListProjectContent content = (ChangeListProjectContent)this._projectContentCache.get(project);
            if (content != null) {
                return content;
            }
            content = new ChangeListProjectContent(project);
            this._projectContentCache.put(project, content);
            return content;
        }

        String toExternalForm() {
            Node node;
            if (this == ChangeListWindow.ra$ALL_APPLICATIONS_SCOPE()) {
                return "ALL_APPLICATIONS";
            }
            if (this == ChangeListWindow.ra$ACTIVE_APPLICATION_SCOPE()) {
                return "ACTIVE_APPLICATION";
            }
            Object object = this._workspace != null ? (Node)this._workspace : (node = this._project != null ? this._project : null);
            if (node != null) {
                return node.getURL().toExternalForm();
            }
            throw new IllegalStateException();
        }

        synchronized void clearCache() {
            this._projectContentCache.clear();
        }
    }

    final class 3
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            if (value instanceof String) {
                return this;
            }
            if (value == ChangeListWindow.ra$ALL_APPLICATIONS_SCOPE()) {
                this.setText(VCSArb.getString(213));
                this.setIcon(OracleIcons.getIcon((String)"applications.png"));
            } else if (value == ChangeListWindow.ra$ACTIVE_APPLICATION_SCOPE()) {
                this.setText(VCSArb.getString(140));
                this.setIcon(OracleIcons.getIcon((String)"application.png"));
            } else {
                ScopeFilter scope = (ScopeFilter)value;
                this.setText(scope.getShortLabel());
                this.setIcon(scope.getIcon());
            }
            return this;
        }
    }

    final class 4
    extends IdeObserver {
        protected void updateImpl(Object source, UpdateMessage updateMessage) {
            int msgId = updateMessage.getMessageID();
            if (!(source != Ide.getWorkspaces() && !(source instanceof Workspace) || msgId != UpdateMessage.CHILD_ADDED && msgId != UpdateMessage.CHILD_REMOVED)) {
                EventQueue.invokeLater(new 1());
            }
        }

        final class 1
        implements Runnable {
            public void run() {
                ChangeListWindow.mav$updateScopeComboBoxModel(ChangeListWindow.this);
            }
        }
    }

    final class 5
    extends MouseAdapter {
        private void doIt(MouseEvent me) {
            if (me.isPopupTrigger()) {
                JPopupMenu menu = this.createSelectorMenu();
                MenuUtils.showPopupMenu((JPopupMenu)menu, (Component)ChangeListWindow.this.getTabbedWindow().getCustomTab(), (int)me.getX(), (int)me.getY());
            }
        }

        public void mouseClicked(MouseEvent me) {
            this.doIt(me);
        }

        public void mouseReleased(MouseEvent me) {
            this.doIt(me);
        }

        public void mousePressed(MouseEvent me) {
            this.doIt(me);
        }

        private JPopupMenu createSelectorMenu() {
            JPopupMenu popup = new JPopupMenu();
            ChangeList[] changeListArray = ChangeListWindow.mav$getChangeLists(ChangeListWindow.this);
            int n = 0;
            while (n < changeListArray.length) {
                ChangeList changeList = changeListArray[n];
                String key = ChangeListWindow.this.getTabToggleKey(changeList);
                JCheckBoxMenuItem mi = new JCheckBoxMenuItem(this.createChangeListToggleAction(changeList, key));
                mi.setSelected(ChangeListWindow.this.isChangeListVisible(changeList));
                mi.setEnabled(key != null);
                popup.add(mi);
                ++n;
            }
            MnemonicSolver mnemonicSolver = new MnemonicSolver(popup);
            mnemonicSolver.solve();
            return popup;
        }

        private Action createChangeListToggleAction(ChangeList changeList, String persistenceKey) {
            return new 1(this, changeList, persistenceKey);
        }

        final class 1
        extends AbstractAction {
            private final ChangeList _changeList;
            private boolean _visible;
            private final /* synthetic */ ChangeList v$changeList;
            private final /* synthetic */ String v$persistenceKey;
            final /* synthetic */ 5 this$0;

            private void $init$() {
                this.putValue("Name", this.v$changeList.getModeLongLabel());
                this._changeList = this.v$changeList;
                this._visible = this.this$0.ChangeListWindow.this.isChangeListVisible(this.v$changeList);
            }

            public void actionPerformed(ActionEvent ae) {
                if (this._visible) {
                    this.this$0.ChangeListWindow.this.getTabbedWindow().removeComponent((Component)this._changeList);
                } else {
                    ChangeListWindow.mav$addToTabbedWindow(this.this$0.ChangeListWindow.this, ChangeListWindow.mav$createModeText(this.this$0.ChangeListWindow.this, this._changeList), this._changeList);
                }
                this._visible ^= true;
                if (this.v$persistenceKey != null) {
                    Ide.getDTCache().putBoolean(this.v$persistenceKey, this._visible);
                }
            }

            public 1(5 var1_1, ChangeList changeList, String string) {
                this.v$persistenceKey = string;
                this.v$changeList = changeList;
                this.this$0 = var1_1;
                this.$init$();
            }
        }
    }

    final class 6
    implements ItemListener {
        public void itemStateChanged(ItemEvent ie) {
            ChangeListWindow.mav$updateScopeFilter(ChangeListWindow.this);
        }
    }

    final class 7
    implements Comparator {
        public int compare(Node node1, Node node2) {
            return node1.getShortLabel().compareTo(node2.getShortLabel());
        }
    }

    private class ModeTabbedWindowListener
    implements TabbedWindowListener {
        public void activeChanged(TabbedWindowEvent twe) {
            ChangeListWindow.mav$setModeIdInternal(ChangeListWindow.this, ((JComponent)twe.getData()).getClientProperty(ChangeListWindow.this.getModePersistenceKey()));
            ChangeListWindow.mav$updateControlsFromMode(ChangeListWindow.this);
        }

        private ModeTabbedWindowListener() {
        }

        ModeTabbedWindowListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 8
    extends ChangeListController {
        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (context.getView() instanceof ChangeListWindow && cmdId == 51) {
                action.setEnabled(((ChangeListWindow)context.getView()).getContextChangeList().isBusy() ^ true);
                return true;
            }
            return super.update(action, context);
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (context.getView() instanceof ChangeListWindow && cmdId == 51) {
                if (ChangeListWindow.this.authenticate()) {
                    ((ChangeListWindow)context.getView()).getContextChangeList().refresh();
                }
                return true;
            }
            return super.handleEvent(action, context);
        }
    }

    final class 9
    implements Runnable {
        public void run() {
            if (!ChangeListWindow.this.isVisible()) {
                ChangeListWindow.this.deinitialize();
            }
        }
    }

    final class 10
    extends DefaultFocusTraversalPolicy {
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            ChangeList changeList = ChangeListWindow.this.getContextChangeList();
            Component c = changeList != null ? changeList.getFocusComponent() : null;
            return c != null ? c : super.getComponentAfter(focusCycleRoot, aComponent);
        }
    }

    private class PropertyListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent pce) {
            if ("busy".equals(pce.getPropertyName())) {
                ChangeListWindow.this.updateStatusMessage();
                View.updateToolbarActions((Toolbar)ChangeListWindow.this.getToolbar());
            }
            if ("optionsVisible".equals(pce.getPropertyName())) {
                IdeAction.find((int)TOGGLE_COMMENTS_CMD_ID).setState(ChangeListWindow.this.getChangeList().isOptionsVisible());
                View.updateToolbarActions((Toolbar)ChangeListWindow.this.getToolbar());
            }
        }

        private PropertyListener() {
        }

        PropertyListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class MultiPropertyListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent pce) {
            String propertyName = pce.getPropertyName();
            if (propertyName.equals("changeListCount")) {
                this.propertyChangeListCountChange(pce);
            }
            if (propertyName.equals("busy")) {
                this.propertyBusyChange(pce);
            }
        }

        private void propertyChangeListCountChange(PropertyChangeEvent pce) {
            ChangeList changeList = (ChangeList)pce.getSource();
            if (ChangeListWindow.ra$_tabbedWindow(ChangeListWindow.this).getTabPageForComponent((Component)changeList) == null) {
                return;
            }
            String tabLabel = ChangeListWindow.mav$createModeText(ChangeListWindow.this, changeList);
            ChangeListWindow.ra$_tabbedWindow(ChangeListWindow.this).setTabName((Component)changeList, tabLabel);
            ChangeListWindow.ra$_tabbedWindow(ChangeListWindow.this).setTabTooltip((Component)changeList, tabLabel);
            if (pce.getOldValue() != null && ((Integer)pce.getOldValue()).compareTo((Integer)pce.getNewValue()) < 0 && ChangeListWindow.this.getContextChangeList() != changeList) {
                ChangeListWindow.ra$_tabbedWindow(ChangeListWindow.this).highlightPage((Component)changeList);
            }
        }

        private void propertyBusyChange(PropertyChangeEvent pce) {
            ChangeListWindow.this.updateBusyTickerVisible();
            ChangeListWindow.mav$updateRefreshEnabled(ChangeListWindow.this);
        }

        private MultiPropertyListener() {
        }

        MultiPropertyListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Listener
    extends PopupMenuListener
    implements ListSelectionListener,
    CaretListener,
    FocusListener {
        private Listener() {
            super((View)ChangeListWindow.this);
        }

        private void fireViewSelectionChanged() {
            ChangeListWindow.this.updateSelection();
        }

        protected boolean isDefaultAction(MouseEvent me) {
            if (super.isDefaultAction(me)) {
                return ChangeListWindow.this.getContextChangeList().isItemAtPosition(me.getPoint());
            }
            return false;
        }

        public void valueChanged(ListSelectionEvent event) {
            this.fireViewSelectionChanged();
        }

        public void caretUpdate(CaretEvent ce) {
            this.fireViewSelectionChanged();
        }

        public void focusLost(FocusEvent fe) {
            this.fireViewSelectionChanged();
        }

        public void focusGained(FocusEvent fe) {
            this.fireViewSelectionChanged();
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class MainWindowClosingListener
    extends IdeAdapter {
        public void mainWindowClosing(IdeEvent e) {
            int i = 0;
            while (i < ChangeListWindow.mav$getChangeLists(ChangeListWindow.this).length) {
                String persistenceKey = ChangeListWindow.this.getPersistenceKey(ChangeListWindow.mav$getChangeLists(ChangeListWindow.this)[i]);
                if (persistenceKey != null) {
                    ChangeListWindow.mav$getChangeLists(ChangeListWindow.this)[i].persistVisualSettings(persistenceKey);
                }
                ++i;
            }
        }

        private MainWindowClosingListener() {
        }

        MainWindowClosingListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class GlobalIgnoreListListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent ce) {
            ChangeListWindow.this.refresh();
        }

        private GlobalIgnoreListListener() {
        }

        GlobalIgnoreListListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ChangeListProgressTask
    implements ProgressTrackedTask {
        private final ChangeList _changeList;
        private final String _message;
        private final String _task;

        ChangeListProgressTask(ChangeList changeList, String message, String task) {
            this._changeList = changeList;
            this._message = message;
            this._task = task;
        }

        public boolean isIndeterminate() {
            return true;
        }

        public void run() {
            ChangeListEventQueue changeListEventQueue = this._changeList.getEventQueue();
            while (this._changeList.isStarted() && changeListEventQueue != null && changeListEventQueue.isAlive() && this._changeList.isBusy()) {
                if (this._changeList.getProgressTask() == null) break;
                try {
                    Thread.sleep(100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this._changeList.setProgressTask(null);
        }

        public int getCurrentValue() {
            return 0;
        }

        public int getMinimum() {
            return 0;
        }

        public int getMaximum() {
            return 0;
        }

        public String getCurrentText() {
            return this._message;
        }

        public String getTaskDescription() {
            return this._task;
        }
    }
}

