/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;

abstract class IdeObserver
implements Observer {
    private final List _observed;

    private void $init$() {
        this._observed = new ArrayList();
    }

    public void startObserving() {
        this.attach((Subject)Ide.getWorkspaces());
        Iterator i = Ide.getWorkspaces().getChildren();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!(e instanceof Subject)) continue;
            this.attach((Subject)e);
            if (!(e instanceof Workspace) || !((Workspace)e).isOpen()) continue;
            this.attach(((Workspace)e).getChildren());
        }
    }

    public void stopObserving() {
        this.detachAll();
        this._observed.clear();
    }

    public void update(Object source, UpdateMessage updateMessage) {
        int msgId = updateMessage.getMessageID();
        if (source == Ide.getWorkspaces()) {
            if (msgId == UpdateMessage.CHILD_REMOVED) {
                this.detach(updateMessage.getRemoveObjects().iterator());
            } else if (msgId == UpdateMessage.CHILD_ADDED) {
                this.attach(updateMessage.getAddObjects().iterator());
            }
        } else if (source instanceof Workspace) {
            if (msgId == UpdateMessage.OBJECT_CLOSING) {
                this.detach(((Workspace)source).getChildren());
            } else if (msgId == UpdateMessage.OBJECT_OPENED) {
                this.attach(((Workspace)source).getChildren());
            } else if (msgId == UpdateMessage.CHILD_ADDED) {
                this.attach(updateMessage.getAddObjects().iterator());
            } else if (msgId == UpdateMessage.CHILD_REMOVED) {
                this.detach(updateMessage.getAddObjects().iterator());
            }
        }
        this.updateImpl(source, updateMessage);
    }

    protected abstract void updateImpl(Object var1, UpdateMessage var2);

    private void attach(Subject e) {
        e.attach((Observer)this);
        this._observed.add(e);
    }

    private void attach(Iterator i) {
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!(e instanceof Subject)) continue;
            this.attach((Subject)e);
        }
    }

    private void detach(Iterator i) {
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!(e instanceof Subject)) continue;
            ((Subject)e).detach((Observer)this);
            this._observed.remove(e);
        }
    }

    private void detachAll() {
        for (Element e : this._observed) {
            if (!(e instanceof Subject)) continue;
            ((Subject)e).detach((Observer)this);
        }
        this._observed.clear();
    }

    IdeObserver() {
        this.$init$();
    }
}

