/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;

public class OpenCommand
extends Command {
    public OpenCommand() {
        super(ChangeListWindow.OPEN_CMD_ID, 1);
    }

    protected OpenCommand(int cmdId) {
        super(cmdId, 1);
    }

    public int doit() throws Exception {
        Context context = this.getContext();
        if (context == null) {
            return -1;
        }
        Context[] contexts = (Context[])context.getProperty("ChangeListWindow.CONTEXTS");
        if (contexts == null) {
            return this._doit(context);
        }
        Context[] contextArray = contexts;
        int n = 0;
        while (n < contextArray.length) {
            Context context2 = contextArray[n];
            this._doit(context2);
            ++n;
        }
        return 0;
    }

    private int _doit(Context context) throws IllegalAccessException, InstantiationException {
        URL url;
        Node node = context.getNode();
        if (node == null) {
            if (context.getElement() != null && context.getElement() instanceof ChangeListItem) {
                node = ((ChangeListItem)context.getElement()).findOrCreateNode();
            } else {
                return -1;
            }
        }
        if ((url = node.getURL()) == null) {
            return -1;
        }
        if ("file".equals(url.getProtocol()) && !URLFileSystem.exists((URL)url)) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)VCSArb.format(95, URLFileSystem.getFileName((URL)url)), (String)VCSArb.getString(37), null, (boolean)false)) {
                return -1;
            }
            try {
                URL parentUrl = URLFileSystem.getParent((URL)url);
                if (!URLFileSystem.exists((URL)parentUrl) && !URLFileSystem.mkdirs((URL)parentUrl)) {
                    int n = -1;
                    return n;
                }
                if (!new File(URLFileSystem.getPlatformPathName((URL)url)).createNewFile()) {
                    int n = -1;
                    return n;
                }
            }
            catch (IOException ioe) {
                Assert.printStackTrace((Throwable)ioe);
            }
        }
        if (!(context.getNode() instanceof Workspace) && !(context.getNode() instanceof Project)) {
            this.openDefaultEditorInFrame(context);
        }
        return 0;
    }

    protected void openDefaultEditorInFrame(Context context) {
        EditorManager.getEditorManager().openDefaultEditorInFrame(context);
    }
}

