/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.generic;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommandType;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public abstract class ActionCommand
extends VCSCommand {
    private VCSProfile _profile;

    protected ActionCommand(int cmdId) {
        super(cmdId);
    }

    protected ActionCommand(int cmdId, int type) {
        super(cmdId, type);
    }

    protected ActionCommand(int cmdId, int type, String name) {
        super(cmdId, type, name);
    }

    protected ActionCommand(String commandId) {
        this(Ide.findCmdID((String)commandId));
    }

    protected ActionCommand(String commandId, int type) {
        this(Ide.findCmdID((String)commandId), type);
    }

    protected ActionCommand(String commandId, int type, String name) {
        this(Ide.findCmdID((String)commandId), type, name);
    }

    public void setProfile(VCSProfile profile) {
        this._profile = profile;
    }

    protected String getActionId() {
        return Ide.findCmdName((int)this.getId());
    }

    protected VCSProfile getProfile() {
        return this._profile;
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo(this.getActionId());
    }

    protected VCSStatusCache getStatusCache() {
        return this.getProfile().getStatusCache();
    }

    protected URLFilter getURLFilter() {
        return this.getProfile().getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
    }

    protected boolean isAvailableImpl() throws Exception {
        return this.isAvailableImpl(this.getProfile());
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        return this.requirementsSatisfied(profile) && this.locatablesValid(profile);
    }

    protected boolean requirementsSatisfied(VCSProfile profile) throws Exception {
        return this.getActionInfo().requirementsSatisfied(this.context);
    }

    protected boolean locatablesValid(VCSProfile profile) {
        try {
            boolean bl = this.verifyStyle(profile) && this.verifyType(profile);
            return bl;
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException(e);
            boolean bl = false;
            return bl;
        }
    }

    private boolean verifyStyle(VCSProfile profile) throws Exception {
        VCSCommandStyle style = this.getActionInfo().getStyle();
        if (style == VCSCommandStyle.NORMAL) {
            return true;
        }
        List<Locatable> filtered = Arrays.asList(this.getOperands(profile));
        switch (filtered.size()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return style == VCSCommandStyle.MULTI;
    }

    private boolean verifyType(VCSProfile profile) throws Exception {
        VCSCommandType type = this.getActionInfo().getType();
        if (type == VCSCommandType.BOTH) {
            return true;
        }
        List<Locatable> filtered = Arrays.asList(this.getOperands(profile));
        if (type == VCSCommandType.FILE) {
            for (Locatable loc : filtered) {
                if (!URLFileSystem.isDirectory((URL)loc.getURL())) continue;
                return false;
            }
            return true;
        }
        if (type == VCSCommandType.FOLDER) {
            for (Locatable loc : filtered) {
                if (!URLFileSystem.isRegularFile((URL)loc.getURL())) continue;
                return false;
            }
        }
        return true;
    }

    protected int doitImpl() throws Exception {
        return this.doitImpl(this.getProfile());
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getOperands(profile);
        if (!this.saveDirtyNodes(locatables)) {
            return 1;
        }
        CommandState commandState = this.getCommandState(profile, locatables);
        if (commandState == null) {
            return 9;
        }
        if (this.isSilent(this.getContext(), profile)) {
            this.invokeCommandSilently(profile, commandState);
            return 1;
        }
        boolean success = this.invokeCommand(profile, commandState);
        this.postInvoke(profile, commandState);
        return success ? 0 : 1;
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Collection c = this.getActionInfo().getFilteredSelection(this.getContext());
        return c.toArray(new Locatable[c.size()]);
    }

    protected boolean saveDirtyNodes(Locatable[] contextLocatables) throws Exception {
        return VCSCommandUtils.saveDirtyNodes(contextLocatables);
    }

    protected boolean isSilent(Context context, VCSProfile profile) {
        View view = context.getView();
        return this.isChangeListAction(view, profile) && !this.isDialogRequired(view instanceof ChangeListWindow ? (ChangeListWindow)view : null, profile);
    }

    protected boolean isChangeListAction(View view, VCSProfile profile) {
        String clViewId = profile.getChangeListViewID();
        if (clViewId != null && view != null && view instanceof ChangeListWindow && clViewId.equals(view.getId())) {
            return this.getActionInfo().isChangeListAction();
        }
        return false;
    }

    protected boolean isDialogRequired(ChangeListWindow changeListWindow, VCSProfile profile) {
        if (changeListWindow == null) {
            return true;
        }
        ChangeList changeList = changeListWindow.getContextChangeList();
        return profile.getPendingChangesAdapter().isActionSilent(changeList, this.getActionId()) ^ true;
    }

    protected CommandState getCommandState(VCSProfile profile, Locatable[] locatables) throws Exception {
        if (locatables == null || locatables.length == 0) {
            return null;
        }
        URL[] urls = VCSModelUtils.convertNodesToURLs(locatables);
        Node[] affectedNodes = VCSModelUtils.findCachedNodes(VCSURLFilters.createBaseURLContentsFilter(urls));
        Map timestamps = VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes));
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(urls);
        CommandState commandState = new CommandState();
        commandState.setInvokableState(invokableState);
        commandState.setTimestampMap(timestamps);
        commandState.setLocatables(locatables);
        return commandState;
    }

    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        VCSOptionsCustomizer customizer = this.createOptionsCustomizer();
        JEWTDialog dialog = this.createOperationDialog(Arrays.asList(commandState.getLocatables()), customizer);
        dialog.addVetoableChangeListener((VetoableChangeListener)new 1(this, customizer, profile, commandState, dialog));
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        return null;
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer) {
        return VCSComponents.createOperationDialog(VCSWindowUtils.getCurrentWindow(), this.getDialogTitle(), this.getDialogHint(), VCSComponents.createFileListerComponent(nodes), customizer != null ? customizer.getComponent() : null, this.getHelpTopicId(), customizer != null ? customizer.getInitialFocusComponent() : null);
    }

    protected String getDialogTitle() {
        String title = this.getActionInfo().getDialogTitle();
        if (title == null || title.equals("")) {
            title = "VCS Operation";
        }
        return title;
    }

    protected String getDialogHint() {
        return this.getActionInfo().getDialogHint();
    }

    protected String getHelpTopicId() {
        return this.getActionInfo().getHelpTopicId();
    }

    protected boolean invokeCommandSilently(VCSProfile profile, CommandState commandState) throws Exception {
        Ide.getWaitCursor().show();
        2 runner = new 2(this, "vcs-silent-operation-thread", profile, commandState);
        runner.start();
        return true;
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        return true;
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        return true;
    }

    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        Collection processed = commandState.getInvokableState().getProcessedURLs();
        if (processed.size() > 0) {
            VCSBufferUtils.reloadBuffers(commandState.getTimestampMap());
        }
        URL[] urls = processed.toArray(new URL[processed.size()]);
        this.fireFileStructureChanged(urls);
        URLFilter filter = VCSURLFilters.createSpecificURLFilter(urls);
        profile.getStatusCache().clear(filter);
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    static VCSExceptionHandler mav$getExceptionHandler(ActionCommand actionCommand) {
        return actionCommand.getExceptionHandler();
    }

    final class 1
    extends VCSDialogCommitter {
        private final /* synthetic */ VCSProfile v$profile;
        private final /* synthetic */ CommandState v$commandState;
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ ActionCommand this$0;

        protected boolean doCommitOperation(Map options) throws Exception {
            return this.this$0.invokeCommandImpl(this.v$profile, this.v$commandState, (Component)this.v$dialog, options);
        }

        public 1(ActionCommand actionCommand, VCSOptionsCustomizer vCSOptionsCustomizer, VCSProfile vCSProfile, CommandState commandState, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.v$commandState = commandState;
            this.v$profile = vCSProfile;
            this.this$0 = actionCommand;
            super(vCSOptionsCustomizer);
        }
    }

    final class 2
    extends Thread {
        private final /* synthetic */ VCSProfile v$profile;
        private final /* synthetic */ CommandState v$commandState;
        final /* synthetic */ ActionCommand this$0;

        public void run() {
            try {
                try {
                    View view = this.this$0.getContext().getView();
                    ChangeList changeList = null;
                    if (view instanceof ChangeListWindow) {
                        changeList = ((ChangeListWindow)view).getContextChangeList();
                    } else if (view instanceof ChangeListWindow) {
                        changeList = ((ChangeListWindow)view).getChangeList();
                    }
                    Map options = changeList != null && changeList.getOptionsCustomizer() != null ? changeList.getOptionsCustomizer().getOptions() : Collections.EMPTY_MAP;
                    this.this$0.invokeCommandSilentlyImpl(this.v$profile, this.v$commandState, options);
                }
                catch (Exception e) {
                    ActionCommand.mav$getExceptionHandler(this.this$0).handleException(e);
                }
            }
            finally {
                try {
                    this.this$0.postInvoke(this.v$profile, this.v$commandState);
                }
                catch (Exception e) {
                    ActionCommand.mav$getExceptionHandler(this.this$0).handleException(e);
                }
                SwingUtilities.invokeLater(new 1());
            }
        }

        public 2(ActionCommand actionCommand, String string, VCSProfile vCSProfile, CommandState commandState) {
            this.v$commandState = commandState;
            this.v$profile = vCSProfile;
            this.this$0 = actionCommand;
            super(string);
        }

        final class 1
        implements Runnable {
            public void run() {
                Ide.getWaitCursor().hide();
            }
        }
    }
}

