/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.migrate;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.SimpleProcess;
import oracle.ide.runner.Starter;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;
import oracle.jdevimpl.vcs.util.RunnerOutputTask;
import oracle.jdevimpl.vcs.util.RunnerTimeoutTask;

public class VCSShellRunner {
    private SimpleProcess _simpleProcess;
    private long _timeout;
    private String _inputData;
    private final Collection _outputMonitors;
    private final Collection _errorMonitors;
    private RunnerOutputTask _outputTask;
    private RunnerOutputTask _errorTask;
    private Thread _outputThread;
    private Thread _errorThread;
    private VCSThreadPool _threadPool;
    private boolean _bufferOutputBinary;
    private boolean _isTimedOut;

    private void $init$() {
        this._inputData = null;
        this._outputMonitors = new ArrayList();
        this._errorMonitors = new ArrayList();
    }

    public VCSShellRunner() {
        this.$init$();
        this.setSimpleProcess(new SimpleProcess());
    }

    public void setThreadPool(VCSThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    public void setBufferOutputBinary(boolean bufferOutputBinary) {
        this._bufferOutputBinary = bufferOutputBinary;
    }

    public void setCommand(String command) {
        this._simpleProcess.setCommand(this.fromCommandString(command));
    }

    public void setCmdArray(String[] cmdArray) {
        this._simpleProcess.setCommand(cmdArray);
    }

    public void setCmdList(Collection cmdList) {
        this._simpleProcess.setCommand(cmdList.toArray(new String[0]));
    }

    public void setEnvpArray(String[] envpArray) {
        this._simpleProcess.setEnvironmentParams(envpArray);
    }

    public void setEnvpMap(Map envpMap) {
        this._simpleProcess.setEnvironmentParams(this.fromEnvpMap(envpMap));
    }

    public void setDirectory(File dir) {
        this._simpleProcess.setWorkingDirectory(dir);
    }

    public void setDirURL(URL dir) {
        this._simpleProcess.setWorkingDirectory(new File(URLFileSystem.getPlatformPathName((URL)dir)));
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public String getCommand() {
        return this.toCommandString(this.getCmdArray());
    }

    public String[] getCmdArray() {
        return this._simpleProcess.getRunProcess().getStartCommand();
    }

    public Collection getCmdList() {
        return Arrays.asList(this.getCmdArray());
    }

    public String[] getEnvpArray() {
        return this._simpleProcess.getRunProcess().getStartEnvironmentParams();
    }

    public Map getEnvpMap() {
        return this.toEnvpMap(this.getEnvpArray());
    }

    public File getDirectory() {
        return this._simpleProcess.getRunProcess().getStartDirectory();
    }

    public URL getDirURL() {
        return URLFactory.newFileURL((File)this.getDirectory());
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void addOutputMonitor(VCSStreamMonitor monitor) {
        this._outputMonitors.add(monitor);
    }

    public void removeOutputMonitor(VCSStreamMonitor monitor) {
        this._outputMonitors.remove(monitor);
    }

    public void addErrorMonitor(VCSStreamMonitor monitor) {
        this._errorMonitors.add(monitor);
    }

    public void removeErrorMonitor(VCSStreamMonitor monitor) {
        this._errorMonitors.remove(monitor);
    }

    public void clearMonitors() {
        this._outputMonitors.clear();
        this._errorMonitors.clear();
    }

    protected String[] createCommandSpi(String[] cmdArray) {
        return cmdArray;
    }

    protected String createCommandStringForLog(String[] cmdArray) {
        return null;
    }

    protected void preExecSpi() throws Exception {
    }

    public void setInputData(String inputData) {
        this._inputData = inputData;
    }

    public String getInputData() {
        return this._inputData;
    }

    public SimpleProcess getSimpleProcess() {
        return this._simpleProcess;
    }

    public Integer getExitCode() {
        Starter starter = this._simpleProcess.getRunProcess().getStarter();
        return starter != null ? starter.getExitCode() : null;
    }

    public String getErrorText() {
        return this._errorTask != null ? this._errorTask.getOutput() : null;
    }

    public String getOutputText() {
        return this._outputTask != null ? this._outputTask.getOutput() : null;
    }

    public byte[] getOutputBytes() {
        return this._outputTask != null ? this._outputTask.getOutputBytes() : null;
    }

    public boolean isTimedOut() {
        return this._isTimedOut;
    }

    public void exec() throws Exception {
        this.setSimpleProcess(new SimpleProcess(this._simpleProcess));
        this.execImpl();
    }

    public int execAndWait() throws Exception {
        this.setSimpleProcess(new SimpleProcess(this._simpleProcess));
        this.execImpl();
        this._simpleProcess.getRunProcess().getStarter().waitForProcess();
        if (this._threadPool != null) {
            this._threadPool.join(this._outputTask);
            this._threadPool.join(this._errorTask);
        } else {
            this._outputThread.join();
            this._errorThread.join();
        }
        if (this._outputTask.getException() != null) {
            throw this._outputTask.getException();
        }
        if (this._errorTask.getException() != null) {
            throw this._errorTask.getException();
        }
        return this.getExitCode() != null ? this.getExitCode() : -1;
    }

    protected void setSimpleProcess(SimpleProcess simpleProcess) {
        this._simpleProcess = simpleProcess;
    }

    private String[] fromCommandString(String command) {
        if (command == null) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer strtok = new StringTokenizer(command);
        while (strtok.hasMoreTokens()) {
            tokens.add(strtok.nextToken());
        }
        return tokens.toArray(new String[0]);
    }

    private String toCommandString(String[] parts) {
        if (parts == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < parts.length) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(parts[i]);
            ++i;
        }
        return sb.toString();
    }

    private String[] fromEnvpMap(Map m) {
        if (m == null) {
            return null;
        }
        return VCSProcessUtils.createEnvironmentParams(m);
    }

    private Map toEnvpMap(String[] arr) {
        if (arr == null) {
            return null;
        }
        HashMap<String, String> envp = new HashMap<String, String>();
        int i = 0;
        while (i < arr.length) {
            int j = arr[i].indexOf(61);
            if (j > 0 && j < arr[i].length() - 1) {
                String key = arr[i].substring(0, j);
                String value = arr[i].substring(j + 1);
                envp.put(key, value);
            }
            ++i;
        }
        return envp;
    }

    private void execImpl() throws Exception {
        Exception e;
        this._simpleProcess.setSuppressDirectoryDefault();
        this._simpleProcess.setDoUILater();
        this._isTimedOut = false;
        this._outputTask = new RunnerOutputTask(this._simpleProcess.getRunProcess(), this._outputMonitors, this._simpleProcess.duplicateOutputStream());
        this._errorTask = new RunnerOutputTask(this._simpleProcess.getRunProcess(), this._errorMonitors, this._simpleProcess.duplicateErrorStream());
        if (this._bufferOutputBinary) {
            this._outputTask.setBufferBytes(true);
        }
        1 timeoutTask = null;
        if (this._timeout > 0L) {
            timeoutTask = new 1(this._timeout);
            this._outputTask.setTimeoutTask(timeoutTask);
            this._errorTask.setTimeoutTask(timeoutTask);
        }
        String[] cmd = this.getCmdArray();
        this._simpleProcess.setCommand(this.createCommandSpi(cmd));
        this._simpleProcess.setCommandStringForLog(this.createCommandStringForLog(cmd));
        this.preExecSpi();
        this._simpleProcess.exec();
        if (this._threadPool != null) {
            this._threadPool.doTask(this._outputTask);
            this._threadPool.doTask(this._errorTask);
        } else {
            this._outputThread = new Thread(this._outputTask);
            this._errorThread = new Thread(this._errorTask);
            this._outputThread.start();
            this._errorThread.start();
        }
        if (timeoutTask != null) {
            if (this._threadPool != null) {
                this._threadPool.doTask(timeoutTask);
            } else {
                new Thread(timeoutTask).start();
            }
        }
        this._simpleProcess.setCommand(cmd);
        if (this._inputData != null) {
            Process process = this._simpleProcess.getRunProcess().getStarter().getProcess();
            VCSProcessUtils.sendInputData(process, this._inputData, true);
        }
        if ((e = this._simpleProcess.getExecException()) != null) {
            throw e;
        }
    }

    private void _doTimeout() {
        this._isTimedOut = true;
        this._outputTask.setExitFlag();
        this._errorTask.setExitFlag();
        RunnerOutputTask.terminateRunProcess(this._simpleProcess.getRunProcess());
    }

    static void mav$_doTimeout(VCSShellRunner vCSShellRunner) {
        vCSShellRunner._doTimeout();
    }

    final class 1
    extends RunnerTimeoutTask {
        public final void doTimeout() {
            VCSShellRunner.mav$_doTimeout(VCSShellRunner.this);
        }

        public 1(long l) {
            super(l);
        }
    }
}

