/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.nav;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.jdeveloper.vcs.nav.ConnectionFilter;
import oracle.jdeveloper.vcs.nav.ConnectionListFilterNode;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdeveloper.vcs.nav.ConnectionPlaceholderNode;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConnectionProvider
extends ConnectionProvider {
    public abstract Node getConnectionListNode();

    @Override
    public Element createConnectionListNode(Collection<Map<String, String>> criteria) {
        HashMap nodeToPathsMap = new HashMap();
        ArrayList<Element> placeholderNodes = new ArrayList<Element>();
        for (Map<String, String> criteria1 : criteria) {
            String directoryPath;
            ConnectionNode connectionNode = this.findConnectionNode(criteria1 = this.createTestCriteria(criteria1));
            if (connectionNode == null) {
                placeholderNodes.add(this.createConnectionPlaceholderNode(criteria1));
                continue;
            }
            ArrayList<String> directoryPaths = (ArrayList<String>)nodeToPathsMap.get(connectionNode);
            if (directoryPaths == null) {
                directoryPaths = new ArrayList<String>();
                nodeToPathsMap.put(connectionNode, directoryPaths);
            }
            if ((directoryPath = this.convertCriteriaPathToDirectory(criteria1.get("path"), connectionNode)).equals("")) continue;
            directoryPaths.add(directoryPath);
        }
        ConnectionListFilterNode listNode = this.createConnectionListFilterNode();
        for (Map.Entry entry : nodeToPathsMap.entrySet()) {
            Collection directoryPaths = (Collection)entry.getValue();
            Element connectionFilterNode = this.createConnectionFilterNode((ConnectionNode)entry.getKey(), new 1(this, directoryPaths));
            listNode.addConnectionNode(connectionFilterNode);
        }
        for (Element element : placeholderNodes) {
            listNode.addPlaceholderNode(element);
        }
        this.addOverlayClient((Node)listNode);
        return listNode;
    }

    protected ConnectionNode findConnectionNode(Map<String, String> criteria1) {
        try {
            this.getConnectionListNode().open();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            ConnectionNode connectionNode = null;
            return connectionNode;
        }
        ArrayList<ConnectionNode> matches = new ArrayList<ConnectionNode>();
        for (ConnectionNode connectionNode : this.getConnectionNodes()) {
            Map<String, String> criteria0 = connectionNode.getConnectionCriteria();
            if (!this.nullSafeEquals(criteria0.get("server"), criteria1.get("server")) || criteria0.get("path") == null || criteria1.get("path") == null || !this.canonicalizePath(criteria1.get("path")).startsWith(this.canonicalizePath(criteria0.get("path")))) continue;
            matches.add(connectionNode);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return (ConnectionNode)matches.iterator().next();
        }
        if (criteria1.get("protocol") != null) {
            for (ConnectionNode connectionNode : matches) {
                Map<String, String> criteria0 = connectionNode.getConnectionCriteria();
                if (criteria0.get("protocol") == null || !criteria0.get("protocol").equals(criteria1.get("protocol"))) continue;
                return connectionNode;
            }
        }
        return (ConnectionNode)matches.iterator().next();
    }

    protected abstract Collection<ConnectionNode> getConnectionNodes();

    protected Element createConnectionPlaceholderNode(Map<String, String> criteria) {
        return new 2(criteria);
    }

    protected abstract boolean createConnection(Map<String, String> var1, Context var2);

    protected String convertCriteriaPathToDirectory(String path, ConnectionNode connectionNode) {
        return path;
    }

    protected abstract ConnectionListFilterNode createConnectionListFilterNode();

    protected abstract Element createConnectionFilterNode(ConnectionNode var1, ConnectionFilter var2);

    protected void addOverlayClient(Node listNode) {
    }

    protected String extractDirectoryPath(String repositoryPath, String path) {
        path = path.substring(repositoryPath.length());
        path = path.replace('\\', '/');
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    protected boolean isPathFromMutualParent(String path1, String path2) {
        path1 = this.canonicalizePath(path1);
        if ((path2 = this.canonicalizePath(path2)).equals(path1)) {
            return true;
        }
        if (path2.startsWith(path1)) {
            return true;
        }
        return path1.startsWith(path2);
    }

    protected String canonicalizePath(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    protected boolean nullSafeEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    final class 1
    extends ConnectionFilter {
        private final /* synthetic */ Collection v$directoryPaths;
        final /* synthetic */ BaseConnectionProvider this$0;

        public boolean accept(String path) {
            for (String directoryPath : this.v$directoryPaths) {
                if (!this.this$0.isPathFromMutualParent(directoryPath, path)) continue;
                return true;
            }
            return false;
        }

        public 1(BaseConnectionProvider baseConnectionProvider, Collection collection) {
            this.v$directoryPaths = collection;
            this.this$0 = baseConnectionProvider;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 2
    extends ConnectionPlaceholderNode {
        @Override
        protected boolean createConnection(Map<String, String> criteria, Context context) {
            criteria = BaseConnectionProvider.this.createTestCriteria(criteria);
            return BaseConnectionProvider.this.createConnection(criteria, context);
        }

        public 2(Map map) {
            super(map);
        }
    }
}

