/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.nav;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.view.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionProvider {
    private static final Map<String, ConnectionProvider> _providers = new HashMap<String, ConnectionProvider>();

    protected ConnectionProvider() {
    }

    public abstract Element getConnectionListNode();

    public String getALMTeamSourceControlType() {
        throw new UnsupportedOperationException();
    }

    public Element createConnectionListNode(Collection<Map<String, String>> criteria) {
        throw new UnsupportedOperationException();
    }

    public Observable getConnectionObservable() {
        throw new UnsupportedOperationException();
    }

    public static final void registerProvider(String vcsId, ConnectionProvider provider) {
        _providers.put(vcsId, provider);
    }

    public static final ConnectionProvider lookupProvider(String vcsId) {
        return _providers.get(vcsId);
    }

    public static final boolean isVersioningConnectionView(View view) {
        if (view == null) {
            return false;
        }
        ViewId viewId = new ViewId(view.getId());
        return viewId.getType().equals("VersioningNavigatorWindow") || viewId.getType().equals("oracle-jdeveloper-vcsaccordion-VCS_ACCORDION_VIEW_TYPE");
    }

    protected Map<String, String> createTestCriteria(Map<String, String> criteria) {
        return criteria;
    }
}

