/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.patch;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryNode;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryURLHelper;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.vcs.util.FilePanel;

public abstract class AbstractPatchCommand
extends VCSCommand {
    private static final URLFilter _urlFilter = VCSURLFilters.createFileProtocolFilter();
    private VCSExceptionHandler _exceptionHandler;

    protected AbstractPatchCommand(int cmdId) {
        super(cmdId, 1);
        this.initializeCommandStyle(VCSCommandStyle.NORMAL);
    }

    protected VCSExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new VCSExceptionHandler();
        }
        return this._exceptionHandler;
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        return super.isAvailableImpl(url) && CompareViewer.isContentComparable((URL)url);
    }

    public Context getContext() {
        Node realNode;
        Context context = super.getContext();
        if (context != null && context.getView() instanceof HistoryViewer) {
            context.setSelection(new Element[]{context.getNode()});
        }
        if (context != null && context.getNode() instanceof VersionHistoryNode && (realNode = NodeFactory.find((URL)VersionHistoryURLHelper.getRealURL(((VersionHistoryNode)context.getNode()).getURL()))) != null) {
            context.setNode(realNode);
            context.setElement((Element)realNode);
            context.setSelection(new Element[]{realNode});
        }
        return context;
    }

    protected URLFilter getURLFilter() {
        return _urlFilter;
    }

    protected final Project getContextProject() {
        Locatable[] locatables = this.getContextLocatables();
        ArrayList<Locatable> projects = new ArrayList<Locatable>();
        int i = 0;
        while (i < locatables.length) {
            if (locatables[i] instanceof Project) {
                projects.add(locatables[i]);
            }
            ++i;
        }
        return projects.size() == 1 ? (Project)projects.iterator().next() : null;
    }

    protected final Locatable[] getProjectFolderNodes(Project project) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        URL projectParentUrl = URLFileSystem.getParent((URL)project.getURL());
        urls.add(projectParentUrl);
        urls.addAll(Arrays.asList(this.getProjectSourcePathURLs(project)));
        return new LinkedHashSet<Locatable>(Arrays.asList(VCSModelUtils.findOrCreateNodes(urls.toArray(new URL[0])))).toArray(new Locatable[0]);
    }

    private final URL[] getProjectSourcePathURLs(Project project) {
        LinkedHashSet<URL> baseDirectoryUrls = new LinkedHashSet<URL>();
        baseDirectoryUrls.add(URLFileSystem.getParent((URL)project.getURL()));
        baseDirectoryUrls.addAll(ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs().asList());
        return baseDirectoryUrls.toArray(new URL[0]);
    }

    protected Collection processNodesForProjectOperation(Project project, Collection nodes) throws Exception {
        if (nodes.size() <= 1) {
            return nodes;
        }
        Locatable locatableFolder = this.showSelectPatchContextDialog(project, nodes);
        if (locatableFolder == null) {
            return null;
        }
        return Collections.singleton(locatableFolder);
    }

    protected URL getOperationWorkingDirectoryURL(URL[] urls) {
        if (urls.length <= 0) {
            return null;
        }
        if (urls.length == 1) {
            return URLFileSystem.isDirectoryPath((URL)urls[0]) ? urls[0] : URLFileSystem.getParent((URL)urls[0]);
        }
        URL operationWorkingDirectoryUrl = null;
        int i = 0;
        while (i < urls.length) {
            URL parentDirectoryUrl = URLFileSystem.getParent((URL)urls[i]);
            if (i <= 0) {
                operationWorkingDirectoryUrl = parentDirectoryUrl;
            } else if (!URLFileSystem.equals((URL)operationWorkingDirectoryUrl, (URL)parentDirectoryUrl)) {
                return null;
            }
            ++i;
        }
        return operationWorkingDirectoryUrl;
    }

    protected URL[] getOperationURLs(URL[] urls) {
        return urls;
    }

    protected void initializeFileChooserPanel(FilePanel filePanel, URL[] urls) {
        filePanel.setChooseFolders(false);
        filePanel.setURL(this.constructDefaultPatchURL(urls));
        filePanel.setURLFilter((URLFilter)new DefaultURLFilter(VCSArb.getString(45), new String[]{".patch", ".diff"}));
    }

    protected void initializePreferredSizeOfUI(JComponent component) {
        Dimension preferredSize = component.getPreferredSize();
        component.setPreferredSize(new Dimension(Math.max(500, preferredSize.width), preferredSize.height));
    }

    protected Locatable showSelectPatchContextDialog(Project project, Collection nodes) {
        JEWTDialog dialog = new JEWTDialog(IdeUtil.getMainWindow(), VCSArb.getString(119), 7);
        JRadioButton projectFileRadioButton = new JRadioButton();
        JRadioButton projectContentProviderRadioButton = new JRadioButton();
        JList<Object> projectContentProviderList = new JList<Object>(nodes.toArray());
        JScrollPane projectContentProviderScrollPane = new JScrollPane(projectContentProviderList);
        ResourceUtils.resButton((AbstractButton)projectFileRadioButton, (String)VCSArb.format(1, project.getShortLabel()));
        ResourceUtils.resButton((AbstractButton)projectContentProviderRadioButton, (String)VCSArb.getString(166));
        JPanel panel = new JPanel();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)projectFileRadioButton, insets, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)projectContentProviderRadioButton, insets, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)projectContentProviderScrollPane, insets, 1, true, true);
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)panel);
        this.initializePreferredSizeOfUI(panel);
        Dimension preferredSize = panel.getPreferredSize();
        panel.setPreferredSize(new Dimension(preferredSize.width, 200));
        ButtonGroup bg = new ButtonGroup();
        bg.add(projectFileRadioButton);
        bg.add(projectContentProviderRadioButton);
        projectContentProviderRadioButton.setSelected(true);
        projectContentProviderList.setSelectedIndex(0);
        projectContentProviderList.setSelectionMode(0);
        projectContentProviderList.setCellRenderer(new 1());
        dialog.setInitialFocus((Component)projectContentProviderRadioButton);
        dialog.setContent((Component)panel);
        dialog.setResizable(true);
        1SelectContextEnablementListener enablementListener = new 1SelectContextEnablementListener(this, projectContentProviderList, projectContentProviderRadioButton, dialog, projectFileRadioButton);
        projectFileRadioButton.addActionListener(enablementListener);
        projectContentProviderRadioButton.addActionListener(enablementListener);
        projectContentProviderList.addListSelectionListener(enablementListener);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_scsselectpatchcontext_html");
        if (!VCSDialogRunner.runDialog((JDialog)dialog)) {
            return null;
        }
        return projectFileRadioButton.isSelected() ? project : (Locatable)projectContentProviderList.getSelectedValue();
    }

    protected URL constructDefaultPatchURL(URL[] urls) {
        URL[] operationUrls = this.getOperationURLs(urls);
        URL operationWorkingDirectoryUrl = this.getOperationWorkingDirectoryURL(urls);
        URL patchNameUrl = operationUrls.length == 1 ? operationUrls[0] : operationWorkingDirectoryUrl;
        String fileName = URLFileSystem.getFileName((URL)patchNameUrl);
        if (!fileName.endsWith(".patch")) {
            fileName = fileName + ".patch";
        }
        return URLFactory.newURL((URL)operationWorkingDirectoryUrl, (String)fileName);
    }

    protected void copyStringToClipboard(String s) {
        StringSelection selection = new StringSelection(s);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    protected void saveStringAsURL(String s, String charsetName, URL url) throws IOException {
        OutputStream out = URLFileSystem.openOutputStream((URL)url);
        OutputStreamWriter osw = charsetName != null ? new OutputStreamWriter(out, charsetName) : new OutputStreamWriter(out);
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(s);
        bw.close();
    }

    protected void savePatchToClipboard(String patchSource) throws VCSException {
        this.copyStringToClipboard(patchSource);
        this.checkPatchSourceEmpty(patchSource);
        MessageDialog.information((Component)VCSWindowUtils.getCurrentWindow(), (Object)VCSArb.getString(54), (String)VCSArb.getString(208), null);
    }

    protected void savePatchToURL(String patchSource, String charsetName, URL patchUrl, boolean openEditor) throws VCSException, IOException, InstantiationException, IllegalAccessException {
        this.saveStringAsURL(patchSource, charsetName, patchUrl);
        Node patchNode = NodeFactory.findOrCreate((URL)patchUrl);
        if (openEditor) {
            this.awtOpenDefaultEditorInFrame(patchUrl);
        }
        if (patchNode != null) {
            this.awtRevertNodeReload(patchNode);
        }
        this.checkPatchSourceEmpty(patchSource);
    }

    protected void checkPatchSourceEmpty(String patchSource) throws VCSException {
        if (!this.isPatchSourceEmpty(patchSource)) {
            return;
        }
        throw new VCSException(VCSArb.getString(14), VCSArb.getString(7));
    }

    protected void awtOpenDefaultEditorInFrame(URL url) {
        EventQueue.invokeLater(new 2(this, url));
    }

    protected void awtRevertNodeReload(Node node) {
        EventQueue.invokeLater(new 3(this, node));
    }

    protected boolean isPatchSourceEmpty(String patchSource) {
        return patchSource.trim().equals("");
    }

    final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Locatable locatable = (Locatable)value;
            if (locatable != null) {
                value = URLFileSystem.getPlatformPathName((URL)locatable.getURL());
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(UIManager.getIcon("Tree.closedIcon"));
            return this;
        }
    }

    class 1SelectContextEnablementListener
    implements ActionListener,
    ListSelectionListener {
        private final /* synthetic */ JList v$projectContentProviderList;
        private final /* synthetic */ JRadioButton v$projectContentProviderRadioButton;
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ JRadioButton v$projectFileRadioButton;
        final /* synthetic */ AbstractPatchCommand this$0;

        private void $init$() {
            this.updateComponentsEnabled();
        }

        public void actionPerformed(ActionEvent ae) {
            this.updateComponentsEnabled();
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateComponentsEnabled();
        }

        private void updateComponentsEnabled() {
            this.v$projectContentProviderList.setEnabled(this.v$projectContentProviderRadioButton.isSelected());
            this.v$dialog.setOKButtonEnabled(this.v$projectFileRadioButton.isSelected() || this.v$projectContentProviderList.getSelectedValue() != null);
        }

        1SelectContextEnablementListener(AbstractPatchCommand abstractPatchCommand, JList jList, JRadioButton jRadioButton, JEWTDialog jEWTDialog, JRadioButton jRadioButton2) {
            this.v$projectFileRadioButton = jRadioButton2;
            this.v$dialog = jEWTDialog;
            this.v$projectContentProviderRadioButton = jRadioButton;
            this.v$projectContentProviderList = jList;
            this.this$0 = abstractPatchCommand;
            this.$init$();
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ URL v$url;
        final /* synthetic */ AbstractPatchCommand this$0;

        public final void run() {
            EditorManager.getEditorManager().openDefaultEditorInFrame(this.v$url);
        }

        public 2(AbstractPatchCommand abstractPatchCommand, URL uRL) {
            this.v$url = uRL;
            this.this$0 = abstractPatchCommand;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ AbstractPatchCommand this$0;

        public final void run() {
            RevertNodeCommand.reload((Node)this.v$node);
        }

        public 3(AbstractPatchCommand abstractPatchCommand, Node node) {
            this.v$node = node;
            this.this$0 = abstractPatchCommand;
        }
    }
}

