/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.patch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressDetailsArea;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.patch.PatchAdapter;
import oracle.javatools.patch.PatchApplyOptions;
import oracle.javatools.patch.PatchContext;
import oracle.javatools.patch.PatchContributor;
import oracle.javatools.patch.PatchEngine;
import oracle.javatools.patch.PatchEntry;
import oracle.javatools.patch.PatchEvent;
import oracle.javatools.patch.PatchFormat;
import oracle.javatools.patch.PatchHunk;
import oracle.javatools.patch.PatchHunkLine;
import oracle.javatools.patch.PatchIndexFile;
import oracle.javatools.patch.PatchListener;
import oracle.javatools.patch.PatchMatchOptions;
import oracle.javatools.patch.PatchModel;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.patch.AbstractPatchCommand;
import oracle.jdeveloper.vcs.patch.PatchOperationException;
import oracle.jdeveloper.vcs.patch.PatchValidationException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNodeCommands;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.vcs.util.FilePanel;

public class ApplyPatchCommand
extends AbstractPatchCommand {
    public static final String APPLY_PATCH_CMD = ApplyPatchCommand.class.getName();
    public static final int APPLY_PATCH_CMD_ID = Ide.findOrCreateCmdID((String)APPLY_PATCH_CMD);
    private static final int MODEL_OPTION_REVERSE_PATCH = 1;
    private static final int USE_FUZZINESS_LINE_VARIANCE = 10;
    private static final int PROGRESS_MIN = 0;
    private static final int PROGRESS_MAX = 100;
    private static final String ENCODING = "apply-patch-encoding";

    public ApplyPatchCommand() {
        super(APPLY_PATCH_CMD_ID);
    }

    protected ApplyPatchCommand(int id) {
        super(id);
    }

    protected Locatable[] getLocatablesToApplyPatch() throws Exception {
        Project contextProject = this.getContextProject();
        if (contextProject != null) {
            if (this.getContext().getView() instanceof HistoryViewer) {
                return new Locatable[]{contextProject};
            }
            return this.getProjectFolderNodes(contextProject);
        }
        return this.getContextLocatables();
    }

    protected boolean isAvailableImpl() throws Exception {
        if (this.getContext().getView() instanceof CompareEditor) {
            return false;
        }
        Locatable[] locatables = this.getLocatablesToApplyPatch();
        if (this.getContextProject() != null) {
            int i = 0;
            while (i < locatables.length) {
                if (this.isAvailableImpl(locatables[i].getURL())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return locatables.length == 1 && this.isAvailableImpl(locatables[0].getURL());
    }

    protected int doitImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToApplyPatch();
        if (locatables.length <= 0) {
            return 0;
        }
        Collection<Object> nodes = Arrays.asList(locatables);
        if (this.getContextProject() != null) {
            nodes = this.processNodesForProjectOperation(this.getContextProject(), nodes);
        }
        if (nodes == null) {
            return 1;
        }
        Node[] affectedNodes = this.getCachedBaseURLNodes(VCSModelUtils.convertNodesToURLs(nodes));
        if (!VCSCommandUtils.saveDirtyNodes((Locatable[])affectedNodes)) {
            return 1;
        }
        URL[] urls = VCSModelUtils.convertNodesToURLs(nodes);
        URL operationWorkingDirectoryUrl = this.getOperationWorkingDirectoryURL(urls);
        if (operationWorkingDirectoryUrl == null) {
            return 9;
        }
        this.getContext().setProperty(ENCODING, (Object)StreamDecoder.getDefaultEncoding((URL)operationWorkingDirectoryUrl));
        ApplyPatchUI ui = this.createUI(urls);
        JEWTDialog dialog = VCSComponents.createOperationDialog(VCSWindowUtils.getCurrentWindow(), VCSArb.getString(155), null, VCSComponents.createFileListerComponent(nodes), ui, "f1_scsapplypatch_html", ui.getClipboardRadioButton());
        dialog.setOKButtonText(VCSArb.getString(226));
        dialog.addVetoableChangeListener((VetoableChangeListener)new 1(this, ui));
        if (!VCSDialogRunner.runDialog((JDialog)dialog)) {
            return 1;
        }
        return this.doOperation(urls, ui);
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new PatchValidationException(VCSArb.getString(94), VCSArb.getString(8));
    }

    private Node[] getCachedBaseURLNodes(URL[] baseUrls) {
        return VCSModelUtils.findCachedNodes(VCSURLFilters.createBaseURLContentsFilter(baseUrls));
    }

    private ApplyPatchUI createUI(URL[] urls) {
        ApplyPatchUI ui = new ApplyPatchUI();
        this.initializeFileChooserPanel(ui.getFileChooserPanel(), urls);
        ui.getFileChooserPanel().setDialogType(1);
        String clipboardContents = this.getStringFromClipboard();
        if (clipboardContents == null || clipboardContents.equals("")) {
            ui.getClipboardRadioButton().setEnabled(false);
            ui.getFileRadioButton().setSelected(true);
        } else {
            ui.getClipboardRadioButton().setSelected(true);
        }
        ui.getFileRadioButton().addChangeListener(new 2(this, ui));
        this.updateFileOptionsEnabledState(ui);
        this.initializePreferredSizeOfUI(ui);
        return ui;
    }

    private void updateFileOptionsEnabledState(ApplyPatchUI ui) {
        ui.getFileChooserPanel().setEnabled(ui.getFileRadioButton().isSelected());
    }

    private int doOperation(URL[] urls, ApplyPatchUI ui) throws Exception {
        3 r = new 3(this, this, this.getExceptionHandler(), urls, ui);
        new Thread((Runnable)r, "Apply Patch (Parsing)").start();
        return 0;
    }

    private int doOperationImpl(URL[] urls, ApplyPatchUI ui) throws Exception {
        boolean clipboard = ui.getClipboardRadioButton().isSelected();
        PatchModel patchModel = null;
        try {
            PatchFormat patchFormat = new PatchFormat();
            patchFormat.setEncoding((String)this.getContext().getProperty(ENCODING));
            patchModel = patchFormat.parse(clipboard ? this.getStringFromClipboard() : this.readStringFromURL(ui.getFileChooserPanel().getURL(), patchFormat.getEncoding()));
        }
        catch (ParseException pe) {
            if (clipboard) {
                throw new PatchOperationException(VCSArb.getString(173), VCSArb.getString(32));
            }
            throw new PatchOperationException(VCSArb.getString(196), VCSArb.getString(44));
        }
        return this.doOperationImpl2(urls, patchModel);
    }

    private int doOperationImpl2(URL[] urls, PatchModel patchModel) throws Exception {
        EventQueue.invokeLater(new 4(this, urls, patchModel));
        return 0;
    }

    private int doOperationImpl3(URL[] urls, PatchModel patchModel) throws IOException {
        JEWTDialog dialog = new JEWTDialog(IdeUtil.getMainWindow(), VCSArb.getString(154), 3);
        ApplyPatchPreviewUI ui = new ApplyPatchPreviewUI(new PatchPreviewUI());
        ui.getPatchPreviewUI().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        ui.getPatchPreviewUI().getPatchChangesTree().setPropagateCheckState(true);
        ui.getPatchPreviewUI().getPatchChangesTree().setRootVisible(false);
        JMutableTreeNode rootTreeNode = (JMutableTreeNode)ui.getPatchPreviewUI().getPatchChangesTree().getModel().getRoot();
        dialog.setPreferredSize(new Dimension(800, 600));
        ui.getPatchPreviewUI().setPreferredSize(new Dimension(0, dialog.getPreferredSize().height / 2));
        ui.getCompareViewerPanel().setPreferredSize(new Dimension(0, dialog.getPreferredSize().height / 2));
        PreviewDialogState dialogState = new PreviewDialogState(null);
        Assert.check((urls.length == 1 ? 1 : 0) != 0);
        URL directoryUrl = this.getOperationWorkingDirectoryURL(urls);
        String argumentFilePath = URLFileSystem.isDirectoryPath((URL)urls[0]) ? null : URLFileSystem.getFileName((URL)urls[0]);
        PatchContributorImpl patchContributor = new PatchContributorImpl(directoryUrl, argumentFilePath);
        dialogState.setUI(ui);
        dialogState.setRootTreeNode(rootTreeNode);
        dialogState.setPatchContributor(patchContributor);
        dialogState.setPatchEngine(new PatchEngine((PatchContributor)patchContributor));
        dialogState.setOriginalPatchModel(patchModel);
        dialogState.setPatchModel(patchModel);
        dialogState.setOptions(this.createOptions(ui));
        dialogState.setURLs(urls);
        dialogState.setDialog(dialog);
        this.initializeChangesTreeModel(dialogState);
        this.initializeChangesTreeFromModel(dialogState);
        ((DefaultTreeModel)ui.getPatchPreviewUI().getPatchChangesTree().getModel()).reload((TreeNode)rootTreeNode);
        ui.getPatchPreviewUI().getPatchChangesTree().expandAllRows();
        ui.getPatchPreviewUI().getPatchChangesTree().addTreeSelectionListener((TreeSelectionListener)new 5(this, dialogState));
        ui.getPatchPreviewUI().getPatchChangesTree().addTreeCellCheckedListener((TreeCellCheckedListener)new 6(this, dialogState, ui));
        this.validatePreviewCompareViewerLater(dialogState);
        7 validateChangesTreeActionListener = new 7(this, dialogState, ui);
        ui.getPatchPreviewUI().getReversePatchCheckBox().addActionListener(validateChangesTreeActionListener);
        ui.getPatchPreviewUI().getIgnoreWhitespaceCheckBox().addActionListener(validateChangesTreeActionListener);
        ui.getPatchPreviewUI().getUseFuzzinessCheckBox().addActionListener(validateChangesTreeActionListener);
        dialog.setContent(ui.getComponent());
        dialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)dialog.getContent(), "f1_scsapplypatchpreview_html");
        dialog.addVetoableChangeListener((VetoableChangeListener)new 8(this, dialog));
        if (!VCSDialogRunner.runDialog((JDialog)dialog)) {
            return 1;
        }
        return this.doOperationImpl4(dialogState);
    }

    private void validateChangesTreeForModelOptions(PreviewDialogState dialogState, ApplyPatchPreviewUI ui) {
        dialogState.setOptions(this.createOptions(ui));
        this.validateChangesTreeModel(dialogState);
        try {
            this.initializeChangesTreeFromModel(dialogState);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        EventQueue.invokeLater(new 9(this, ui, dialogState));
        this.validatePreviewCompareViewerLater(dialogState);
    }

    private void invokeChangesTreeNodesChanged(DefaultTreeModel treeModel, JMutableTreeNode treeNode) {
        treeModel.nodeChanged((TreeNode)treeNode);
        int i = 0;
        while (i < treeNode.getChildCount()) {
            this.invokeChangesTreeNodesChanged(treeModel, (JMutableTreeNode)treeNode.getChildAt(i));
            ++i;
        }
    }

    private int doOperationImpl4(PreviewDialogState dialogState) {
        DeterminateProgressMonitor progressMonitor = new DeterminateProgressMonitor((Component)VCSWindowUtils.getCurrentWindow(), VCSArb.getString(107), (Object)VCSArb.getString(180), "", 0, 100);
        ProgressDetailsArea progressDetailsArea = new ProgressDetailsArea();
        progressMonitor.setCancellable(false);
        progressMonitor.setMillisToPopup(0);
        progressMonitor.setDetailContent(progressDetailsArea.getComponent());
        progressMonitor.setDetailVisible(false);
        progressMonitor.setCloseOnFinish(false);
        10 r = new 10(this, this, this.getExceptionHandler(), dialogState, progressMonitor, progressDetailsArea);
        r.setDeterminateProgressMonitor(progressMonitor);
        new Thread((Runnable)r, "Apply Patch (Patching)").start();
        return 0;
    }

    private int doOperationImpl5(PreviewDialogState dialogState, DeterminateProgressMonitor progressMonitor, ProgressDetailsArea progressDetailsArea) throws IOException {
        ArrayList<Node> affectedNodes = new ArrayList<Node>();
        ArrayList<JMutableTreeNode> entryTreeNodes = new ArrayList<JMutableTreeNode>();
        for (JMutableTreeNode entryTreeNode : dialogState.getEntryTreeNodes()) {
            boolean entryUrlExists;
            JTreeCellData entryCellData = entryTreeNode.getModel();
            ChangesTreeEntryUserObject entryUserObject = (ChangesTreeEntryUserObject)entryCellData.getUserObject();
            if (entryCellData.getCheckBoxState() == TriStateBoolean.FALSE || entryUserObject.getURL() == null) continue;
            boolean bl = entryUrlExists = URLFileSystem.exists((URL)entryUserObject.getURL()) && !URLFileSystem.isDirectory((URL)entryUserObject.getURL());
            if (entryUserObject.getState() != 1 && !entryUrlExists) continue;
            Node node = NodeFactory.find((URL)entryUserObject.getURL());
            if (node != null) {
                affectedNodes.add(node);
            }
            entryTreeNodes.add(entryTreeNode);
        }
        PatchListenerImpl patchListener = new PatchListenerImpl(progressMonitor, progressDetailsArea);
        dialogState.getPatchEngine().addPatchListener((PatchListener)patchListener);
        try {
            dialogState.getPatchEngine().applyModel(dialogState.getPatchModel(), this.createPatchContext(dialogState), new PatchApplyOptions());
            int n = 0;
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            dialogState.getPatchEngine().removePatchListener((PatchListener)patchListener);
            EventQueue.invokeLater(new 11(this, affectedNodes));
        }
    }

    private PreviewDialogOptions createOptions(ApplyPatchPreviewUI ui) {
        PreviewDialogOptions previewDialogOptions = new PreviewDialogOptions(null);
        int options = 0;
        if (ui.getPatchPreviewUI().getReversePatchCheckBox().isSelected()) {
            options |= 1;
        }
        previewDialogOptions.setPreviewOptions(options);
        PatchMatchOptions patchMatchOptions = new PatchMatchOptions();
        if (ui.getPatchPreviewUI().getIgnoreWhitespaceCheckBox().isSelected()) {
            patchMatchOptions.setIgnoreWhitespace(true);
        }
        if (ui.getPatchPreviewUI().getUseFuzzinessCheckBox().isSelected()) {
            patchMatchOptions.setMaximumFuzzFactor(10);
        }
        previewDialogOptions.setPatchMatchOptions(patchMatchOptions);
        return previewDialogOptions;
    }

    private void validatePreviewCompareViewerLater(PreviewDialogState dialogState) {
        EventQueue.invokeLater(new 12(this, dialogState));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validatePreviewCompareViewer(PreviewDialogState dialogState, TreePath treePath) {
        JMutableTreeNode treeNode = null;
        if (treePath != null) {
            treeNode = (JMutableTreeNode)treePath.getLastPathComponent();
        }
        dialogState.getUI().getCompareViewerPanel().removeAll();
        try {
            try {
                if (treeNode == null) {
                }
                this.validatePreviewCompareViewer(dialogState, treeNode);
                return;
            }
            finally {
                this.repaintCompareViewerPanel(dialogState.getUI());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        catch (CompareFailedException cfe) {
            cfe.printStackTrace();
            return;
        }
    }

    private void validatePreviewCompareViewer(PreviewDialogState dialogState, JMutableTreeNode treeNode) throws IOException, CompareFailedException {
        JTreeCellData treeCellData = treeNode.getModel();
        SimpleTextCompareContributor leftContributor = null;
        SimpleTextCompareContributor rightContributor = null;
        if (treeCellData.getUserObject() instanceof ChangesTreeHunkUserObject) {
            ChangesTreeHunkUserObject hunkUserObject = (ChangesTreeHunkUserObject)treeCellData.getUserObject();
            PatchHunk patchHunk = hunkUserObject.getHunk();
            leftContributor = new SimpleTextCompareContributor(this.createTextBuffer(this.extractHunkFromFileData(patchHunk)), VCSArb.getString(77), hunkUserObject.getCompareContributorType());
            rightContributor = new SimpleTextCompareContributor(this.createTextBuffer(this.extractHunkToFileData(patchHunk)), VCSArb.getString(85), hunkUserObject.getCompareContributorType());
        }
        if (treeCellData.getUserObject() instanceof ChangesTreeEntryUserObject) {
            ChangesTreeEntryUserObject entryUserObject = (ChangesTreeEntryUserObject)treeCellData.getUserObject();
            if (treeCellData.getCheckBoxState() == TriStateBoolean.FALSE) {
                return;
            }
            if (entryUserObject.getURL() == null) {
                return;
            }
            TextBuffer entryTextBuffer = null;
            TextBuffer resultTextBuffer = null;
            boolean entryUrlExists = URLFileSystem.exists((URL)entryUserObject.getURL()) && !URLFileSystem.isDirectory((URL)entryUserObject.getURL());
            entryTextBuffer = entryUrlExists ? this.createTextBuffer(entryUserObject.getURL()) : TextBufferFactory.createArrayTextBuffer();
            entryTextBuffer.setReadOnly(true);
            resultTextBuffer = entryUserObject.getState() == 3 ? this.createTextBuffer(entryUserObject.getURL()) : TextBufferFactory.createArrayTextBuffer();
            if (entryUserObject.getState() != 2) {
                this.transformEntryTextBuffer(dialogState, resultTextBuffer, treeNode);
            }
            leftContributor = new SimpleTextCompareContributor(entryTextBuffer, VCSArb.getString(77), entryUserObject.getCompareContributorType());
            rightContributor = new SimpleTextCompareContributor(resultTextBuffer, VCSArb.getString(85), entryUserObject.getCompareContributorType());
        }
        if (leftContributor == null || rightContributor == null) {
            return;
        }
        SequenceCompareModel compareModel = (SequenceCompareModel)CompareModelFactory.createCompareModel(leftContributor, rightContributor, (CompareType)CompareType.TEXT);
        CompareView compareView = dialogState.getCompareView();
        if (compareView == null) {
            compareView = CompareViewFactory.createCompareView((CompareModel)compareModel);
            dialogState.setCompareView(compareView);
        } else {
            compareView.setModel((CompareModel)compareModel);
        }
        dialogState.getUI().getCompareViewerPanel().add(compareView.getGUI(), "Center");
        if (compareView instanceof NavigableView) {
            ((NavigableView)compareView).goToFirstDifference();
        }
        if (compareView instanceof CustomHorizontalScrollView) {
            dialogState.getUI().getCompareViewerPanel().add(((CustomHorizontalScrollView)compareView).getHorizontalScrollComponent(), "South");
        }
    }

    private void transformEntryTextBuffer(PreviewDialogState dialogState, TextBuffer entryTextBuffer, JMutableTreeNode entryTreeNode) throws IOException {
        JTreeCellData entryCellData = entryTreeNode.getModel();
        if (entryCellData.getCheckBoxState() == TriStateBoolean.FALSE) {
            return;
        }
        entryTextBuffer.writeLock();
        try {
            ChangesTreeEntryUserObject entryUserObject = (ChangesTreeEntryUserObject)entryCellData.getUserObject();
            File previewFile = new File(URLFileSystem.getPlatformPathName((URL)entryUserObject.getURL()));
            PreviewPatchContributor patchContributor = new PreviewPatchContributor(dialogState.getPatchContributor(), entryTextBuffer, previewFile);
            new PatchEngine((PatchContributor)patchContributor).applyModel(dialogState.getPatchModel(), this.createPatchContext(dialogState), new PatchApplyOptions());
        }
        finally {
            entryTextBuffer.writeUnlock();
        }
    }

    private void repaintCompareViewerPanel(ApplyPatchPreviewUI ui) {
        ui.getCompareViewerPanel().validate();
        ui.getCompareViewerPanel().invalidate();
        ui.getCompareViewerPanel().repaint();
    }

    private void initializeChangesTreeModel(PreviewDialogState dialogState) {
        PatchEntry[] patchEntries = dialogState.getPatchModel().getEntries();
        ArrayList<JMutableTreeNode> entryTreeNodes = dialogState.getEntryTreeNodes();
        if (entryTreeNodes == null) {
            entryTreeNodes = new ArrayList<JMutableTreeNode>();
            dialogState.setEntryTreeNodes(entryTreeNodes);
        } else {
            entryTreeNodes.clear();
        }
        int i = 0;
        while (i < patchEntries.length) {
            JMutableTreeNode entryTreeNode = new JMutableTreeNode(null, true);
            PatchHunk[] patchHunks = patchEntries[i].getHunks();
            int j = 0;
            while (j < patchHunks.length) {
                entryTreeNode.add((MutableTreeNode)new JMutableTreeNode(null, false));
                ++j;
            }
            dialogState.getRootTreeNode().add((MutableTreeNode)entryTreeNode);
            entryTreeNodes.add(entryTreeNode);
            ++i;
        }
        this.validateChangesTreeModel(dialogState);
    }

    private void validateChangesTreeModel(PreviewDialogState dialogState) {
        int options = dialogState.getOptions().getPreviewOptions();
        if ((options & 1) > 0) {
            dialogState.setPatchModel(dialogState.getPatchEngine().reverseModel(dialogState.getOriginalPatchModel(), null));
        } else {
            dialogState.setPatchModel(dialogState.getOriginalPatchModel());
        }
        PatchEntry[] patchEntries = dialogState.getPatchModel().getEntries();
        JMutableTreeNode[] entryTreeNodes = dialogState.getEntryTreeNodes().toArray(new JMutableTreeNode[0]);
        int i = 0;
        while (i < entryTreeNodes.length) {
            JTreeCellData entryCellData = entryTreeNodes[i].getModel();
            if (entryCellData == null) {
                entryCellData = new JTreeCellData(null, "?", true);
            }
            ChangesTreeEntryUserObject entryUserObject = new ChangesTreeEntryUserObject(patchEntries[i]);
            entryCellData.setUserObject((Object)entryUserObject);
            entryTreeNodes[i].setModel(entryCellData);
            PatchHunk[] patchHunks = patchEntries[i].getHunks();
            int j = 0;
            while (j < patchHunks.length) {
                JMutableTreeNode hunkTreeNode = (JMutableTreeNode)entryTreeNodes[i].getChildAt(j);
                JTreeCellData hunkCellData = hunkTreeNode.getModel();
                if (hunkCellData == null) {
                    hunkCellData = new JTreeCellData(null, "?", true);
                }
                ChangesTreeHunkUserObject hunkUserObject = new ChangesTreeHunkUserObject(patchHunks[j]);
                hunkCellData.setUserObject((Object)hunkUserObject);
                hunkTreeNode.setModel(hunkCellData);
                ++j;
            }
            ++i;
        }
    }

    private void initializeChangesTreeFromModel(PreviewDialogState dialogState) throws IOException {
        dialogState.setPatchContext(dialogState.getPatchEngine().matchModel(dialogState.getPatchModel(), dialogState.getOptions().getPatchMatchOptions()));
        this.initializeChangesTreeCellStates(dialogState);
        dialogState.getRootTreeNode().sortChildren();
        this.setChangesDialogButtonState(dialogState);
    }

    private void initializeChangesTreeCellStates(PreviewDialogState dialogState) throws IOException {
        this.initializeChangesTreeEntryData(dialogState);
        this.initializeChangesTreeHunkData(dialogState);
        this.initializeChangesTreeCellData(dialogState);
    }

    private void initializeChangesTreeEntryData(PreviewDialogState dialogState) {
        URL[] urls = dialogState.getURLs();
        for (JMutableTreeNode entryTreeNode : dialogState.getEntryTreeNodes()) {
            ChangesTreeEntryUserObject entryUserObject = (ChangesTreeEntryUserObject)entryTreeNode.getModel().getUserObject();
            PatchEntry patchEntry = entryUserObject.getEntry();
            entryUserObject.setState(-1);
            if (patchEntry.getFromFile() == null && patchEntry.getToFile() != null) {
                entryUserObject.setState(1);
            }
            if (patchEntry.getFromFile() != null && patchEntry.getToFile() == null) {
                entryUserObject.setState(2);
            }
            if (entryUserObject.getState() < 0) {
                entryUserObject.setState(3);
            }
            URL patchEntryUrl = this.createPatchEntryURL(entryUserObject, urls);
            if (entryUserObject.getState() != 1 && !URLFileSystem.exists((URL)patchEntryUrl)) {
                entryUserObject.setNoFile(true);
            }
            if (URLFileSystem.isDirectory((URL)patchEntryUrl)) {
                entryUserObject.setNoFile(true);
            }
            if (URLFileSystem.exists((URL)patchEntryUrl) && URLFileSystem.isReadOnly((URL)patchEntryUrl) && !VCSManager.getVCSManager().isVersioned(patchEntryUrl)) {
                entryUserObject.setReadOnly(true);
            }
            if (dialogState.getPatchContext().isEntryMatched(entryUserObject.getEntry()) && !entryUserObject.isNoFile() && !entryUserObject.isReadOnly()) {
                entryUserObject.setURL(patchEntryUrl);
            }
            entryUserObject.setPath(patchEntry.getFromFile());
        }
    }

    private URL createPatchEntryURL(ChangesTreeEntryUserObject entryUserObject, URL[] urls) {
        URL patchEntryUrl = URLFactory.newURL((URL)this.getOperationWorkingDirectoryURL(urls), (String)entryUserObject.getEntry().getFromFile());
        int i = 0;
        while (i < urls.length) {
            if (URLFileSystem.isDirectoryPath((URL)urls[i]) && URLFileSystem.isBaseURLFor((URL)urls[i], (URL)patchEntryUrl)) {
                return patchEntryUrl;
            }
            if (URLFileSystem.equals((URL)urls[i], (URL)patchEntryUrl)) {
                return patchEntryUrl;
            }
            ++i;
        }
        return null;
    }

    private void initializeChangesTreeHunkData(PreviewDialogState dialogState) throws IOException {
        for (JMutableTreeNode entryTreeNode : dialogState.getEntryTreeNodes()) {
            ChangesTreeEntryUserObject entryUserObject = (ChangesTreeEntryUserObject)entryTreeNode.getModel().getUserObject();
            TextBuffer entryTextBuffer = null;
            if (entryUserObject.getURL() != null) {
                entryTextBuffer = this.createTextBuffer(entryUserObject.getURL());
                entryTextBuffer.setReadOnly(true);
            }
            entryUserObject.setCompareContributorType(this.extractFilePathExtension(entryUserObject.getPath()));
            int j = 0;
            while (j < entryTreeNode.getChildCount()) {
                JMutableTreeNode hunkTreeNode = (JMutableTreeNode)entryTreeNode.getChildAt(j);
                ChangesTreeHunkUserObject hunkUserObject = (ChangesTreeHunkUserObject)hunkTreeNode.getModel().getUserObject();
                hunkUserObject.setCompareContributorType(entryUserObject.getCompareContributorType());
                if (entryUserObject.getURL() != null && entryTextBuffer != null) {
                    if (entryUserObject.getState() != 3) {
                        hunkUserObject.setMatched(true);
                    } else {
                        int hunkMatchLine = dialogState.getPatchContext().getHunkMatchLine(hunkUserObject.getHunk());
                        hunkUserObject.setMatched(hunkMatchLine >= 0);
                        hunkUserObject.setMatchLine(hunkMatchLine);
                    }
                }
                ++j;
            }
        }
    }

    private String extractFilePathExtension(String path) {
        int i = path != null ? path.lastIndexOf(46) : -1;
        return i < 0 ? "" : path.substring(i + 1);
    }

    private void initializeChangesTreeCellData(PreviewDialogState dialogState) {
        for (JMutableTreeNode entryTreeNode : dialogState.getEntryTreeNodes()) {
            JTreeCellData entryCellData;
            ChangesTreeEntryUserObject entryUserObject = (ChangesTreeEntryUserObject)(entryCellData = entryTreeNode.getModel()).getUserObject();
            entryCellData.setEnabled(entryUserObject.getURL() != null);
            entryCellData.setCheckBoxState(false);
            entryCellData.setTextSelectable(true);
            entryCellData.setTextEnabled(true);
            entryCellData.setIcon(this.getCellIconForEntry(entryUserObject));
            entryCellData.setText(this.getCellTextForEntry(entryUserObject));
            int j = 0;
            while (j < entryTreeNode.getChildCount()) {
                JMutableTreeNode hunkTreeNode = (JMutableTreeNode)entryTreeNode.getChildAt(j);
                JTreeCellData hunkCellData = hunkTreeNode.getModel();
                ChangesTreeHunkUserObject hunkUserObject = (ChangesTreeHunkUserObject)hunkCellData.getUserObject();
                PatchHunk patchHunk = hunkUserObject.getHunk();
                String cellText = VCSArb.format(56, new Object[]{Integer.toString(patchHunk.getFromFileLineNumber()), Integer.toString(patchHunk.getFromFileLineCount()), Integer.toString(patchHunk.getToFileLineNumber()), Integer.toString(patchHunk.getToFileLineCount())});
                hunkCellData.setEnabled(hunkUserObject.isMatched());
                hunkCellData.setCheckBoxState(hunkUserObject.isMatched());
                hunkCellData.setTextSelectable(true);
                hunkCellData.setTextEnabled(true);
                if (!hunkUserObject.isMatched()) {
                    cellText = VCSArb.format(104, cellText);
                }
                hunkCellData.setText(cellText);
                hunkCellData.setIcon(hunkUserObject.isMatched() ? VCSArb.getIcon(209) : VCSArb.getIcon(117));
                if (hunkUserObject.isMatched()) {
                    entryCellData.setCheckBoxState(true);
                }
                ++j;
            }
        }
    }

    private Icon getCellIconForEntry(ChangesTreeEntryUserObject entryUserObject) {
        if (entryUserObject.isNoFile()) {
            return VCSArb.getIcon(101);
        }
        if (entryUserObject.isReadOnly()) {
            return VCSArb.getIcon(148);
        }
        if (entryUserObject.getURL() == null) {
            return VCSArb.getIcon(125);
        }
        if (entryUserObject.getState() == 1) {
            return VCSArb.getIcon(167);
        }
        if (entryUserObject.getState() == 2) {
            return VCSArb.getIcon(191);
        }
        return VCSArb.getIcon(215);
    }

    private String getCellTextForEntry(ChangesTreeEntryUserObject entryUserObject) {
        String cellText = entryUserObject.getEntry().getFromFile();
        if (entryUserObject.isNoFile()) {
            return VCSArb.format(162, cellText);
        }
        if (entryUserObject.isReadOnly()) {
            return VCSArb.format(147, cellText);
        }
        if (entryUserObject.getURL() == null) {
            return VCSArb.format(112, cellText);
        }
        if (entryUserObject.getState() == 1) {
            return VCSArb.format(153, cellText);
        }
        if (entryUserObject.getState() == 2) {
            return VCSArb.format(129, cellText);
        }
        return cellText;
    }

    private String[] extractHunkFromFileData(PatchHunk patchHunk) {
        PatchHunkLine[] patchHunkLines = patchHunk.getLines();
        ArrayList<String> fileHunkData = new ArrayList<String>();
        int i = 0;
        while (i < patchHunkLines.length) {
            if (patchHunkLines[i].getIndicator() != 2) {
                fileHunkData.add(patchHunkLines[i].getLineData());
            }
            ++i;
        }
        return fileHunkData.toArray(new String[0]);
    }

    private String[] extractHunkToFileData(PatchHunk patchHunk) {
        PatchHunkLine[] patchHunkLines = patchHunk.getLines();
        ArrayList<String> fileHunkData = new ArrayList<String>();
        int i = 0;
        while (i < patchHunkLines.length) {
            if (patchHunkLines[i].getIndicator() != 3) {
                fileHunkData.add(patchHunkLines[i].getLineData());
            }
            ++i;
        }
        return fileHunkData.toArray(new String[0]);
    }

    private TextBuffer createTextBuffer(URL url) throws IOException {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        textBuffer.writeLock();
        if (URLFileSystem.exists((URL)url)) {
            textBuffer.read((Reader)new InputStreamReader((InputStream)new FileInputStream(URLFileSystem.getPlatformPathName((URL)url)), (String)this.getContext().getProperty(ENCODING)));
        }
        textBuffer.writeUnlock();
        return textBuffer;
    }

    private TextBuffer createTextBuffer(String[] lineDataArray) {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        textBuffer.writeLock();
        char[] eol = new char[]{'\n'};
        int i = 0;
        while (i < lineDataArray.length) {
            if (i > 0) {
                textBuffer.append(eol);
            }
            textBuffer.append(lineDataArray[i].toCharArray());
            ++i;
        }
        textBuffer.writeUnlock();
        return textBuffer;
    }

    private void setChangesDialogButtonStateLater(PreviewDialogState dialogState) {
        EventQueue.invokeLater(new 13(this, dialogState));
    }

    private void setChangesDialogButtonState(PreviewDialogState dialogState) {
        for (JMutableTreeNode entryTreeNode : dialogState.getEntryTreeNodes()) {
            if (entryTreeNode.getModel().getCheckBoxState() == TriStateBoolean.FALSE) continue;
            dialogState.getDialog().setOKButtonEnabled(true);
            return;
        }
        dialogState.getDialog().setOKButtonEnabled(false);
    }

    private String getStringFromClipboard() {
        Transferable data = Toolkit.getDefaultToolkit().getSystemClipboard().getContents((Object)this);
        if (data == null) {
            return null;
        }
        if (!data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return null;
        }
        try {
            String string = (String)data.getTransferData(DataFlavor.stringFlavor);
            return string;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            String string = null;
            return string;
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            String string = null;
            return string;
        }
    }

    private String readStringFromURL(URL url, String charsetName) throws IOException {
        int n;
        InputStreamReader isr = new InputStreamReader(URLFileSystem.openInputStream((URL)url), charsetName);
        StringWriter sw = new StringWriter();
        char[] c = new char[(int)Math.pow(2.0, 10.0)];
        while ((n = isr.read(c, 0, c.length)) >= 0) {
            if (n <= 0) continue;
            sw.write(c, 0, n);
        }
        isr.close();
        return sw.toString();
    }

    private PatchContext createPatchContext(PreviewDialogState dialogState) {
        PatchContext patchContext = (PatchContext)dialogState.getPatchContext().clone();
        for (JMutableTreeNode entryTreeNode : dialogState.getEntryTreeNodes()) {
            JTreeCellData entryCellData = entryTreeNode.getModel();
            if (entryCellData.getCheckBoxState() == TriStateBoolean.FALSE) {
                patchContext.setEntryMatched(((ChangesTreeEntryUserObject)entryCellData.getUserObject()).getEntry(), false);
                continue;
            }
            int j = 0;
            while (j < entryTreeNode.getChildCount()) {
                JTreeCellData hunkCellData = ((JMutableTreeNode)entryTreeNode.getChildAt(j)).getModel();
                if (hunkCellData.getCheckBoxState() == TriStateBoolean.FALSE) {
                    patchContext.setHunkMatchLine(((ChangesTreeHunkUserObject)hunkCellData.getUserObject()).getHunk(), -1);
                }
                ++j;
            }
        }
        return patchContext;
    }

    static void mav$setChangesDialogButtonState(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState) {
        applyPatchCommand.setChangesDialogButtonState(previewDialogState);
    }

    static void mav$validatePreviewCompareViewer(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState, TreePath treePath) {
        applyPatchCommand.validatePreviewCompareViewer(previewDialogState, treePath);
    }

    static int mav$doOperationImpl5(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState, DeterminateProgressMonitor determinateProgressMonitor, ProgressDetailsArea progressDetailsArea) {
        return applyPatchCommand.doOperationImpl5(previewDialogState, determinateProgressMonitor, progressDetailsArea);
    }

    static void mav$invokeChangesTreeNodesChanged(ApplyPatchCommand applyPatchCommand, DefaultTreeModel defaultTreeModel, JMutableTreeNode jMutableTreeNode) {
        applyPatchCommand.invokeChangesTreeNodesChanged(defaultTreeModel, jMutableTreeNode);
    }

    static void mav$setChangesDialogButtonStateLater(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState) {
        applyPatchCommand.setChangesDialogButtonStateLater(previewDialogState);
    }

    static void mav$validatePreviewCompareViewerLater(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState) {
        applyPatchCommand.validatePreviewCompareViewerLater(previewDialogState);
    }

    static void mav$validateChangesTreeForModelOptions(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState, ApplyPatchPreviewUI applyPatchPreviewUI) {
        applyPatchCommand.validateChangesTreeForModelOptions(previewDialogState, applyPatchPreviewUI);
    }

    static int mav$doOperationImpl3(ApplyPatchCommand applyPatchCommand, URL[] uRLArray, PatchModel patchModel) {
        return applyPatchCommand.doOperationImpl3(uRLArray, patchModel);
    }

    static int mav$doOperationImpl(ApplyPatchCommand applyPatchCommand, URL[] uRLArray, ApplyPatchUI applyPatchUI) {
        return applyPatchCommand.doOperationImpl(uRLArray, applyPatchUI);
    }

    static void mav$updateFileOptionsEnabledState(ApplyPatchCommand applyPatchCommand, ApplyPatchUI applyPatchUI) {
        applyPatchCommand.updateFileOptionsEnabledState(applyPatchUI);
    }

    final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ ApplyPatchUI v$ui;
        final /* synthetic */ ApplyPatchCommand this$0;

        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
                return;
            }
            if (!this.v$ui.getFileRadioButton().isSelected()) {
                return;
            }
            URL url = this.v$ui.getFileChooserPanel().getURL();
            if (!URLFileSystem.exists((URL)url)) {
                this.validationFailed(VCSArb.getString(15), e);
            }
            if (URLFileSystem.isDirectory((URL)url)) {
                this.validationFailed(VCSArb.getString(152), e);
            }
        }

        private void validationFailed(String message, PropertyChangeEvent e) throws PropertyVetoException {
            this.this$0.getExceptionHandler().handleException(new PatchValidationException(message));
            this.throwPropertyVetoException(e);
        }

        private void throwPropertyVetoException(PropertyChangeEvent e) throws PropertyVetoException {
            throw new PropertyVetoException("", e);
        }

        public 1(ApplyPatchCommand applyPatchCommand, ApplyPatchUI applyPatchUI) {
            this.v$ui = applyPatchUI;
            this.this$0 = applyPatchCommand;
        }
    }

    final class 2
    implements ChangeListener {
        private final /* synthetic */ ApplyPatchUI v$ui;
        final /* synthetic */ ApplyPatchCommand this$0;

        public final void stateChanged(ChangeEvent e) {
            ApplyPatchCommand.mav$updateFileOptionsEnabledState(this.this$0, this.v$ui);
        }

        public 2(ApplyPatchCommand applyPatchCommand, ApplyPatchUI applyPatchUI) {
            this.v$ui = applyPatchUI;
            this.this$0 = applyPatchCommand;
        }
    }

    final class 3
    extends WaitRunnable {
        private final /* synthetic */ URL[] v$urls;
        private final /* synthetic */ ApplyPatchUI v$ui;
        final /* synthetic */ ApplyPatchCommand this$0;

        public final void runImpl() throws Exception {
            ApplyPatchCommand.mav$doOperationImpl(this.this$0, this.v$urls, this.v$ui);
        }

        public 3(ApplyPatchCommand applyPatchCommand, ApplyPatchCommand applyPatchCommand2, VCSExceptionHandler vCSExceptionHandler, URL[] uRLArray, ApplyPatchUI applyPatchUI) {
            this.v$ui = applyPatchUI;
            this.v$urls = uRLArray;
            this.this$0 = applyPatchCommand;
            super(vCSExceptionHandler);
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ URL[] v$urls;
        private final /* synthetic */ PatchModel v$patchModel;
        final /* synthetic */ ApplyPatchCommand this$0;

        public final void run() {
            try {
                ApplyPatchCommand.mav$doOperationImpl3(this.this$0, this.v$urls, this.v$patchModel);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public 4(ApplyPatchCommand applyPatchCommand, URL[] uRLArray, PatchModel patchModel) {
            this.v$patchModel = patchModel;
            this.v$urls = uRLArray;
            this.this$0 = applyPatchCommand;
        }
    }

    final class 5
    implements TreeSelectionListener {
        private final /* synthetic */ PreviewDialogState v$dialogState;
        final /* synthetic */ ApplyPatchCommand this$0;

        public final void valueChanged(TreeSelectionEvent e) {
            ApplyPatchCommand.mav$validatePreviewCompareViewer(this.this$0, this.v$dialogState, e.getPath());
        }

        public 5(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState) {
            this.v$dialogState = previewDialogState;
            this.this$0 = applyPatchCommand;
        }
    }

    final class 6
    implements TreeCellCheckedListener {
        private final /* synthetic */ PreviewDialogState v$dialogState;
        private final /* synthetic */ ApplyPatchPreviewUI v$ui;
        final /* synthetic */ ApplyPatchCommand this$0;

        public final void cellChecked(TreeCellCheckedEvent e) {
            this.handleTreeCellCheckedEvent(e);
        }

        public final void cellUnchecked(TreeCellCheckedEvent e) {
            this.handleTreeCellCheckedEvent(e);
        }

        private final void handleTreeCellCheckedEvent(TreeCellCheckedEvent e) {
            ApplyPatchCommand.mav$setChangesDialogButtonStateLater(this.this$0, this.v$dialogState);
            TreePath treePath = this.v$ui.getPatchPreviewUI().getPatchChangesTree().getSelectionPath();
            if (treePath == null) {
                return;
            }
            JMutableTreeNode treeNode = (JMutableTreeNode)treePath.getLastPathComponent();
            if (!(treeNode.getModel().getUserObject() instanceof ChangesTreeEntryUserObject)) {
                return;
            }
            ApplyPatchCommand.mav$validatePreviewCompareViewerLater(this.this$0, this.v$dialogState);
        }

        public 6(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState, ApplyPatchPreviewUI applyPatchPreviewUI) {
            this.v$ui = applyPatchPreviewUI;
            this.v$dialogState = previewDialogState;
            this.this$0 = applyPatchCommand;
        }
    }

    final class 7
    implements ActionListener {
        private final /* synthetic */ PreviewDialogState v$dialogState;
        private final /* synthetic */ ApplyPatchPreviewUI v$ui;
        final /* synthetic */ ApplyPatchCommand this$0;

        public final void actionPerformed(ActionEvent e) {
            ApplyPatchCommand.mav$validateChangesTreeForModelOptions(this.this$0, this.v$dialogState, this.v$ui);
        }

        public 7(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState, ApplyPatchPreviewUI applyPatchPreviewUI) {
            this.v$ui = applyPatchPreviewUI;
            this.v$dialogState = previewDialogState;
            this.this$0 = applyPatchCommand;
        }
    }

    final class 8
    implements VetoableChangeListener {
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ ApplyPatchCommand this$0;

        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
                return;
            }
            boolean confirmResult = MessageDialog.confirm((Component)this.v$dialog, (Object)VCSArb.getString(21), (String)VCSArb.getString(168), null, (boolean)true, (String)UIManager.getString("OptionPane.okButtonText"), (String)UIManager.getString("OptionPane.cancelButtonText"));
            if (!confirmResult) {
                throw new PropertyVetoException("", e);
            }
        }

        public 8(ApplyPatchCommand applyPatchCommand, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.this$0 = applyPatchCommand;
        }
    }

    final class 9
    implements Runnable {
        private final /* synthetic */ ApplyPatchPreviewUI v$ui;
        private final /* synthetic */ PreviewDialogState v$dialogState;
        final /* synthetic */ ApplyPatchCommand this$0;

        public final void run() {
            ApplyPatchCommand.mav$invokeChangesTreeNodesChanged(this.this$0, (DefaultTreeModel)this.v$ui.getPatchPreviewUI().getPatchChangesTree().getModel(), this.v$dialogState.getRootTreeNode());
        }

        public 9(ApplyPatchCommand applyPatchCommand, ApplyPatchPreviewUI applyPatchPreviewUI, PreviewDialogState previewDialogState) {
            this.v$dialogState = previewDialogState;
            this.v$ui = applyPatchPreviewUI;
            this.this$0 = applyPatchCommand;
        }
    }

    final class 10
    extends WaitRunnable {
        private final /* synthetic */ PreviewDialogState v$dialogState;
        private final /* synthetic */ DeterminateProgressMonitor v$progressMonitor;
        private final /* synthetic */ ProgressDetailsArea v$progressDetailsArea;
        final /* synthetic */ ApplyPatchCommand this$0;

        public final void runImpl() throws Exception {
            ApplyPatchCommand.mav$doOperationImpl5(this.this$0, this.v$dialogState, this.v$progressMonitor, this.v$progressDetailsArea);
            ProgressPanel progressPanel = this.v$progressMonitor.getPanel();
            if (progressPanel != null) {
                progressPanel.setMessage(VCSArb.getString(28));
            }
        }

        public 10(ApplyPatchCommand applyPatchCommand, ApplyPatchCommand applyPatchCommand2, VCSExceptionHandler vCSExceptionHandler, PreviewDialogState previewDialogState, DeterminateProgressMonitor determinateProgressMonitor, ProgressDetailsArea progressDetailsArea) {
            this.v$progressDetailsArea = progressDetailsArea;
            this.v$progressMonitor = determinateProgressMonitor;
            this.v$dialogState = previewDialogState;
            this.this$0 = applyPatchCommand;
            super(vCSExceptionHandler);
        }
    }

    final class 11
    implements Runnable {
        private final /* synthetic */ Collection v$affectedNodes;
        final /* synthetic */ ApplyPatchCommand this$0;

        public void run() {
            for (Node affectedNode : this.v$affectedNodes) {
                if (!affectedNode.isOpen()) continue;
                RevertNodeCommand.reload((Node)affectedNode, (boolean)false);
            }
        }

        public 11(ApplyPatchCommand applyPatchCommand, Collection collection) {
            this.v$affectedNodes = collection;
            this.this$0 = applyPatchCommand;
        }
    }

    final class 12
    implements Runnable {
        private final /* synthetic */ PreviewDialogState v$dialogState;
        final /* synthetic */ ApplyPatchCommand this$0;

        public final void run() {
            ApplyPatchCommand.mav$validatePreviewCompareViewer(this.this$0, this.v$dialogState, this.v$dialogState.getUI().getPatchPreviewUI().getPatchChangesTree().getSelectionPath());
        }

        public 12(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState) {
            this.v$dialogState = previewDialogState;
            this.this$0 = applyPatchCommand;
        }
    }

    final class 13
    implements Runnable {
        private final /* synthetic */ PreviewDialogState v$dialogState;
        final /* synthetic */ ApplyPatchCommand this$0;

        public final void run() {
            ApplyPatchCommand.mav$setChangesDialogButtonState(this.this$0, this.v$dialogState);
        }

        public 13(ApplyPatchCommand applyPatchCommand, PreviewDialogState previewDialogState) {
            this.v$dialogState = previewDialogState;
            this.this$0 = applyPatchCommand;
        }
    }

    private class PatchContributorImpl
    extends PatchContributor {
        PatchContributorImpl(URL directoryUrl, String argumentFilePath) {
            super(new File(URLFileSystem.getPlatformPathName((URL)directoryUrl)), argumentFilePath);
        }

        protected PatchIndexFile constructIndexFileImpl(File directoryFile, String path) {
            return new PatchIndexFileImpl(URLFactory.newFileURL((File)directoryFile), path);
        }
    }

    private class PatchIndexFileImpl
    extends PatchIndexFile {
        private final URL _url;

        PatchIndexFileImpl(URL directoryUrl, String path) {
            super(new File(URLFileSystem.getPlatformPathName((URL)directoryUrl)), path);
            this._url = URLFactory.newFileURL((File)this.getFile());
            this.setEncoding(StreamDecoder.getDefaultEncoding((URL)this._url));
        }

        protected boolean delete() {
            if (!URLFileSystem.delete((URL)this._url)) {
                return false;
            }
            Node node = NodeFactory.find((URL)this._url);
            if (node == null) {
                return true;
            }
            Context context = new Context();
            context.setSelection(new Element[]{node});
            Command closeNodeCommand = VCSNodeCommands.createQuietCloseNodeCommand(context);
            EventQueue.invokeLater(new 1(this, closeNodeCommand));
            return true;
        }

        protected boolean setLastModified(long modTime) {
            return URLFileSystem.setLastModified((URL)this._url, (long)modTime);
        }

        protected boolean setReadOnly(boolean readOnly) {
            return URLFileSystem.setReadOnly((URL)this._url, (boolean)readOnly);
        }

        protected String getRevision() {
            return null;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Command v$closeNodeCommand;
            final /* synthetic */ PatchIndexFileImpl this$0;

            public final void run() {
                try {
                    this.v$closeNodeCommand.doit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public 1(PatchIndexFileImpl patchIndexFileImpl, Command command) {
                this.v$closeNodeCommand = command;
                this.this$0 = patchIndexFileImpl;
            }
        }
    }

    private class PreviewPatchContributor
    extends PatchContributor {
        private final TextBuffer _textBuffer;
        private final File _previewFile;

        PreviewPatchContributor(PatchContributor patchContributor, TextBuffer textBuffer, File previewFile) {
            super(patchContributor.getDirectoryFile(), patchContributor.getArgumentFilePath());
            this._textBuffer = textBuffer;
            this._previewFile = previewFile;
        }

        protected PatchIndexFile constructIndexFileImpl(File directoryFile, String path) {
            PreviewPatchIndexFile indexFile = new PreviewPatchIndexFile(directoryFile, path);
            if (indexFile.getFile().equals(this._previewFile)) {
                indexFile.setTextBuffer(this._textBuffer);
            }
            return indexFile;
        }
    }

    private class PreviewPatchIndexFile
    extends PatchIndexFile {
        PreviewPatchIndexFile(File directoryFile, String path) {
            super(directoryFile, path);
        }

        protected boolean createNewFile() throws IOException {
            return true;
        }

        protected boolean saveTextBuffer() throws IOException {
            return true;
        }

        protected boolean createBackup(String backupFileName) throws IOException {
            return true;
        }

        protected boolean delete() {
            return true;
        }

        protected boolean setLastModified(long modTime) {
            return true;
        }

        protected boolean setReadOnly(boolean readOnly) {
            return true;
        }
    }

    private class PatchListenerImpl
    extends PatchAdapter {
        private final DeterminateProgressMonitor _progressMonitor;
        private final ProgressDetailsArea _progressDetailsArea;
        private int _patchedFileCount;

        PatchListenerImpl(DeterminateProgressMonitor progressMonitor, ProgressDetailsArea progressDetailsArea) {
            this._progressMonitor = progressMonitor;
            this._progressDetailsArea = progressDetailsArea;
        }

        public void patchApplyStarted(PatchEvent pe) {
            this.logLine(VCSArb.getString(99));
        }

        public void patchFileCreated(PatchEvent pe) {
            this.logLine(VCSArb.format(18, new Object[]{pe.getFirstFilePath()}));
        }

        public void patchFileCreateFailed(PatchEvent pe) {
            this.logLine(VCSArb.format(100, new Object[]{pe.getFirstFilePath()}));
        }

        public void patchFileDeleted(PatchEvent pe) {
            this.logLine(VCSArb.format(116, new Object[]{pe.getFirstFilePath()}));
        }

        public void patchFileDeleteFailed(PatchEvent pe) {
            this.logLine(VCSArb.format(122, new Object[]{pe.getFirstFilePath()}));
        }

        public void patchFileBackedUp(PatchEvent pe) {
            this.logLine(VCSArb.format(19, new Object[]{pe.getFirstFilePath(), pe.getSecondFilePath()}));
        }

        public void patchFileBackupFailed(PatchEvent pe) {
            this.logLine(VCSArb.format(214, new Object[]{pe.getFirstFilePath(), pe.getSecondFilePath()}));
        }

        public void patchBufferChanging(PatchEvent pe) {
            this.logLine(VCSArb.format(67, new Object[]{pe.getFirstFilePath()}));
        }

        public void patchFileSaved(PatchEvent pe) {
            this.logLine(VCSArb.format(41, new Object[]{pe.getFirstFilePath()}));
            ProgressPanel progressPanel = this._progressMonitor.getPanel();
            if (progressPanel != null) {
                progressPanel.setNote(VCSArb.format(189, new Object[]{Integer.toString(++this._patchedFileCount)}));
            }
        }

        public void patchFileSaveFailed(PatchEvent pe) {
            this.logLine(VCSArb.format(81, new Object[]{pe.getFirstFilePath()}));
        }

        public void patchApplyFinished(PatchEvent pe) {
            this._progressDetailsArea.log(VCSArb.getString(83));
        }

        public void patchProgressUpdated(PatchEvent pe) {
            this._progressMonitor.setProgress(Math.min(100, (int)(pe.getProgress() * 100.0f)));
        }

        private void logLine(String message) {
            this._progressDetailsArea.log(message);
            this._progressDetailsArea.logNewLine();
        }
    }

    private class ApplyPatchPreviewUI
    extends JSplitPane {
        private final PatchPreviewUI _patchPreviewUI;
        private final JPanel _compareViewerPanel;

        ApplyPatchPreviewUI(PatchPreviewUI patchPreviewUI) {
            super(0);
            this._patchPreviewUI = patchPreviewUI;
            this._compareViewerPanel = new JPanel(new BorderLayout());
            this.setResizeWeight(0.5);
            this.setDividerLocation(0.5);
            this.setOneTouchExpandable(true);
            this.setLeftComponent(this._patchPreviewUI);
            this.setRightComponent(this._compareViewerPanel);
        }

        public Component getComponent() {
            return this;
        }

        public PatchPreviewUI getPatchPreviewUI() {
            return this._patchPreviewUI;
        }

        public JPanel getCompareViewerPanel() {
            return this._compareViewerPanel;
        }
    }

    private abstract class WaitRunnable
    implements Runnable {
        private final VCSExceptionHandler _exceptionHandler;
        private DeterminateProgressMonitor _progressMonitor;

        WaitRunnable() {
            this(null);
        }

        WaitRunnable(VCSExceptionHandler exceptionHandler) {
            this._exceptionHandler = exceptionHandler;
        }

        public void setDeterminateProgressMonitor(DeterminateProgressMonitor progressMonitor) {
            this._progressMonitor = progressMonitor;
        }

        public void run() {
            EventQueue.invokeLater(new 1());
            if (this._progressMonitor != null) {
                this._progressMonitor.display();
            }
            Exception exception = null;
            try {
                try {
                    this.runImpl();
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            finally {
                if (this._progressMonitor != null) {
                    if (this._progressMonitor.getCloseOnFinish()) {
                        this._progressMonitor.close();
                    } else {
                        this._progressMonitor.finish();
                    }
                }
                EventQueue.invokeLater(new 2());
                if (exception != null) {
                    if (this._exceptionHandler != null) {
                        this._exceptionHandler.handleException(exception);
                    } else {
                        exception.printStackTrace();
                    }
                }
            }
        }

        protected abstract void runImpl() throws Exception;

        final class 1
        implements Runnable {
            public final void run() {
                Ide.getWaitCursor().show();
            }
        }

        final class 2
        implements Runnable {
            public final void run() {
                Ide.getWaitCursor().hide();
            }
        }
    }

    private abstract class ChangesTreeUserObject {
        private String _compareContributorType;

        public void setCompareContributorType(String compareContributorType) {
            this._compareContributorType = compareContributorType;
        }

        public String getCompareContributorType() {
            return this._compareContributorType;
        }

        private ChangesTreeUserObject() {
        }

        ChangesTreeUserObject(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ChangesTreeEntryUserObject
    extends ChangesTreeUserObject {
        public static final int STATE_ADDED = 1;
        public static final int STATE_REMOVED = 2;
        public static final int STATE_MODIFIED = 3;
        private final PatchEntry _entry;
        private int _state;
        private URL _url;
        private String _path;
        private boolean _noFile;
        private boolean _readOnly;

        ChangesTreeEntryUserObject(PatchEntry entry) {
            super(null);
            this._entry = entry;
        }

        public PatchEntry getEntry() {
            return this._entry;
        }

        public void setState(int state) {
            this._state = state;
        }

        public int getState() {
            return this._state;
        }

        public void setURL(URL url) {
            this._url = url;
        }

        public URL getURL() {
            return this._url;
        }

        public void setPath(String path) {
            this._path = path;
        }

        public String getPath() {
            return this._path;
        }

        public void setNoFile(boolean noFile) {
            this._noFile = noFile;
        }

        public boolean isNoFile() {
            return this._noFile;
        }

        public void setReadOnly(boolean readOnly) {
            this._readOnly = readOnly;
        }

        public boolean isReadOnly() {
            return this._readOnly;
        }
    }

    private class ChangesTreeHunkUserObject
    extends ChangesTreeUserObject {
        private final PatchHunk _hunk;
        private boolean _matched;
        private int _matchLine;

        ChangesTreeHunkUserObject(PatchHunk hunk) {
            super(null);
            this._hunk = hunk;
        }

        public PatchHunk getHunk() {
            return this._hunk;
        }

        public void setMatched(boolean matched) {
            this._matched = matched;
        }

        public boolean isMatched() {
            return this._matched;
        }

        public void setMatchLine(int matchLine) {
            this._matchLine = matchLine;
        }

        public int getMatchLine() {
            return this._matchLine;
        }
    }

    private class SimpleTextCompareContributor
    extends TextCompareContributor {
        private final TextBuffer _textBuffer;
        private final String _label;
        private final String _type;

        SimpleTextCompareContributor(TextBuffer textBuffer, String label, String type) {
            this._textBuffer = textBuffer;
            this._label = label;
            this._type = type;
        }

        public TextBuffer getTextBuffer() {
            return this._textBuffer;
        }

        public String getShortLabel() {
            return this._label;
        }

        public String getLongLabel() {
            return this._label;
        }

        public String getType() {
            return this._type;
        }
    }

    private class PreviewDialogOptions {
        private int _options;
        private PatchMatchOptions _patchMatchOptions;

        void setPreviewOptions(int options) {
            this._options = options;
        }

        int getPreviewOptions() {
            return this._options;
        }

        void setPatchMatchOptions(PatchMatchOptions patchMatchOptions) {
            this._patchMatchOptions = patchMatchOptions;
        }

        PatchMatchOptions getPatchMatchOptions() {
            return this._patchMatchOptions;
        }

        private PreviewDialogOptions() {
        }

        PreviewDialogOptions(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PreviewDialogState {
        private ApplyPatchPreviewUI _ui;
        private JMutableTreeNode _rootTreeNode;
        private PatchContributor _patchContributor;
        private PatchEngine _patchEngine;
        private PatchModel _originalPatchModel;
        private PatchModel _patchModel;
        private PatchContext _patchContext;
        private PreviewDialogOptions _options;
        private URL[] _urls;
        private JEWTDialog _dialog;
        private Collection _entryTreeNodes;
        private CompareView _compareView;

        public void setUI(ApplyPatchPreviewUI ui) {
            this._ui = ui;
        }

        public ApplyPatchPreviewUI getUI() {
            return this._ui;
        }

        public void setRootTreeNode(JMutableTreeNode rootTreeNode) {
            this._rootTreeNode = rootTreeNode;
        }

        public JMutableTreeNode getRootTreeNode() {
            return this._rootTreeNode;
        }

        public void setPatchContributor(PatchContributor patchContributor) {
            this._patchContributor = patchContributor;
        }

        public PatchContributor getPatchContributor() {
            return this._patchContributor;
        }

        public void setPatchEngine(PatchEngine patchEngine) {
            this._patchEngine = patchEngine;
        }

        public PatchEngine getPatchEngine() {
            return this._patchEngine;
        }

        public void setOriginalPatchModel(PatchModel originalPatchModel) {
            this._originalPatchModel = originalPatchModel;
        }

        public PatchModel getOriginalPatchModel() {
            return this._originalPatchModel;
        }

        public void setPatchModel(PatchModel patchModel) {
            this._patchModel = patchModel;
        }

        public PatchModel getPatchModel() {
            return this._patchModel;
        }

        public void setPatchContext(PatchContext patchContext) {
            this._patchContext = patchContext;
        }

        public PatchContext getPatchContext() {
            return this._patchContext;
        }

        public void setOptions(PreviewDialogOptions options) {
            this._options = options;
        }

        public PreviewDialogOptions getOptions() {
            return this._options;
        }

        public void setURLs(URL[] urls) {
            this._urls = urls;
        }

        public URL[] getURLs() {
            return this._urls;
        }

        public void setDialog(JEWTDialog dialog) {
            this._dialog = dialog;
        }

        public JEWTDialog getDialog() {
            return this._dialog;
        }

        public void setEntryTreeNodes(Collection entryTreeNodes) {
            this._entryTreeNodes = entryTreeNodes;
        }

        public Collection getEntryTreeNodes() {
            return this._entryTreeNodes;
        }

        public void setCompareView(CompareView compareView) {
            this._compareView = compareView;
        }

        public CompareView getCompareView() {
            return this._compareView;
        }

        private PreviewDialogState() {
        }

        PreviewDialogState(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ApplyPatchUI
    extends JPanel {
        private JLabel _patchSourceLabel;
        private JRadioButton _clipboardRadioButton;
        private JRadioButton _fileRadioButton;
        private FilePanel _fileChooserPanel;

        public ApplyPatchUI() {
            this.setName("ApplyPatchUI");
            this.createComponents();
            this.layoutComponents();
            this.localizeComponentsMethod();
            ButtonGroup bg = new ButtonGroup();
            bg.add(this._clipboardRadioButton);
            bg.add(this._fileRadioButton);
        }

        private void createComponents() {
            this._patchSourceLabel = new JLabel();
            this._patchSourceLabel.setName("PatchSourceLabel");
            this._clipboardRadioButton = new JRadioButton();
            this._clipboardRadioButton.setName("ClipboardRadioButton");
            this._fileRadioButton = new JRadioButton();
            this._fileRadioButton.setName("FileRadioButton");
            this._fileChooserPanel = new FilePanel();
            this._fileChooserPanel.setName("FileChooserPanel");
        }

        private void layoutComponents() {
            int insetSize = 2;
            Insets i = new Insets(insetSize, insetSize, insetSize, insetSize);
            LayoutBuilder builder = new LayoutBuilder();
            JComponent c = this._patchSourceLabel;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 2, false, true);
            builder.nl();
            builder.addHGap();
            c = this._clipboardRadioButton;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, true);
            builder.nl();
            builder.addHGap();
            c = this._fileRadioButton;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, true);
            builder.nl();
            builder.addHGap();
            c = this._fileChooserPanel;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, true);
            builder.nl();
            builder.addToPanel((Container)this);
        }

        private void localizeComponentsMethod() {
            ResourceUtils.resLabel((JLabel)this._patchSourceLabel, (Component)this._patchSourceLabel, (String)VCSArb.getString(145));
            ResourceUtils.resButton((AbstractButton)this._clipboardRadioButton, (String)VCSArb.getString(175));
            ResourceUtils.resButton((AbstractButton)this._fileRadioButton, (String)VCSArb.getString(210));
        }

        public JLabel getPatchSourceLabel() {
            return this._patchSourceLabel;
        }

        public JRadioButton getClipboardRadioButton() {
            return this._clipboardRadioButton;
        }

        public JRadioButton getFileRadioButton() {
            return this._fileRadioButton;
        }

        public FilePanel getFileChooserPanel() {
            return this._fileChooserPanel;
        }
    }

    private class PatchPreviewUI
    extends JPanel {
        private JLabel _patchChangesLabel;
        private CustomJTree _patchChangesTree;
        private JScrollPane _patchChangesTreeScrollPane;
        private JCheckBox _useFuzzinessCheckBox;
        private JCheckBox _reversePatchCheckBox;
        private JCheckBox _ignoreWhitespaceCheckBox;

        public PatchPreviewUI() {
            this.setName("PatchPreviewUI");
            this.createComponents();
            this.layoutComponents();
            this.localizeComponentsMethod();
        }

        private void createComponents() {
            this._patchChangesLabel = new JLabel();
            this._patchChangesLabel.setName("PatchChangesLabel");
            this._patchChangesTree = new CustomJTree();
            this._patchChangesTree.setName("PatchChangesTree");
            this._patchChangesTreeScrollPane = new JScrollPane((Component)this._patchChangesTree);
            this._useFuzzinessCheckBox = new JCheckBox();
            this._useFuzzinessCheckBox.setName("UseFuzzinessCheckBox");
            this._reversePatchCheckBox = new JCheckBox();
            this._reversePatchCheckBox.setName("ReversePatchCheckBox");
            this._ignoreWhitespaceCheckBox = new JCheckBox();
            this._ignoreWhitespaceCheckBox.setName("IgnoreWhitespaceCheckBox");
            this._patchChangesLabel.setLabelFor((Component)this._patchChangesTree);
        }

        private void layoutComponents() {
            int insetSize = 2;
            Insets i = new Insets(insetSize, insetSize, insetSize, insetSize);
            LayoutBuilder builder = new LayoutBuilder();
            JComponent c = this._patchChangesLabel;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 4, false, true);
            builder.nl();
            c = this._patchChangesTreeScrollPane;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 4, true, true);
            builder.nl();
            builder.addHFiller();
            c = this._useFuzzinessCheckBox;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, false);
            c = this._reversePatchCheckBox;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, false);
            c = this._ignoreWhitespaceCheckBox;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, false);
            builder.nl();
            builder.addToPanel((Container)this);
        }

        private void localizeComponentsMethod() {
            ResourceUtils.resLabel((JLabel)this._patchChangesLabel, (Component)this._patchChangesLabel, (String)VCSArb.getString(188));
            ResourceUtils.resButton((AbstractButton)this._reversePatchCheckBox, (String)VCSArb.getString(53));
            ResourceUtils.resButton((AbstractButton)this._ignoreWhitespaceCheckBox, (String)VCSArb.getString(92));
            ResourceUtils.resButton((AbstractButton)this._useFuzzinessCheckBox, (String)VCSArb.getString(160));
        }

        public JLabel getPatchChangesLabel() {
            return this._patchChangesLabel;
        }

        public CustomJTree getPatchChangesTree() {
            return this._patchChangesTree;
        }

        public JScrollPane getPatchChangesTreeScrollPane() {
            return this._patchChangesTreeScrollPane;
        }

        public JCheckBox getUseFuzzinessCheckBox() {
            return this._useFuzzinessCheckBox;
        }

        public JCheckBox getReversePatchCheckBox() {
            return this._reversePatchCheckBox;
        }

        public JCheckBox getIgnoreWhitespaceCheckBox() {
            return this._ignoreWhitespaceCheckBox;
        }
    }
}

