/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.properties.PropertiesPanelProvider;
import oracle.jdeveloper.vcs.properties.PropertiesPanelRegistry;
import oracle.jdeveloper.vcs.properties.PropertiesUtil;
import oracle.jdeveloper.vcs.properties.PropertiesVetoException;

public class PropertiesCommand
extends Command {
    public static final String PROPERTIES_CMD = PropertiesCommand.class.getName();
    public static final int PROPERTIES_CMD_ID = Ide.findOrCreateCmdID((String)PROPERTIES_CMD);

    public PropertiesCommand() {
        super(PROPERTIES_CMD_ID, 0);
    }

    public int doit() throws Exception {
        ArrayList<PropertiesPanelProvider> providers = new ArrayList<PropertiesPanelProvider>(Arrays.asList(PropertiesPanelRegistry.getPanelProviders()));
        Collections.sort(providers, new 1());
        Iterator<PropertiesPanelProvider> itr = providers.iterator();
        while (itr.hasNext()) {
            PropertiesPanelProvider provider = itr.next();
            if (provider.isHandled(this.getContext())) continue;
            itr.remove();
        }
        if (providers.size() <= 0) {
            return -1;
        }
        Component content = null;
        ArrayList<PropertiesPanel> panels = new ArrayList<PropertiesPanel>();
        if (providers.size() == 1) {
            PropertiesPanel panel = providers.iterator().next().createPanel(this.getContext());
            panels.add(panel);
            content = panel.getComponent();
        } else {
            JTabbedPane tabbedPane = new JTabbedPane();
            JPanel defaultTabComponent = null;
            for (PropertiesPanelProvider provider : providers) {
                PropertiesPanel panel = provider.createPanel(this.getContext());
                JPanel borderPanel = new JPanel(new BorderLayout());
                borderPanel.add(panel.getComponent(), "North");
                borderPanel.add(Box.createGlue(), "Center");
                borderPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
                tabbedPane.addTab(provider.getTabName(), borderPanel);
                if (!provider.isDefaultTab()) continue;
                defaultTabComponent = borderPanel;
            }
            if (defaultTabComponent != null) {
                tabbedPane.setSelectedComponent(defaultTabComponent);
            }
            content = tabbedPane;
        }
        HelpInfo helpInfo = null;
        Iterator<PropertiesPanelProvider> itr2 = providers.iterator();
        while (itr2.hasNext() && helpInfo == null) {
            helpInfo = itr2.next().getHelpInfo();
        }
        if (helpInfo != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)content, helpInfo.getHelpTopicID());
        }
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)content, null, (String)this.createPropertiesTitle(PropertiesUtil.getContextElement(this.getContext())));
        dialog.addVetoableChangeListener((VetoableChangeListener)new 2(this, panels, dialog));
        int buttonMask = 1;
        if (helpInfo != null) {
            buttonMask += 4;
        }
        Iterator itr3 = panels.iterator();
        while (itr3.hasNext()) {
            if (!((PropertiesPanel)itr3.next()).isEditable()) continue;
            buttonMask += 2;
            break;
        }
        dialog.setButtonMask(buttonMask);
        dialog.setResizable(false);
        return WizardLauncher.runDialog((JDialog)dialog) ? 0 : 1;
    }

    public static final boolean isEnabled(Context context) {
        PropertiesPanelProvider[] providers = PropertiesPanelRegistry.getPanelProviders();
        Element element = context.getElement() != null ? context.getElement() : context.getNode();
        int i = 0;
        while (element != null && i < providers.length) {
            if (providers[i].isHandled(context)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String createPropertiesTitle(Element element) {
        if (!(element instanceof Displayable)) {
            return VCSArb.getString(103);
        }
        return VCSArb.format(74, ((Displayable)element).getShortLabel());
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return new Float(((PropertiesPanelProvider)o1).getTabWeight()).compareTo(new Float(((PropertiesPanelProvider)o2).getTabWeight()));
        }
    }

    final class 2
    implements VetoableChangeListener {
        private final /* synthetic */ Collection v$panels;
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ PropertiesCommand this$0;

        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
                return;
            }
            try {
                Iterator itr = this.v$panels.iterator();
                while (itr.hasNext()) {
                    ((PropertiesPanel)itr.next()).validateProperties();
                }
                Iterator itr2 = this.v$panels.iterator();
                while (itr2.hasNext()) {
                    ((PropertiesPanel)itr2.next()).stopWorkerThreads();
                }
                Iterator itr3 = this.v$panels.iterator();
                while (itr3.hasNext()) {
                    ((PropertiesPanel)itr3.next()).commitProperties();
                }
            }
            catch (PropertiesVetoException pve) {
                MessageDialog.error((Component)this.v$dialog, (Object)pve.getMessage(), (String)VCSArb.getString(150), null);
                throw new PropertyVetoException("", e);
            }
        }

        public 2(PropertiesCommand propertiesCommand, Collection collection, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.v$panels = collection;
            this.this$0 = propertiesCommand;
        }
    }
}

