/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.share;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.vcs.VCSManager;
import oracle.ide.wizard.Wizard;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.share.ShareController;
import oracle.jdeveloper.vcs.share.ShareWizard;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareCommand
extends VCSCommand {
    private static final String SHARE_CMD = ShareCommand.class.getName();
    private static final int SHARE_APPLICATION_CMD_ID = Ide.createCmdID((String)SHARE_CMD);
    private static final int SHARE_PROJECT_CMD_ID = Ide.createCmdID((String)SHARE_CMD);
    private static final int SHARE_FILES_CMD_ID = Ide.createCmdID((String)SHARE_CMD);
    private static final Collection<Wizard> _wizards = new ArrayList<Wizard>();

    public static final IdeAction getShareApplicationAction() {
        return ShareCommand.getShareAction(SHARE_APPLICATION_CMD_ID, VCSArb.getString(65));
    }

    public static final IdeAction getShareProjectAction() {
        return ShareCommand.getShareAction(SHARE_PROJECT_CMD_ID, VCSArb.getString(158));
    }

    public static final IdeAction getShareFilesAction() {
        return ShareCommand.getShareAction(SHARE_FILES_CMD_ID, VCSArb.getString(143));
    }

    private static final IdeAction getShareAction(int cmdId, String text) {
        IdeAction shareAction = IdeAction.find((int)cmdId);
        if (shareAction != null) {
            return shareAction;
        }
        shareAction = IdeAction.get((int)cmdId, (String)SHARE_CMD, (String)StringUtils.stripMnemonic((String)text), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)text)), (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)true);
        shareAction.addController((Controller)new ShareController());
        return shareAction;
    }

    public ShareCommand() {
        super(SHARE_FILES_CMD_ID);
    }

    public static final void registerShareWizard(Wizard wizard) {
        _wizards.add(wizard);
    }

    private Collection<Wizard> getAvailableWizards() {
        Context context = this.getContext();
        ArrayList<Wizard> wizards = new ArrayList<Wizard>();
        for (Wizard wizard : _wizards) {
            if (!wizard.isAvailable(context)) continue;
            wizards.add(wizard);
        }
        return wizards;
    }

    @Override
    protected boolean isAvailableImpl() throws Exception {
        if (!super.isAvailableImpl()) {
            return false;
        }
        URL[] uRLArray = VCSModelUtils.convertNodesToURLs(VCSContextUtils.getContextLocatables(this.context));
        int n = 0;
        while (n < uRLArray.length) {
            URL url = uRLArray[n];
            if (VCSManager.getVCSManager().isVersioned(url)) {
                return false;
            }
            ++n;
        }
        Collection<Wizard> wizards = this.getAvailableWizards();
        return !wizards.isEmpty();
    }

    @Override
    protected int doitImpl() {
        Wizard wizard;
        Collection<Wizard> wizards = this.getAvailableWizards();
        if (wizards.isEmpty()) {
            throw new IllegalStateException();
        }
        Node node = this.getContext().getNode();
        if (wizards.size() == 1) {
            wizard = wizards.iterator().next();
        } else {
            NiceList list = new NiceList();
            list.setCellRenderer((ListCellRenderer)((Object)new 1(this, node)));
            Collections.sort((List)wizards, new 2());
            DefaultListModel<Wizard> listModel = new DefaultListModel<Wizard>();
            for (Wizard o : wizards) {
                listModel.addElement(o);
            }
            list.setModel(listModel);
            list.setPrototypeCellValue((Object)new ShareWizard("Acme VCS v1.0", OracleIcons.getIcon((String)"action.png"), 0));
            list.setPreferredSize(new Dimension(320, 0));
            list.setVisibleRowCount(Math.min(wizards.size() + 1, 5));
            JLabel label = new JLabel();
            ResourceUtils.resLabel((JLabel)label, (Component)list, (String)VCSArb.getString(87));
            JPanel panel = new JPanel(new BorderLayout(4, 4));
            panel.add((Component)label, "North");
            panel.add((Component)new JScrollPane((Component)list), "Center");
            String title = VCSArb.getString(222);
            if (node instanceof Workspace) {
                title = VCSArb.getString(221);
            }
            if (node instanceof Project) {
                title = VCSArb.getString(232);
            }
            DialogHeader dialogHeader = new DialogHeader(VCSArb.getString(206), ((ImageIcon)OracleIcons.getIcon((String)"header/database.png")).getImage());
            OnePageWizardDialogFactory.setDialogHeader((Component)panel, (DialogHeader)dialogHeader);
            JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)list, (String)title, (int)3);
            list.setSelectedIndex(0);
            list.addDoubleClickActionListener((ActionListener)new 3(this, dialog));
            list.getSelectionModel().addListSelectionListener(new 4(this, dialog, list));
            this.updateDialogOKEnabled(dialog, (JList)list);
            if (!dialog.runDialog()) {
                return 1;
            }
            wizard = (Wizard)list.getSelectedValue();
        }
        return wizard.invoke(this.getContext()) ? 0 : -1;
    }

    private void updateDialogOKEnabled(JEWTDialog dialog, JList list) {
        dialog.setOKButtonEnabled(list.getSelectedValue() != null);
    }

    static void mav$updateDialogOKEnabled(ShareCommand shareCommand, JEWTDialog jEWTDialog, JList jList) {
        shareCommand.updateDialogOKEnabled(jEWTDialog, jList);
    }

    final class 1
    extends NiceListRenderer {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ ShareCommand this$0;

        protected String getTitle(Wizard wizard) {
            return wizard.getShortLabel();
        }

        protected String getDescription(Wizard wizard) {
            if (this.v$node instanceof Workspace) {
                return VCSArb.format(48, wizard.getShortLabel());
            }
            if (this.v$node instanceof Project) {
                return VCSArb.format(218, wizard.getShortLabel());
            }
            return VCSArb.format(124, wizard.getShortLabel());
        }

        protected boolean isItemSelected(Wizard wizard) {
            return false;
        }

        protected Icon getIndicator(Wizard wizard) {
            Icon icon = wizard.getIcon();
            if (icon != null && icon instanceof ImageIcon) {
                icon = new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance(24, 24, 4));
            }
            return icon;
        }

        protected boolean isCheckable(Wizard wizard) {
            return false;
        }

        public 1(ShareCommand shareCommand, Node node) {
            this.v$node = node;
            this.this$0 = shareCommand;
        }
    }

    final class 2
    implements Comparator {
        public int compare(Wizard o1, Wizard o2) {
            return o1.getShortLabel().compareTo(o2.getShortLabel());
        }
    }

    final class 3
    implements ActionListener {
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ ShareCommand this$0;

        public void actionPerformed(ActionEvent ae) {
            this.v$dialog.closeDialog(false);
        }

        public 3(ShareCommand shareCommand, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.this$0 = shareCommand;
        }
    }

    final class 4
    implements ListSelectionListener {
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ NiceList v$list;
        final /* synthetic */ ShareCommand this$0;

        public void valueChanged(ListSelectionEvent e) {
            ShareCommand.mav$updateDialogOKEnabled(this.this$0, this.v$dialog, (JList)this.v$list);
        }

        public 4(ShareCommand shareCommand, JEWTDialog jEWTDialog, NiceList niceList) {
            this.v$list = niceList;
            this.v$dialog = jEWTDialog;
            this.this$0 = shareCommand;
        }
    }
}

