/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controls.WaitCursor;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommandType;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSStatusFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public abstract class VCSCommand
extends Command {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int ERROR = -1;
    public static final int NOOP = 9;
    private VCSCommandStyle _commandStyle;
    private VCSCommandType _commandType;

    protected VCSCommand(int cmdId) {
        super(cmdId, 1);
        this.initializeCommandStyle(VCSCommandStyle.NORMAL);
        this.initializeCommandType(VCSCommandType.BOTH);
    }

    protected VCSCommand(int cmdId, int type) {
        super(cmdId, type);
        this.initializeCommandStyle(VCSCommandStyle.NORMAL);
        this.initializeCommandType(VCSCommandType.BOTH);
    }

    protected VCSCommand(int cmdId, int type, String name) {
        super(cmdId, type, name);
        this.initializeCommandStyle(VCSCommandStyle.NORMAL);
        this.initializeCommandType(VCSCommandType.BOTH);
    }

    protected void initializeCommandStyle(VCSCommandStyle commandStyle) {
        this._commandStyle = commandStyle;
    }

    protected void initializeCommandType(VCSCommandType commandType) {
        this._commandType = commandType;
    }

    public int doit() throws Exception {
        return this.getContext() != null && this.getContext().getBoolean("VCSController.THREAD_AUTHORIZED") && this.isThreaded() ? this.doit2() : this.doit3();
    }

    public boolean isAvailable() {
        try {
            boolean bl = this.isAvailableImpl();
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = true;
            return bl;
        }
    }

    public void noOp() {
        try {
            this.noOpImpl();
        }
        catch (VCSException ce) {
            this.getExceptionHandler().handleException(ce);
        }
    }

    protected boolean isAvailableImpl() throws Exception {
        if (this._commandStyle == VCSCommandStyle.NORMAL && this._commandType == VCSCommandType.BOTH) {
            return true;
        }
        return this.isAvailableImpl(this.getContextLocatables());
    }

    protected boolean isAvailableImpl(Locatable[] locatables) throws Exception {
        if (this.verifyStyle(locatables) && this.verifyType(locatables)) {
            return this.isAvailableImpl(locatables[0]);
        }
        return false;
    }

    protected boolean isAvailableImpl(Locatable locatable) throws Exception {
        URL url = locatable.getURL();
        if (url == null || this.getURLFilter() != null && !this.getURLFilter().accept(url)) {
            return false;
        }
        return this.isAvailableImpl(url);
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        if (this.getStatusCache() == null || this.getStatusFilter() == null) {
            return true;
        }
        return this.getStatusFilter().accept(this.getStatusCache().get(url));
    }

    private boolean verifyStyle(Locatable[] locatables) {
        if (this._commandStyle == VCSCommandStyle.NORMAL) {
            return true;
        }
        if (this._commandStyle == VCSCommandStyle.MULTI) {
            if (locatables.length <= 0) {
                return false;
            }
            if (locatables.length > 1) {
                return true;
            }
        }
        if (this._commandStyle == VCSCommandStyle.SINGLE) {
            return locatables.length == 1;
        }
        return true;
    }

    private boolean verifyType(Locatable[] locatables) {
        if (this._commandType == VCSCommandType.BOTH) {
            return true;
        }
        if (this._commandType == VCSCommandType.FILE) {
            Locatable[] locatableArray = locatables;
            int n = 0;
            while (n < locatableArray.length) {
                Locatable loc = locatableArray[n];
                if (URLFileSystem.isDirectoryPath((URL)loc.getURL())) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (this._commandType == VCSCommandType.FOLDER) {
            Locatable[] locatableArray = locatables;
            int n = 0;
            while (n < locatableArray.length) {
                Locatable loc = locatableArray[n];
                if (URLFileSystem.isRegularFile((URL)loc.getURL())) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return true;
    }

    protected void noOpImpl() throws VCSException {
    }

    protected abstract int doitImpl() throws Exception;

    protected VCSExtension getExtension() {
        Object vcs;
        Context context = this.getContext();
        Object object = vcs = context != null ? context.getProperty("VCSController.VCS") : null;
        if (vcs == null) {
            Assert.println((String)("VCS: Warning... no VCS in context for command " + this.getClass()));
            vcs = context != null ? VCSExtensionUtils.getActiveExtension(context) : null;
        }
        return vcs instanceof VCSExtension ? (VCSExtension)vcs : null;
    }

    protected VCSExceptionHandler getExceptionHandler() {
        VCSExtension extension = this.getExtension();
        return extension != null ? extension.getExceptionHandler() : null;
    }

    protected URLFilter getURLFilter() {
        VCSExtension extension = this.getExtension();
        return extension != null ? extension.getURLFilter() : null;
    }

    protected VCSStatusCache getStatusCache() {
        VCSExtension extension = this.getExtension();
        return extension != null ? extension.getStatusCache() : null;
    }

    protected VCSStatusFilter getStatusFilter() {
        return null;
    }

    protected boolean isThreaded() {
        return false;
    }

    protected final Locatable[] getContextLocatables() {
        return VCSContextUtils.getContextLocatables(this.getContext(), this.getURLFilter());
    }

    protected final Context buildContextForEditor() {
        Context context = new Context(this.getContext());
        Locatable[] locatables = this.getContextLocatables();
        if (locatables.length > 0 && locatables[0] instanceof Node) {
            context.setNode((Node)locatables[0]);
        }
        return context;
    }

    protected final void updateReadOnlyStates(Node[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            nodes[i].isReadOnly();
            ++i;
        }
    }

    protected final VCSStatusFilter createStatusFilter(VCSStatus[] statuses) {
        return VCSStatusFilters.createStatusFilter(statuses);
    }

    protected final void fireSomeFilesCreated(URL[] urls) {
        ArrayList<URL> urls0 = new ArrayList<URL>();
        int i = 0;
        while (i < urls.length) {
            if (URLFileSystem.exists((URL)urls[i])) {
                urls0.add(urls[i]);
            }
            ++i;
        }
        if (!urls0.isEmpty()) {
            VCSFileEventSender.fireFilesCreated(urls0.toArray(new URL[0]));
        }
    }

    protected final void fireSomeFilesDeleted(URL[] urls) {
        ArrayList<URL> urls0 = new ArrayList<URL>();
        int i = 0;
        while (i < urls.length) {
            if (!URLFileSystem.exists((URL)urls[i])) {
                urls0.add(urls[i]);
            }
            ++i;
        }
        if (!urls0.isEmpty()) {
            VCSFileEventSender.fireFilesDeleted(urls0.toArray(new URL[0]));
        }
    }

    protected final void fireFileStructureChanged(URL[] urls) {
        VCSFileEventSender.fireFileStructureChanged(urls);
    }

    protected final Map storeTimestamps(Collection nodes) {
        return VCSBufferUtils.storeTimestamps(nodes);
    }

    protected final void reloadBuffers(Map timestampMap) {
        VCSBufferUtils.reloadBuffers(timestampMap);
    }

    protected final Collection getFilteredSelection() throws Exception {
        return this.getFilteredSelection(this.getContextLocatables());
    }

    protected final Collection getFilteredSelection(Locatable[] locatables) throws Exception {
        return VCSCommandUtils.getFilteredSelection(locatables, this.getStatusCache(), this.getStatusFilter());
    }

    protected URLFilter getLocatableURLFilter() {
        return this.getURLFilter();
    }

    private int doit2() {
        WaitCursor wc = Ide.getWaitCursor();
        wc.show();
        1 worker = new 1(this, "Version Control Execution Thread", wc);
        worker.start();
        return 0;
    }

    private int doit3() throws Exception {
        try {
            int n = this.doitImpl();
            return n;
        }
        catch (Exception e) {
            if (e instanceof ChangeVetoException) {
                int n = 1;
                return n;
            }
            if (!(e instanceof VCSException)) {
                throw e;
            }
            if (e instanceof VCSCancelException) {
                int n = 1;
                return n;
            }
            this.getExceptionHandler().handleException(e);
            int n = -1;
            return n;
        }
    }

    static int mav$doit3(VCSCommand vCSCommand) {
        return vCSCommand.doit3();
    }

    final class oracle.jdeveloper.vcs.spi.VCSCommand$1
    extends Thread {
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ VCSCommand this$0;

        public void run() {
            try {
                try {
                    VCSCommand.mav$doit3(this.this$0);
                }
                catch (Exception e) {
                    ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)e, (String)VCSArb.getString(130), (String)e.getMessage(), null);
                }
            }
            finally {
                EventQueue.invokeLater(new 1());
            }
        }

        public oracle.jdeveloper.vcs.spi.VCSCommand$1(VCSCommand vCSCommand, String string, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.this$0 = vCSCommand;
            super(string);
        }

        static WaitCursor ra$v$wc(oracle.jdeveloper.vcs.spi.VCSCommand$1 var0) {
            return var0.v$wc;
        }

        final class 1
        implements Runnable {
            public void run() {
                oracle.jdeveloper.vcs.spi.VCSCommand$1.ra$v$wc(1.this).hide();
            }
        }
    }
}

