/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.javatools.controls.completionfield.CompletionPopupHandler;
import oracle.javatools.controls.completionfield.CompletionTextArea;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;

public class VCSCommentsCustomizer
implements VCSOptionsCustomizer {
    public static final String KEY_SETTING_COMMENTS = "setting_comments";
    public static final String KEY_SETTING_REUSE_COMMENTS = "setting_reuse_comments";
    private final VCSOptionsCustomizer _delegateCustomizer;
    private JPanel _panel;
    private VCSCommentsCustomizerUI _commentsUI;
    private boolean _showReuseCommentsOption;
    private VCSRecentCommentsModel _commentsModel;
    private int _defaultRows;
    private int _popupRows;
    private boolean _flatLook;
    private boolean _suppressContextMenu;
    private JPopupMenu _contextMenu;

    private void $init$() {
        this._defaultRows = 3;
        this._popupRows = 5;
    }

    public VCSCommentsCustomizer() {
        this(null);
    }

    public VCSCommentsCustomizer(VCSOptionsCustomizer delegateCustomizer) {
        this.$init$();
        this._delegateCustomizer = delegateCustomizer;
    }

    public void setShowReuseCommentsOption(boolean showReuseCommentsOption) {
        this._showReuseCommentsOption = showReuseCommentsOption;
    }

    public void setRecentCommentsModel(VCSRecentCommentsModel commentsModel) {
        this._commentsModel = commentsModel;
    }

    public void setSuppressContextMenu(boolean suppressContextMenu) {
        this._suppressContextMenu = suppressContextMenu;
    }

    public void setDefaultVisibleRows(int rows) {
        this._defaultRows = rows;
    }

    public void setVisiblePopupRows(int popupRows) {
        this._popupRows = popupRows;
    }

    public void setFlatLook(boolean isFlat) {
        this._flatLook = isFlat;
    }

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this._commentsUI = new VCSCommentsCustomizerUI();
            this.initializeUI();
            this.layoutContainer(this._panel, this._commentsUI, this._delegateCustomizer != null ? this._delegateCustomizer.getComponent() : null);
        }
        return this._panel;
    }

    public Component getInitialFocusComponent() {
        Component delegateFocusComponent = null;
        if (this._delegateCustomizer != null) {
            delegateFocusComponent = this._delegateCustomizer.getInitialFocusComponent();
        }
        if (delegateFocusComponent == null) {
            this.getComponent();
            return this._commentsUI.getCommentsArea();
        }
        return delegateFocusComponent;
    }

    public void setOptions(Map options) {
        Boolean b;
        this.getComponent();
        String s = (String)options.get(KEY_SETTING_COMMENTS);
        if (s != null) {
            this._commentsUI.getCommentsArea().setText(s);
        }
        if (this._showReuseCommentsOption && (b = (Boolean)options.get(KEY_SETTING_REUSE_COMMENTS)) != null) {
            this._commentsUI.getReuseCommentsCheckBox().setSelected(b);
        }
        this.updateStateForReuseComments();
        if (this._delegateCustomizer != null) {
            this._delegateCustomizer.setOptions(options);
        }
    }

    public Map getOptions() {
        this.getComponent();
        HashMap<String, Object> m = new HashMap<String, Object>();
        boolean reuseComments = this._commentsUI.getReuseCommentsCheckBox().isSelected();
        if (!reuseComments) {
            m.put(KEY_SETTING_COMMENTS, this._commentsUI.getCommentsArea().getText());
        }
        if (this._showReuseCommentsOption) {
            m.put(KEY_SETTING_REUSE_COMMENTS, reuseComments);
        }
        if (this._delegateCustomizer != null) {
            m.putAll(this._delegateCustomizer.getOptions());
        }
        return m;
    }

    public void validateOptions() throws VCSException {
        String comment;
        if (this._delegateCustomizer != null) {
            this._delegateCustomizer.validateOptions();
        }
        if (this._commentsModel != null && !this._commentsUI.getReuseCommentsCheckBox().isSelected() && !(comment = this._commentsUI.getCommentsArea().getText()).equals("")) {
            this._commentsModel.addComment(comment);
        }
    }

    public void setCommentsComponentsEnabled(boolean enabled) {
        this._commentsUI.getCommentsLabel().setEnabled(enabled);
        this._commentsUI.getCommentsArea().setEnabled(enabled);
        this._commentsUI.getCommentsArea().setOpaque(enabled);
    }

    protected void layoutContainer(Container container, Component commentsUI, Component delegateUI) {
        container.setLayout(new BorderLayout());
        JPanel container2 = null;
        if (this._delegateCustomizer != null) {
            container2 = new JPanel(new BorderLayout());
            container2.add(delegateUI, "Center");
            container2.add(Box.createVerticalStrut(5), "South");
        }
        if (container2 != null) {
            container.add(container2, "North");
        }
        container.add(commentsUI, "Center");
    }

    protected JTextComponent getTextComponent() {
        this.getComponent();
        return this._commentsUI.getCommentsArea();
    }

    private void initializeUI() {
        if (this._commentsUI == null) {
            return;
        }
        this._commentsUI.getReuseCommentsCheckBox().setVisible(this._showReuseCommentsOption);
        if (this._flatLook) {
            VCSCommentsCustomizerUI.ra$_commentsScrollPane(this._commentsUI).setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("controlShadow")));
        }
        this._commentsUI.getCommentsArea().setRows(this._defaultRows);
        this._commentsUI.getCommentsArea().setColumns(80);
        if (this._commentsModel != null) {
            this.initializeCommentsPopup();
        }
        if (!this._showReuseCommentsOption) {
            return;
        }
        this._commentsUI.getReuseCommentsCheckBox().addActionListener(new 1());
        this.updateStateForReuseComments();
    }

    private void initializeCommentsPopup() {
        CompletionPopupHandler popupHandler = this._commentsUI.getCommentsArea().getPopupHandler();
        popupHandler.setCompletionBackground(UIManager.getColor("ToolTip.background"));
        popupHandler.setWidthOfField(true);
        popupHandler.setWidthConstrained(true);
        popupHandler.setAlignWithField(true);
        popupHandler.setVisibleRowCount(this._popupRows);
        popupHandler.registerInsightProvider((FieldInsightProvider)new CommentsInsightProvider(null));
        UseRecentCommentAction action = new UseRecentCommentAction();
        if (this._suppressContextMenu) {
            return;
        }
        this._contextMenu = new JPopupMenu();
        this._contextMenu.add(new JMenuItem(action));
        this._contextMenu.addPopupMenuListener(new 2(this, action));
        this._commentsUI.getCommentsArea().addMouseListener((MouseListener)new ContextMenuMouseListener(null));
    }

    private void updateStateForReuseComments() {
        if (this._commentsUI == null) {
            return;
        }
        this.setCommentsComponentsEnabled(this._commentsUI.getReuseCommentsCheckBox().isSelected() ^ true);
    }

    private boolean isInsightEnabled() {
        if (this._commentsModel == null) {
            return false;
        }
        return this.listMatchingRecentComments().length > 0;
    }

    private Object[] listMatchingRecentComments() {
        String text = this._commentsUI.getCommentsArea().getText();
        String selectedText = this._commentsUI.getCommentsArea().getSelectedText();
        if (selectedText != null && text.equals(selectedText)) {
            return this._commentsModel.toArray();
        }
        return this._commentsModel.getMatches(text);
    }

    static int ra$_defaultRows(VCSCommentsCustomizer vCSCommentsCustomizer) {
        return vCSCommentsCustomizer._defaultRows;
    }

    static VCSCommentsCustomizerUI ra$_commentsUI(VCSCommentsCustomizer vCSCommentsCustomizer) {
        return vCSCommentsCustomizer._commentsUI;
    }

    static Object[] mav$listMatchingRecentComments(VCSCommentsCustomizer vCSCommentsCustomizer) {
        return vCSCommentsCustomizer.listMatchingRecentComments();
    }

    static boolean mav$isInsightEnabled(VCSCommentsCustomizer vCSCommentsCustomizer) {
        return vCSCommentsCustomizer.isInsightEnabled();
    }

    static JPopupMenu ra$_contextMenu(VCSCommentsCustomizer vCSCommentsCustomizer) {
        return vCSCommentsCustomizer._contextMenu;
    }

    static void mav$updateStateForReuseComments(VCSCommentsCustomizer vCSCommentsCustomizer) {
        vCSCommentsCustomizer.updateStateForReuseComments();
    }

    final class 1
    implements ActionListener {
        public final void actionPerformed(ActionEvent e) {
            VCSCommentsCustomizer.mav$updateStateForReuseComments(VCSCommentsCustomizer.this);
        }
    }

    final class 2
    implements PopupMenuListener {
        private final /* synthetic */ UseRecentCommentAction v$action;
        final /* synthetic */ VCSCommentsCustomizer this$0;

        public final void popupMenuCanceled(PopupMenuEvent e) {
        }

        public final void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public final void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.v$action.setEnabled(VCSCommentsCustomizer.mav$isInsightEnabled(this.this$0));
        }

        public 2(VCSCommentsCustomizer vCSCommentsCustomizer, UseRecentCommentAction useRecentCommentAction) {
            this.v$action = useRecentCommentAction;
            this.this$0 = vCSCommentsCustomizer;
        }
    }

    private class VCSCommentsCustomizerUI
    extends JPanel {
        private final JLabel _commentsLabel;
        private final CompletionTextArea _commentsArea;
        private final JCheckBox _reuseCommentsCheckBox;
        private final JScrollPane _commentsScrollPane;

        VCSCommentsCustomizerUI() {
            super(new BorderLayout());
            JPanel center = new JPanel(new BorderLayout(0, 5));
            this._commentsLabel = new JLabel();
            this._commentsArea = new CompletionTextArea();
            this._reuseCommentsCheckBox = new JCheckBox();
            this._commentsScrollPane = new JScrollPane((Component)this._commentsArea);
            center.add((Component)this._commentsLabel, "North");
            center.add((Component)this._commentsScrollPane, "Center");
            this._commentsScrollPane.setPreferredSize(new Dimension(0, 20 * VCSCommentsCustomizer.ra$_defaultRows(VCSCommentsCustomizer.this)));
            this.add((Component)center, "Center");
            this.add((Component)this._reuseCommentsCheckBox, "North");
            this._commentsArea.setLineWrap(true);
            this._commentsArea.setWrapStyleWord(true);
            this._commentsLabel.setLabelFor((Component)this._commentsArea);
            this._commentsLabel.setText(VCSArb.getString(110));
            this._commentsLabel.setDisplayedMnemonic(VCSArb.getMnemonic(170));
            this._reuseCommentsCheckBox.setText(VCSArb.getString(9));
            this._reuseCommentsCheckBox.setMnemonic(VCSArb.getMnemonic(138));
        }

        public JLabel getCommentsLabel() {
            return this._commentsLabel;
        }

        public CompletionTextArea getCommentsArea() {
            return this._commentsArea;
        }

        public JCheckBox getReuseCommentsCheckBox() {
            return this._reuseCommentsCheckBox;
        }

        static JScrollPane ra$_commentsScrollPane(VCSCommentsCustomizerUI vCSCommentsCustomizerUI) {
            return vCSCommentsCustomizerUI._commentsScrollPane;
        }
    }

    private class UseRecentCommentAction
    extends AbstractAction {
        UseRecentCommentAction() {
            super(VCSArb.getString(71), null);
            this.putValue("MnemonicKey", new Integer(VCSArb.getMnemonic(72)));
        }

        public void actionPerformed(ActionEvent e) {
            VCSCommentsCustomizer.ra$_commentsUI(VCSCommentsCustomizer.this).getCommentsArea().getPopupHandler().setInsightVisible(true);
        }
    }

    private class CommentsInsightProvider
    implements FieldInsightProvider {
        public ListCellRenderer getCellRenderer() {
            return new 1();
        }

        public boolean handlesInsight(Document doc, int pos) {
            return VCSCommentsCustomizer.mav$isInsightEnabled(VCSCommentsCustomizer.this);
        }

        public Object[] getInsightData(Document doc, int pos) {
            Object[] matches = VCSCommentsCustomizer.mav$listMatchingRecentComments(VCSCommentsCustomizer.this);
            return matches.length > 0 ? matches : null;
        }

        public void completeInsight(Document doc, int pos, Object insightObject) {
            try {
                doc.remove(0, doc.getLength());
                doc.insertString(0, insightObject.toString(), null);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }

        public boolean isAutoPopupChar(char c) {
            if (VCSCommentsCustomizer.ra$_commentsUI(VCSCommentsCustomizer.this).getCommentsArea().getText().equals("")) {
                return false;
            }
            Object[] matches = VCSCommentsCustomizer.mav$listMatchingRecentComments(VCSCommentsCustomizer.this);
            return matches.length > 0;
        }

        private CommentsInsightProvider() {
        }

        CommentsInsightProvider(1 var2_2) {
            this();
        }

        final class 1
        extends DefaultListCellRenderer {
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                value = value.toString().replaceAll("\\n", "/ ");
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        }
    }

    private class ContextMenuMouseListener
    extends MouseAdapter {
        private void doIt(MouseEvent me) {
            if (VCSCommentsCustomizer.ra$_commentsUI(VCSCommentsCustomizer.this).getCommentsArea().getPopupHandler().isInsightVisible()) {
                return;
            }
            if (!me.isPopupTrigger()) {
                return;
            }
            VCSCommentsCustomizer.ra$_contextMenu(VCSCommentsCustomizer.this).show((Component)VCSCommentsCustomizer.ra$_commentsUI(VCSCommentsCustomizer.this).getCommentsArea(), me.getX(), me.getY());
        }

        public void mouseReleased(MouseEvent me) {
            this.doIt(me);
        }

        public void mousePressed(MouseEvent me) {
            this.doIt(me);
        }

        public void mouseClicked(MouseEvent me) {
            this.doIt(me);
        }

        private ContextMenuMouseListener() {
        }

        ContextMenuMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

