/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSRegistry;
import oracle.jdeveloper.vcs.spi.VCSExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCSControlCache
extends Observable {
    private static final VCSControlCache _instance = new VCSControlCache();
    private final LinkedHashMap<String, String> _cache;
    private Collection<VCSExtension> _extensions;

    private void $init$() {
        this._cache = new 1();
    }

    private VCSControlCache() {
        this.$init$();
    }

    public static final VCSControlCache getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isControlled(URL url, String vcsId) {
        if (url == null) {
            return false;
        }
        LinkedHashMap<String, String> linkedHashMap = this._cache;
        synchronized (linkedHashMap) {
            String externalUrl = url.toExternalForm();
            if (this._cache.containsKey(externalUrl)) {
                boolean bl = this.nullSafeEquals(this._cache.get(externalUrl), vcsId);
                return bl;
            }
            for (VCSExtension currentExtension : this.getExtensions()) {
                if (!currentExtension.isControlled(url)) continue;
                this._cache.put(externalUrl, currentExtension.getId());
                boolean bl = this.nullSafeEquals(currentExtension.getId(), vcsId);
                return bl;
            }
            this._cache.put(externalUrl, null);
            boolean bl = vcsId == null;
            return bl;
        }
    }

    private boolean nullSafeEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireControlStateChanged(String vcsId) {
        LinkedHashMap<String, String> linkedHashMap = this._cache;
        synchronized (linkedHashMap) {
            this._cache.clear();
        }
        this.setChanged();
        this.notifyObservers(vcsId);
    }

    private Collection<VCSExtension> getExtensions() {
        if (this._extensions != null) {
            return this._extensions;
        }
        ArrayList<VCSExtension> extensions = new ArrayList<VCSExtension>();
        for (String id : VCSRegistry.keySet()) {
            VCS vcs = VCSRegistry.lookup((String)id);
            if (!(vcs instanceof VCSExtension)) continue;
            extensions.add((VCSExtension)vcs);
        }
        Collections.sort(extensions, new 2());
        this._extensions = extensions;
        return this._extensions;
    }

    final class 1
    extends LinkedHashMap {
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 5000;
        }
    }

    final class 2
    implements Comparator {
        public int compare(VCSExtension extension1, VCSExtension extension2) {
            return extension1.getControlPrecedence() - extension2.getControlPrecedence();
        }
    }
}

