/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSInvokableState;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;

public final class VCSDirectoryInvokableState
extends VCSInvokableState {
    public VCSDirectoryInvokableState(URL[] urls) {
        super(Arrays.asList(urls));
    }

    public void reset() {
        Map<URL, Collection<URL>> m = VCSFileSystemUtils.organizeURLsByParent(this._urls.toArray(new URL[0]));
        this._n = this._urls.size();
        this._batches = new ArrayList();
        for (URL parent : m.keySet()) {
            URL[] urls = m.get(parent).toArray(new URL[0]);
            URL[][] urlArgs = VCSProcessUtils.splitCommandArgumentURLs(urls, this._maxBatchArguments, false);
            this._batches.addAll(Arrays.asList(urlArgs));
        }
        this._batchCount = this._batches.size();
    }

    protected String getProgressNote(URL parent) {
        if (this.getBatchCount() <= 1) {
            return VCSArb.format(5, URLFileSystem.getFileName((URL)parent));
        }
        Object[] params = new Object[]{URLFileSystem.getFileName((URL)parent), String.valueOf(this.getBatchCount() - (this.getBatchesRemainingCount() - 1)), String.valueOf(this.getBatchCount())};
        return VCSArb.format(86, params);
    }
}

