/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.util.ArrayList;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;

public class VCSEventBus {
    private static ArrayList _components = new ArrayList();
    private static VCSEBComponent[] _copyComponents;

    private VCSEventBus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToBus(VCSEBComponent component) {
        ArrayList arrayList = _components;
        synchronized (arrayList) {
            _components.add(component);
            _copyComponents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromBus(VCSEBComponent component) {
        ArrayList arrayList = _components;
        synchronized (arrayList) {
            _components.remove(component);
            _copyComponents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VCSEBComponent[] getComponents() {
        ArrayList arrayList = _components;
        synchronized (arrayList) {
            if (_copyComponents == null) {
                _copyComponents = _components.toArray(new VCSEBComponent[_components.size()]);
            }
            VCSEBComponent[] vCSEBComponentArray = _copyComponents;
            return vCSEBComponentArray;
        }
    }

    public static void send(VCSEBMessage message) {
        VCSEBComponent[] components = VCSEventBus.getComponents();
        int i = 0;
        while (i < components.length) {
            try {
                components[i].handleMessage(message);
            }
            catch (Throwable t) {
                Assert.printStackTrace((Throwable)t);
            }
            ++i;
        }
    }
}

