/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.Arrays;
import javax.ide.extension.Extension;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSRegistry;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSExtensionInformation;
import oracle.jdeveloper.vcs.spi.VCSHistoryProvider;
import oracle.jdeveloper.vcs.spi.VCSPropertyDescriptor;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusConstants;

public abstract class VCSExtension
implements Addin,
VCS,
ShutdownHook {
    private VCSExceptionHandler _exceptionHandler;
    private String _id;

    public String getId() {
        if (this._id == null) {
            Extension extension = AddinManager.getAddinManager().getExtensionForAddin((Addin)this);
            this._id = extension != null ? extension.getID() : this.getClass().getName();
        }
        return this._id;
    }

    public abstract boolean isControlled(URL var1);

    public int getControlPrecedence() {
        return 2;
    }

    public final VCSStatus[] getStatus(URL[] urls) throws Exception {
        VCSStatusCache statusCache = this.getStatusCache();
        if (statusCache != null) {
            return statusCache.get(urls);
        }
        Object[] statuses = new VCSStatus[urls.length];
        Arrays.fill(statuses, VCSStatusConstants.STATUS_UNRECOGNIZED);
        return statuses;
    }

    public VCSExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new VCSExceptionHandler();
        }
        return this._exceptionHandler;
    }

    public VCSStatusCache getStatusCache() {
        return null;
    }

    public URLFilter getURLFilter() {
        return null;
    }

    public VCSExtensionInformation getInformation() {
        String className = this.getClass().getName();
        int i = className.lastIndexOf(46);
        if (i >= 0 && i < className.length() - 1) {
            className = className.substring(i + 1);
        }
        return new VCSExtensionInformation(className);
    }

    public VCSHistoryProvider getHistoryProvider() {
        return null;
    }

    public VCSPropertyDescriptor getPropertyDescriptor() {
        return null;
    }

    public boolean setReadWrite(URL url) throws Exception {
        return URLFileSystem.isReadOnly((URL)url) ^ true;
    }

    public boolean setReadWrite(URL[] urls) throws Exception {
        URL[] uRLArray = urls;
        int n = 0;
        while (n < uRLArray.length) {
            URL url = uRLArray[n];
            if (URLFileSystem.isReadOnly((URL)url)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getCheckOutCommand() {
        return null;
    }

    public String getVersionName(URL url) {
        return null;
    }

    public boolean isConflictsStatus(VCSStatus status) {
        return false;
    }

    public boolean isConflictsStatus(URL url) {
        try {
            VCSStatus status = this.getStatus(new URL[]{url})[0];
            boolean bl = status != null && this.isConflictsStatus(status);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean canActivate() {
        return true;
    }

    public void activate() {
    }

    @Deprecated
    public final boolean canDeactivate() {
        return true;
    }

    @Deprecated
    public final void deactivate() {
    }

    public void initialize() {
        VCSRegistry.register((VCS)this);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

