/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.util.VCSIdeCommandProcessor;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNodeCommands;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VCSImportBackupHelper {
    private final URL _directoryUrl;

    public VCSImportBackupHelper(URL directoryUrl) {
        this._directoryUrl = directoryUrl;
    }

    public URL backupDirectoryFiles() throws Exception {
        return this.backupDirectoryFiles(null);
    }

    /*
     * Exception decompiling
     */
    public URL backupDirectoryFiles(VCSCancellable cancellable) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 13[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addNodesForURL(URL url, Collection<Node> nodes) {
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            nodes.addAll(Arrays.asList(VCSModelUtils.findCachedNodes(VCSURLFilters.createBaseURLContentsFilter(new URL[]{url}))));
        } else {
            Node node = NodeFactory.find((URL)url);
            if (node != null) {
                nodes.add(node);
            }
        }
    }

    private URL findRenameFailureURL(URL url) {
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            URL[] uRLArray = URLFileSystem.list((URL)url);
            int n = 0;
            while (n < uRLArray.length) {
                URL listUrl = uRLArray[n];
                URL renameFailureUrl = this.findRenameFailureURL(listUrl);
                if (renameFailureUrl != null) {
                    return renameFailureUrl;
                }
                ++n;
            }
        }
        String fileName = URLFileSystem.getFileName((URL)url);
        URL renamedUrl = URLFactory.newURL((URL)URLFileSystem.getParent((URL)url), (String)("." + fileName));
        if (!URLFileSystem.canWrite((URL)url) || !URLFileSystem.renameTo((URL)url, (URL)renamedUrl)) {
            return url;
        }
        URLFileSystem.renameTo((URL)renamedUrl, (URL)url);
        return null;
    }

    protected void removeNodes(Node[] nodes) throws Exception {
        Context context = new Context();
        context.setSelection((Element[])nodes);
        VCSIdeCommandProcessor.invokeAndWait(VCSNodeCommands.createRemoveNodeOnlyCommand(context));
    }

    protected void closeNodes(Node[] nodes) throws Exception {
        Context context = new Context();
        context.setSelection((Element[])nodes);
        VCSIdeCommandProcessor.invokeAndWait(VCSNodeCommands.createCloseNodeOnlyCommand(context));
    }

    protected URL generateBackupDirectoryURL(URL directoryUrl) {
        String filename = URLFileSystem.getFileName((URL)directoryUrl) + ".backup";
        filename = filename.replace('/', '-');
        filename = filename.replace('\\', '-');
        directoryUrl = URLFileSystem.getParent((URL)directoryUrl);
        URL backupDirectoryUrl = URLFactory.newDirURL((URL)directoryUrl, (String)filename);
        int i = 2;
        while (URLFileSystem.exists((URL)backupDirectoryUrl)) {
            backupDirectoryUrl = URLFactory.newDirURL((URL)directoryUrl, (String)(filename + i));
            ++i;
        }
        return backupDirectoryUrl;
    }

    protected abstract void createBackupDirectory(URL var1) throws Exception;

    protected abstract boolean confirmRetryBackupAfterFailure(URL var1);

    protected void preprocessBackup(URL url) {
    }

    protected void postprocessBackup(URL url) {
    }
}

