/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VCSInvokableState {
    protected final Collection<URL> _urls;
    protected Collection _batches;
    protected int _maxBatchArguments;
    protected int _n;
    protected final Collection _completedUrls;
    protected final Collection _processedUrls;
    protected int _batchCount;

    private void $init$() {
        this._maxBatchArguments = Integer.MAX_VALUE;
        this._completedUrls = new LinkedHashSet();
        this._processedUrls = new LinkedHashSet();
    }

    public VCSInvokableState(Collection<URL> urls) {
        this.$init$();
        this._urls = urls;
    }

    public URL[] getURLs() {
        return this._urls.toArray(new URL[0]);
    }

    void initialize(int maxBatchArguments) {
        this._maxBatchArguments = maxBatchArguments;
        this.reset();
    }

    int getN() {
        return this._n;
    }

    int getBatchCount() {
        return this._batchCount;
    }

    int getBatchesRemainingCount() {
        return this._batches.size();
    }

    URL[] nextURLs() {
        Iterator itr = this._batches.iterator();
        if (itr.hasNext()) {
            return (URL[])itr.next();
        }
        return null;
    }

    void notifyProcessed(URL[] urls) {
        this._processedUrls.addAll(Arrays.asList(urls));
    }

    void notifyCompleted(URL[] urls) {
        this._completedUrls.addAll(Arrays.asList(urls));
        this._batches.remove(urls);
    }

    public boolean hasProcessed() {
        return this._processedUrls.size() > 0;
    }

    public boolean hasCompleted() {
        return this._completedUrls.containsAll(this._urls);
    }

    public Collection getCompletedURLs() {
        return Collections.unmodifiableCollection(this._completedUrls);
    }

    public Collection getProcessedURLs() {
        return Collections.unmodifiableCollection(this._processedUrls);
    }

    public abstract void reset();

    protected abstract String getProgressNote(URL var1);
}

