/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import oracle.ide.composite.CompositeFileElementEvent;
import oracle.ide.composite.CompositeFileElementListener;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public class VCSNodeOverlayTracker
extends IconOverlayTracker
implements Observer,
VCSEBComponent {
    private static final String VCS_OVERLAY_TYPE_ID = "vcsOverlayType";
    private static IconOverlay CONFUSED_COMPOSITE_OVERLAY;
    private final VCSOverlayItemProducer _overlayItemProducer;
    private final URLFilter _filter;
    private final String _vcsId;
    private Observer _controlCacheObserver;
    private final CompositeFileElementListener _compositeListener;

    private static final IconOverlay getConfusedCompositeOverlay() {
        if (CONFUSED_COMPOSITE_OVERLAY == null) {
            CONFUSED_COMPOSITE_OVERLAY = new IconOverlay(VCSArb.getInstance().getIconImpl(172), null, VCSArb.getString(31));
        }
        return CONFUSED_COMPOSITE_OVERLAY;
    }

    private void $init$() {
        this._compositeListener = new 1();
    }

    public VCSNodeOverlayTracker(int batchSize, VCSOverlayItemProducer overlayItemProducer, URLFilter filter, String vcsId) {
        super("vcsOverlayType." + vcsId, IconOverlayCache.getInstance(), batchSize);
        this.$init$();
        this._overlayItemProducer = overlayItemProducer;
        this._filter = filter;
        if (this._overlayItemProducer != null) {
            this._overlayItemProducer.getObservable().addObserver(this);
        }
        CompositeFileElementRegistry.addCompositeListener((CompositeFileElementListener)this._compositeListener);
        VCSEventBus.addToBus(this);
        this._vcsId = vcsId;
    }

    public void update(Observable o, Object arg) {
        URL[] urls = (URL[])arg;
        Element[] elements = this.getValidElements();
        List<URL> urls0 = Arrays.asList(urls);
        int i = 0;
        while (i < elements.length) {
            URL url = VCSModelUtils.getLocatableURL(elements[i]);
            if (url != null) {
                url = URLFactory.replaceRefPart((URL)url, null);
                if (urls0.contains(url = URLFactory.replaceQueryPart((URL)url, null))) {
                    this.validateOverlay(elements[i]);
                }
            }
            ++i;
        }
        Element[] compositeElements = CompositeFileElementRegistry.getCachedCompositeElements((URL[])((URL[])arg));
        int i2 = 0;
        while (i2 < compositeElements.length) {
            this.validateOverlay(compositeElements[i2]);
            ++i2;
        }
        this.repaintOverlays();
    }

    public void handleMessage(VCSEBMessage message) {
        if (!(message instanceof VCSNodeUpdate)) {
            return;
        }
        VCSNodeUpdate nodeUpdate = (VCSNodeUpdate)message;
        if (nodeUpdate.getWhat() == VCSNodeUpdate.RENAMED) {
            this.validateOverlay((Element)nodeUpdate.getNode());
            this.repaintOverlays();
            return;
        }
    }

    protected void startTracking() {
        if (this._controlCacheObserver == null) {
            this._controlCacheObserver = new 2();
        }
        VCSControlCache.getInstance().addObserver(this._controlCacheObserver);
        super.startTracking();
    }

    public void stopTracking() {
        super.stopTracking();
        if (this._overlayItemProducer != null) {
            this._overlayItemProducer.getObservable().deleteObserver(this);
        }
        CompositeFileElementRegistry.removeCompositeListener((CompositeFileElementListener)this._compositeListener);
        VCSEventBus.removeFromBus(this);
        VCSControlCache.getInstance().deleteObserver(this._controlCacheObserver);
    }

    protected boolean isControlled(Element element) {
        if (CompositeFileElementRegistry.isCompositeElement((Element)element)) {
            return true;
        }
        return this.isControlled(VCSModelUtils.getLocatableURL(element));
    }

    protected IconOverlay[] getOverlays(Element[] elements) {
        try {
            IconOverlay[] overlays = new IconOverlay[elements.length];
            BitSet compositeElementBits = new BitSet(elements.length);
            ArrayList<Element> singularElements = new ArrayList<Element>();
            int i = 0;
            while (i < elements.length) {
                if (CompositeFileElementRegistry.isCompositeElement((Element)elements[i])) {
                    overlays[i] = this.getCompositeElementOverlay(elements[i]);
                    compositeElementBits.set(i);
                } else {
                    singularElements.add(elements[i]);
                }
                ++i;
            }
            URL[] urls = VCSModelUtils.convertNodesToURLs(singularElements);
            VCSOverlayItem[] overlayItems = new VCSOverlayItem[urls.length];
            BitSet controlledUrlBits = new BitSet(urls.length);
            int i2 = 0;
            while (i2 < urls.length) {
                if (overlayItems[i2] == null && VCSControlCache.getInstance().isControlled(urls[i2], this._vcsId)) {
                    controlledUrlBits.set(i2);
                }
                ++i2;
            }
            if (!controlledUrlBits.isEmpty()) {
                ArrayList<URL> controlledUrls = new ArrayList<URL>();
                int i3 = 0;
                while (i3 < urls.length) {
                    if (controlledUrlBits.get(i3)) {
                        controlledUrls.add(urls[i3]);
                    }
                    ++i3;
                }
                VCSOverlayItem[] controlledOverlayItems = this._overlayItemProducer.getOverlayItems(controlledUrls.toArray(new URL[0]));
                int i4 = 0;
                int j = 0;
                while (i4 < urls.length) {
                    if (controlledUrlBits.get(i4)) {
                        overlayItems[i4] = controlledOverlayItems[j++];
                    }
                    ++i4;
                }
            }
            int i5 = 0;
            int j = 0;
            while (i5 < elements.length) {
                if (!compositeElementBits.get(i5)) {
                    overlays[i5] = overlayItems[j] != null ? overlayItems[j].getOverlay() : null;
                    ++j;
                }
                ++i5;
            }
            IconOverlay[] iconOverlayArray = overlays;
            return iconOverlayArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            IconOverlay[] iconOverlayArray = null;
            return iconOverlayArray;
        }
    }

    protected IconOverlay getCompositeElementOverlay(URL[] urls) throws Exception {
        VCSOverlayItem[] overlayItems = this._overlayItemProducer.getOverlayItems(urls);
        VCSOverlayItem overlayItem0 = overlayItems[0];
        int i = 1;
        while (i < overlayItems.length) {
            if (!overlayItems[i].getStatus().equals(overlayItem0.getStatus())) {
                return VCSNodeOverlayTracker.getConfusedCompositeOverlay();
            }
            ++i;
        }
        return overlayItem0.getOverlay();
    }

    private boolean isControlled(URL url) {
        return url != null && this._filter.accept(url);
    }

    private IconOverlay getCompositeElementOverlay(Element element) throws Exception {
        URL[] compositeFileUrls = CompositeFileElementRegistry.getCompositeFileURLs((Element)element);
        if (compositeFileUrls == null) {
            return null;
        }
        if (compositeFileUrls.length <= 0) {
            URL url = VCSModelUtils.getLocatableURL(element);
            if (url == null) {
                return null;
            }
            compositeFileUrls = new URL[]{url};
        }
        ArrayList<URL> controlledUrls = new ArrayList<URL>();
        int i = 0;
        while (i < compositeFileUrls.length) {
            if (this.isControlled(compositeFileUrls[i]) && VCSControlCache.getInstance().isControlled(compositeFileUrls[i], this._vcsId) && (!URLFileSystem.isDirectoryPath((URL)compositeFileUrls[i]) || URLFileSystem.exists((URL)compositeFileUrls[i]))) {
                controlledUrls.add(compositeFileUrls[i]);
            }
            ++i;
        }
        if (controlledUrls.size() <= 0) {
            return null;
        }
        return this.getCompositeElementOverlay(controlledUrls.toArray(new URL[0]));
    }

    static String ra$_vcsId(VCSNodeOverlayTracker vCSNodeOverlayTracker) {
        return vCSNodeOverlayTracker._vcsId;
    }

    final class 1
    implements CompositeFileElementListener {
        public void compositeStateChanged(CompositeFileElementEvent cfee) {
            Element[] compositeElements = cfee.getCompositeElements();
            int i = 0;
            while (i < compositeElements.length) {
                VCSNodeOverlayTracker.this.validateOverlay(compositeElements[i]);
                ++i;
            }
            VCSNodeOverlayTracker.this.repaintOverlays();
        }
    }

    final class 2
    implements Observer {
        public void update(Observable o, Object arg) {
            if (arg != null && !arg.equals(VCSNodeOverlayTracker.ra$_vcsId(VCSNodeOverlayTracker.this))) {
                return;
            }
            VCSNodeOverlayTracker.this.validateOverlays();
            VCSNodeOverlayTracker.this.repaintOverlays();
        }
    }
}

