/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.Observable;
import oracle.ide.explorer.IconOverlay;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;

public class VCSOverlayItemProducer {
    private final VCSStatusCache _statusCache;

    public VCSOverlayItemProducer(VCSStatusCache statusCache) {
        this._statusCache = statusCache;
    }

    public VCSStatusCache getStatusCache() {
        return this._statusCache;
    }

    public Observable getObservable() {
        return this._statusCache;
    }

    public VCSOverlayItem[] getOverlayItems(URL[] urls) throws Exception {
        VCSStatus[] statuses = this._statusCache.get(urls);
        IconOverlay[] iconOverlays = this.produceOverlays(urls, statuses);
        VCSOverlayItem[] overlayItems = new VCSOverlayItem[urls.length];
        int i = 0;
        while (i < urls.length) {
            overlayItems[i] = new VCSOverlayItem(statuses[i], iconOverlays[i]);
            ++i;
        }
        return overlayItems;
    }

    protected IconOverlay[] produceOverlays(URL[] urls, VCSStatus[] statuses) throws Exception {
        IconOverlay[] iconOverlays = new IconOverlay[urls.length];
        int i = 0;
        while (i < urls.length) {
            iconOverlays[i] = this.produceOverlay(urls[i], statuses[i]);
            ++i;
        }
        return iconOverlays;
    }

    protected IconOverlay produceOverlay(URL url, VCSStatus status) throws Exception {
        return status.getOverlay();
    }
}

