/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

public abstract class VCSURLBasedCache
extends Observable {
    protected final Map<URL, Object> _cache;

    private void $init$() {
        this._cache = new HashMap<URL, Object>();
    }

    public Object getValue(URL url) throws Exception {
        return this.getValues(new URL[]{url})[0];
    }

    public Object[] getValues(URL[] urls) throws Exception {
        Object[] values = this.getCachedValues(urls);
        BitSet bits = new BitSet(urls.length);
        int i = 0;
        while (i < urls.length) {
            bits.set(i, values[i] == null);
            ++i;
        }
        if (bits.isEmpty()) {
            return values;
        }
        int n = bits.cardinality();
        URL[] urls2 = new URL[n];
        Object[] values2 = this.createValueArray(n);
        int i2 = 0;
        int j = 0;
        while (i2 < bits.length()) {
            if (bits.get(i2)) {
                urls2[j++] = urls[i2];
            }
            ++i2;
        }
        this.getValuesImpl(urls2, values2);
        int i3 = 0;
        int j2 = 0;
        while (i3 < bits.length()) {
            if (bits.get(i3)) {
                values[i3] = values2[j2++];
            }
            ++i3;
        }
        this.populateCachedValues(urls2, values2);
        return values;
    }

    public synchronized void clearValues() {
        this.clearValues(VCSURLFilters.createNullFilter());
    }

    public synchronized void clearValue(URL url) {
        this.clearValues(VCSURLFilters.createSpecificURLFilter(new URL[]{url}));
    }

    public synchronized void clearValues(URL[] urls) {
        this.clearValues(VCSURLFilters.createSpecificURLFilter(urls));
    }

    public synchronized void clearValues(URLFilter filter) {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator<URL> itr = this._cache.keySet().iterator();
        while (itr.hasNext()) {
            URL url = itr.next();
            if (!filter.accept(url)) continue;
            itr.remove();
            urls.add(url);
        }
        if (urls.size() > 0) {
            this.fireStatusDirty(urls);
        }
    }

    public synchronized URL[] searchValues(URLFilter filter) {
        HashSet<URL> urls = new HashSet<URL>(this._cache.keySet());
        Iterator itr = urls.iterator();
        while (itr.hasNext()) {
            if (filter.accept((URL)itr.next())) continue;
            itr.remove();
        }
        return urls.toArray(new URL[0]);
    }

    public Object[] getValuesImpl(URL[] urls) throws Exception {
        Object[] values = this.createValueArray(urls.length);
        this.getValuesImpl(urls, values);
        return values;
    }

    protected abstract void getValuesImpl(URL[] var1, Object[] var2) throws Exception;

    protected Object[] createValueArray(int length) {
        return new Object[length];
    }

    protected Object getValueInternal(URL url) {
        String urlExternal = url.toExternalForm();
        for (Map.Entry<URL, Object> entry : this._cache.entrySet()) {
            if (!urlExternal.equals(entry.getKey().toExternalForm())) continue;
            return entry.getValue();
        }
        return null;
    }

    private synchronized Object[] getCachedValues(URL[] urls) {
        urls = VCSFileSystemUtils.removeRefAndQueryParts(urls);
        Object[] values = this.createValueArray(urls.length);
        int i = 0;
        while (i < urls.length) {
            values[i] = this.getValueInternal(urls[i]);
            ++i;
        }
        return values;
    }

    private synchronized void populateCachedValues(URL[] urls, Object[] values) {
        urls = VCSFileSystemUtils.removeRefAndQueryParts(urls);
        int i = 0;
        while (i < urls.length) {
            this._cache.put(urls[i], values[i]);
            ++i;
        }
    }

    private void fireStatusDirty(Collection urls) {
        EventQueue.invokeLater(new 1(this, urls));
    }

    public VCSURLBasedCache() {
        this.$init$();
    }

    static void mav$setChanged(VCSURLBasedCache vCSURLBasedCache) {
        vCSURLBasedCache.setChanged();
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Collection v$urls;
        final /* synthetic */ VCSURLBasedCache this$0;

        public final void run() {
            VCSURLBasedCache.mav$setChanged(this.this$0);
            this.this$0.notifyObservers(this.v$urls.toArray(new URL[0]));
        }

        public 1(VCSURLBasedCache vCSURLBasedCache, Collection collection) {
            this.v$urls = collection;
            this.this$0 = vCSURLBasedCache;
        }
    }
}

