/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public class VCSURLFileSystemHelper
extends URLFileSystemHelperDecorator {
    private boolean _enabled;
    private final VCSExtension _extension;
    public static final String DEFAULT_AUTO_CHECK_OUT_COMMENTS = VCSArb.format(24, Ide.getProgramName());

    private void $init$() {
        this._enabled = true;
    }

    public VCSURLFileSystemHelper(URLFileSystemHelper helper, VCSExtension extension) {
        super(helper);
        this.$init$();
        this._extension = extension;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean canCreate(URL url) {
        if (!this._enabled) {
            return this.getHelper().canCreate(url);
        }
        return this.canCreateImpl(url);
    }

    public boolean canDelete(URL url) {
        if (!this._enabled) {
            return this.getHelper().canDelete(url);
        }
        if (!this.isOperable(url)) {
            return this.getHelper().canDelete(url);
        }
        if (VCSFileSystemUtils.isNonEditable(url)) {
            return this.getHelper().canDelete(url);
        }
        return this.canDeleteImpl(url);
    }

    public boolean isValid(URL url) {
        if (!this._enabled) {
            return this.getHelper().isValid(url);
        }
        return this.isValidImpl(url);
    }

    public void delete(URL url) throws IOException {
        if (!this._enabled) {
            this.getHelper().delete(url);
            return;
        }
        if (!this.exists(url)) {
            this.getHelper().delete(url);
            return;
        }
        if (!this.isOperable(url)) {
            this.getHelper().delete(url);
            return;
        }
        if (VCSFileSystemUtils.isNonEditable(url)) {
            this.getHelper().delete(url);
            return;
        }
        if (!this.deleteImpl(url)) {
            throw new IOException("Deletion failed in VCS");
        }
    }

    public void rename(URL oldUrl, URL newUrl) throws IOException {
        if (!this._enabled) {
            this.getHelper().rename(oldUrl, newUrl);
            return;
        }
        if (!this.exists(oldUrl)) {
            this.getHelper().rename(oldUrl, newUrl);
            return;
        }
        if (!this.isOperable(oldUrl)) {
            this.getHelper().rename(oldUrl, newUrl);
            return;
        }
        if (VCSFileSystemUtils.isNonEditable(oldUrl)) {
            this.getHelper().rename(oldUrl, newUrl);
            return;
        }
        if (!this.renameToImpl(oldUrl, newUrl)) {
            throw new IOException("Rename failed in VCS");
        }
    }

    public boolean setReadOnly(URL url, boolean readOnly) {
        if (!this._enabled || readOnly) {
            return this.getHelper().setReadOnly(url, readOnly);
        }
        if (!this.exists(url)) {
            return this.getHelper().setReadOnly(url, readOnly);
        }
        if (!this.isAutoCheckoutsSet(url)) {
            return this.getHelper().setReadOnly(url, readOnly);
        }
        if (!this.isReadOnly(url)) {
            return true;
        }
        if (!this.isOperable(url)) {
            return this.getHelper().setReadOnly(url, readOnly);
        }
        if (VCSFileSystemUtils.isNonEditable(url)) {
            return this.getHelper().setReadOnly(url, readOnly);
        }
        return this.setReadWrite(url);
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        this.setReadOnly(url, false);
        return super.openOutputStream(url);
    }

    protected boolean deleteImpl(URL url) {
        try {
            this.getHelper().delete(url);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            boolean bl = false;
            return bl;
        }
    }

    protected boolean renameToImpl(URL oldUrl, URL newUrl) {
        try {
            this.getHelper().rename(oldUrl, newUrl);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
            boolean bl = false;
            return bl;
        }
    }

    protected boolean canCreateImpl(URL url) {
        return this.getHelper().canCreate(url);
    }

    protected boolean canDeleteImpl(URL url) {
        return true;
    }

    protected boolean isValidImpl(URL url) {
        return this.getHelper().isValid(url);
    }

    protected boolean setReadWrite(URL url) {
        if (this._extension == null) {
            return this.getHelper().setReadOnly(url, false);
        }
        try {
            boolean bl = this._extension.setReadWrite(url);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    protected boolean isOperable(URL url) {
        VCSExtension extension = VCSExtensionUtils.getActiveExtension(url);
        return extension != null && extension.getId().equals(this._extension.getId()) && VCSManager.getVCSManager().isVersioned(url);
    }

    protected boolean isAutoCheckoutsSet(URL url) {
        return VCSManager.getVCSManager().isAutoCheckOutEnabled(url);
    }

    protected void invokeAndPushEventQueue(Runnable r) {
        Window currentWindow;
        PopEventQueue popEventQueue = null;
        if (EventQueue.isDispatchThread() && !(EventQueue.getCurrentEvent() instanceof KeyEvent)) {
            popEventQueue = new PopEventQueue(null);
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(popEventQueue);
        }
        WaitCursor waitCursor = (currentWindow = VCSWindowUtils.getCurrentWindow()) == IdeUtil.getMainWindow() ? Ide.getWaitCursor() : new WaitCursor((Component)currentWindow);
        waitCursor.show();
        try {
            r.run();
        }
        finally {
            PopEventQueue popEventQueue0 = popEventQueue;
            if (popEventQueue != null) {
                EventQueue.invokeLater(new 1(this, popEventQueue0));
            }
            waitCursor.hide();
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ PopEventQueue v$popEventQueue0;
        final /* synthetic */ VCSURLFileSystemHelper this$0;

        public void run() {
            this.v$popEventQueue0.pop();
        }

        public 1(VCSURLFileSystemHelper vCSURLFileSystemHelper, PopEventQueue popEventQueue) {
            this.v$popEventQueue0 = popEventQueue;
            this.this$0 = vCSURLFileSystemHelper;
        }
    }

    private class PopEventQueue
    extends EventQueue {
        public void pop() {
            super.pop();
        }

        private PopEventQueue() {
        }

        PopEventQueue(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

