/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public abstract class VCSWaitRunnable
implements Runnable {
    private final VCSExceptionHandler _exceptionHandler;
    private VCSOptionsCustomizer _optionsCustomizer;
    private IndeterminateProgressMonitor _progressMonitor;
    private Exception _exception;

    public VCSWaitRunnable() {
        this(null);
    }

    public VCSWaitRunnable(VCSExceptionHandler exceptionHandler) {
        this(exceptionHandler, null);
    }

    public VCSWaitRunnable(VCSExceptionHandler exceptionHandler, VCSOptionsCustomizer optionsCustomizer) {
        this._exceptionHandler = exceptionHandler;
        this.setOptionsCustomizer(optionsCustomizer);
    }

    public void setIndeterminateProgressMonitor(IndeterminateProgressMonitor progressMonitor) {
        this._progressMonitor = progressMonitor;
    }

    public IndeterminateProgressMonitor getIndeterminateProgressMonitor() {
        return this._progressMonitor;
    }

    public void setOptionsCustomizer(VCSOptionsCustomizer optionsCustomizer) {
        this._optionsCustomizer = optionsCustomizer;
    }

    public VCSOptionsCustomizer setOptionsCustomizer() {
        return this._optionsCustomizer;
    }

    public Exception getException() {
        return this._exception;
    }

    public void run() {
        Window currentWindow = VCSWindowUtils.getCurrentWindow();
        WaitCursor waitCursor = currentWindow == IdeUtil.getMainWindow() ? Ide.getWaitCursor() : new WaitCursor((Component)currentWindow);
        waitCursor.show();
        this._exception = null;
        try {
            try {
                if (this._optionsCustomizer != null) {
                    this._optionsCustomizer.validateOptions();
                }
                if (this._progressMonitor != null) {
                    this._progressMonitor.start();
                }
                this.runImpl();
            }
            catch (Exception e) {
                this._exception = e;
            }
        }
        finally {
            if (this._progressMonitor != null) {
                this._progressMonitor.close();
            }
            EventQueue.invokeLater(new 1(this, waitCursor));
        }
    }

    protected abstract void runImpl() throws Exception;

    protected void runPostOperationAWT() throws Exception {
    }

    protected final Map getOptions() {
        return this._optionsCustomizer != null ? this._optionsCustomizer.getOptions() : null;
    }

    static Exception ra$_exception(VCSWaitRunnable vCSWaitRunnable) {
        return vCSWaitRunnable._exception;
    }

    static VCSExceptionHandler ra$_exceptionHandler(VCSWaitRunnable vCSWaitRunnable) {
        return vCSWaitRunnable._exceptionHandler;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ WaitCursor v$waitCursor;
        final /* synthetic */ VCSWaitRunnable this$0;

        public final void run() {
            Exception exception = VCSWaitRunnable.ra$_exception(this.this$0);
            if (exception == null) {
                try {
                    this.this$0.runPostOperationAWT();
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            this.v$waitCursor.hide();
            if (exception == null) {
                return;
            }
            if (VCSWaitRunnable.ra$_exceptionHandler(this.this$0) != null) {
                VCSWaitRunnable.ra$_exceptionHandler(this.this$0).handleException(exception);
            } else {
                exception.printStackTrace();
            }
        }

        public 1(VCSWaitRunnable vCSWaitRunnable, WaitCursor waitCursor) {
            this.v$waitCursor = waitCursor;
            this.this$0 = vCSWaitRunnable;
        }
    }
}

