/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public class VCSBufferUtils {
    private static final Collection _filters = new ArrayList();

    private VCSBufferUtils() {
    }

    public static final synchronized void registerTrackingFilter(URLFilter filter) {
        _filters.add(filter);
    }

    public static final synchronized void deregisterTrackingFilter(URLFilter filter) {
        _filters.remove(filter);
    }

    public static Map storeAllTimestamps() {
        HashMap timestampMap = new HashMap();
        NodeUtil.storeAllTimestamps(timestampMap, (NodeUtil.NodeFilter)new OpenNodeFilter(null));
        return timestampMap;
    }

    public static Map storeTimestamps(Collection nodes) {
        HashMap timestampMap = new HashMap();
        Node[] nodeArray = (Node[])VCSCollectionUtils.toArrayType(nodes, Node.class);
        NodeUtil.storeTimestamps(timestampMap, Arrays.asList(nodeArray), (NodeUtil.NodeFilter)new OpenNodeFilter(null));
        return timestampMap;
    }

    public static void reloadBuffers(Map timestampMap) {
        if (timestampMap != null) {
            NodeUtil.reloadBuffers(timestampMap.keySet(), (Map)timestampMap, (int)3, (boolean)false);
        }
        VCSBufferUtils.fileTimestampsCheck(timestampMap);
    }

    public static void reloadBuffer(URL url) {
        Node node = NodeFactory.find((URL)url);
        if (node == null) {
            return;
        }
        if (node != null) {
            NodeUtil.reloadBuffers(Collections.singleton(node), null, (int)3, (boolean)false);
        }
        VCSBufferUtils.fileTimestampsCheck(Collections.singletonMap(node, new Long(Long.MIN_VALUE)));
    }

    public static void reloadBuffer(URL[] urls) {
        HashMap<Node, Long> nodes = new HashMap<Node, Long>();
        Long time = new Long(Long.MIN_VALUE);
        int u = 0;
        while (u < urls.length) {
            Node node = NodeFactory.find((URL)urls[u]);
            if (node != null) {
                nodes.put(node, time);
            }
            ++u;
        }
        if (nodes.size() > 0) {
            NodeUtil.reloadBuffers(nodes.keySet(), null, (int)3, (boolean)false);
            VCSBufferUtils.fileTimestampsCheck(nodes);
        }
    }

    private static final void fileTimestampsCheck(Map timestampMap) {
        ArrayList<Node> changedTimestampNodes = new ArrayList<Node>();
        for (Map.Entry entry : timestampMap.entrySet()) {
            Node node = (Node)entry.getKey();
            Long storedTimestamp = (Long)entry.getValue();
            if (node == null || URLFileSystem.lastModified((URL)node.getURL()) == storedTimestamp) continue;
            changedTimestampNodes.add(node);
        }
        if (changedTimestampNodes.isEmpty()) {
            return;
        }
        VCSFileEventSender.fireFilesModified(VCSModelUtils.convertNodesToURLs(changedTimestampNodes));
    }

    static Collection ra$_filters() {
        return _filters;
    }

    private static class OpenNodeFilter
    implements NodeUtil.NodeFilter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean accept(Node node) {
            if (node != null && (node.isOpen() || node.isLoaded())) {
                return true;
            }
            URL url = node.getURL();
            if (url == null) {
                return false;
            }
            Class<VCSBufferUtils> clazz = VCSBufferUtils.class;
            synchronized (VCSBufferUtils.class) {
                Iterator itr = VCSBufferUtils.ra$_filters().iterator();
                while (itr.hasNext()) {
                    if (!((URLFilter)itr.next()).accept(url)) continue;
                    boolean bl = true;
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return bl;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return false;
            }
        }

        private OpenNodeFilter() {
        }

        OpenNodeFilter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

