/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.SelectFilesConfiguration;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNodeCommands;
import oracle.jdeveloper.vcs.util.VCSStatusFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public class VCSCommandUtils {
    private static final String SKIP_SAVE_FILES_PERSISTENCE_KEY = "VCS.SaveFilesConfirm";

    private VCSCommandUtils() {
    }

    public static final Collection getFilteredSelection(Locatable[] locatables, VCSStatusCache cache, VCSStatus[] statuses) throws Exception {
        VCSStatus[] statuses2 = (VCSStatus[])VCSCollectionUtils.toArrayType(Arrays.asList(statuses), VCSStatus.class);
        return VCSCommandUtils.getFilteredSelection(locatables, cache, VCSStatusFilters.createStatusFilter(statuses2));
    }

    public static final Collection getFilteredSelection(Locatable[] locatables, VCSStatusCache cache, VCSStatusFilter filter) throws Exception {
        if (locatables.length == 0 || cache == null || filter == null) {
            return new ArrayList<Locatable>(Arrays.asList(locatables));
        }
        URL[] urls = VCSModelUtils.convertNodesToURLs(locatables);
        VCSStatus[] statuses = cache.get(urls);
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        int i = 0;
        while (i < statuses.length) {
            if (filter.accept(statuses[i])) {
                nodes.add(locatables[i]);
            }
            ++i;
        }
        return nodes;
    }

    public static final Collection getVersionedSelection(Locatable[] locatables, VCSStatusCache cache) throws Exception {
        if (locatables.length == 0) {
            return Collections.EMPTY_LIST;
        }
        VCSStatus[] statuses = cache.get(VCSModelUtils.convertNodesToURLs(locatables));
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        int i = 0;
        while (i < statuses.length) {
            if (statuses[i].isVersioned()) {
                nodes.add(locatables[i]);
            }
            ++i;
        }
        return nodes;
    }

    public static final Collection getCandidateSelection(Locatable[] locatables, VCSStatusCache cache) throws Exception {
        if (locatables.length == 0) {
            return Collections.EMPTY_LIST;
        }
        VCSStatus[] statuses = cache.get(VCSModelUtils.convertNodesToURLs(locatables));
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        int i = 0;
        while (i < statuses.length) {
            if (statuses[i].isCandidate()) {
                nodes.add(locatables[i]);
            }
            ++i;
        }
        return nodes;
    }

    public static final boolean saveDirtyNodes(Locatable[] locatables) throws Exception {
        return VCSCommandUtils.saveDirtyNodes(locatables, MessageDialog.getPersistence().isHidden(SKIP_SAVE_FILES_PERSISTENCE_KEY), null);
    }

    public static final boolean saveDirtyNodesSilently(Locatable[] locatables) throws Exception {
        return VCSCommandUtils.saveDirtyNodes(locatables, true, null);
    }

    public static final boolean saveDirtyNodes(Locatable[] locatables, boolean silent, String helpTopicId) throws Exception {
        if (!EventQueue.isDispatchThread()) {
            boolean[] result = new boolean[1];
            try {
                EventQueue.invokeAndWait(new 1(result, locatables, silent, helpTopicId));
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                if (ite.getTargetException() instanceof Exception) {
                    throw (Exception)ite.getTargetException();
                }
                ite.printStackTrace();
            }
            return result[0];
        }
        ArrayList directoryUrls = new ArrayList();
        Node[] nodes = VCSCommandUtils.getDirtyNodes(locatables, directoryUrls);
        return VCSCommandUtils.saveDirtyNodesImpl(nodes, directoryUrls.toArray(new URL[0]), silent, helpTopicId);
    }

    public static final void closeMissingNodes(Node[] nodes) {
        VCSCommandUtils.closeFilteredNodes(nodes, new 2());
    }

    public static final void removeNonEditableNodes(Collection nodes) {
        Iterator itr = nodes.iterator();
        while (itr.hasNext()) {
            URL url = VCSModelUtils.getLocatableURL(itr.next());
            if (url == null || !VCSFileSystemUtils.isNonEditable(url)) continue;
            itr.remove();
        }
    }

    private static final Node[] getDirtyNodes(Locatable[] locatables, Collection directoryUrls) {
        ArrayList<Locatable> nodes = new ArrayList<Locatable>();
        int i = 0;
        while (i < locatables.length) {
            URL url = locatables[i].getURL();
            if (url != null) {
                if (locatables[i] instanceof Node) {
                    nodes.add(locatables[i]);
                } else if (URLFileSystem.isDirectoryPath((URL)url)) {
                    directoryUrls.add(url);
                }
            }
            ++i;
        }
        return VCSModelUtils.getDirtyNodes(nodes.toArray(new Node[0]));
    }

    private static final boolean saveDirtyNodesImpl(Node[] nodes, URL[] directoryUrls, boolean silent, String helpTopicId) throws Exception {
        if (nodes.length <= 0) {
            return true;
        }
        if (!silent) {
            SelectFilesConfiguration selectFilesConfiguration = new SelectFilesConfiguration((Component)VCSWindowUtils.getCurrentWindow(), VCSArb.getString(108), VCSArb.format(192, URLFileSystem.getPlatformPathName((URL)nodes[0].getURL())), VCSArb.getString(2), VCSComponents.createCheckBoxListModel(nodes, false), false, 0, helpTopicId);
            selectFilesConfiguration.setOptionalId(SKIP_SAVE_FILES_PERSISTENCE_KEY);
            if (SelectFilesPanel.showDialog((SelectFilesConfiguration)selectFilesConfiguration) != 0) {
                return false;
            }
        }
        int i = 0;
        while (i < nodes.length) {
            URL url = nodes[i].getURL();
            if (!URLFileSystem.exists((URL)url) || URLFileSystem.setReadOnly((URL)url, (boolean)false)) {
                nodes[i].save();
            }
            ++i;
        }
        return true;
    }

    private static final void closeFilteredNodesImpl(Node[] nodes, URLFilter filter) throws Exception {
        ArrayList<Node> c = new ArrayList<Node>();
        int i = 0;
        while (i < nodes.length) {
            if (!filter.accept(nodes[i].getURL())) {
                c.add(nodes[i]);
            }
            ++i;
        }
        if (c.size() <= 0) {
            return;
        }
        Context context = Context.newIdeContext();
        context.setSelection(c.toArray(new Element[0]));
        Command command = VCSNodeCommands.createQuietCloseNodeCommand(context);
        command.doit();
    }

    private static final void closeFilteredNodes(Node[] nodes, URLFilter filter) {
        EventQueue.invokeLater(new 3(nodes, filter));
    }

    static void maS$closeFilteredNodesImpl(Node[] nodeArray, URLFilter uRLFilter) {
        VCSCommandUtils.closeFilteredNodesImpl(nodeArray, uRLFilter);
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ boolean[] v$result;
        private final /* synthetic */ Locatable[] v$locatables;
        private final /* synthetic */ boolean v$silent;
        private final /* synthetic */ String v$helpTopicId;

        public final void run() {
            try {
                this.v$result[0] = VCSCommandUtils.saveDirtyNodes(this.v$locatables, this.v$silent, this.v$helpTopicId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public 1(boolean[] blArray, Locatable[] locatableArray, boolean bl, String string) {
            this.v$helpTopicId = string;
            this.v$silent = bl;
            this.v$locatables = locatableArray;
            this.v$result = blArray;
        }
    }

    static final class 2
    implements URLFilter {
        public final boolean accept(URL url) {
            return url == null || URLFileSystem.exists((URL)url);
        }
    }

    static final class 3
    implements Runnable {
        private final /* synthetic */ Node[] v$nodes;
        private final /* synthetic */ URLFilter v$filter;

        public final void run() {
            try {
                VCSCommandUtils.maS$closeFilteredNodesImpl(this.v$nodes, this.v$filter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public 3(Node[] nodeArray, URLFilter uRLFilter) {
            this.v$filter = uRLFilter;
            this.v$nodes = nodeArray;
        }
    }
}

