/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public final class VCSConfigUtils {
    private static PatternFilters _patternFilters;

    static {
        ((GlobalIgnoreList)Ide.getSettings().getData("global-ignore-list")).addChangeListener((ChangeListener)new 1());
    }

    private VCSConfigUtils() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String getIdeProperty(String key) {
        BufferedInputStream in = null;
        try {
            Properties ideProps = new Properties();
            ExtensionRegistry er = ExtensionRegistry.getOracleRegistry();
            URL url = er.getSystemDirectory(Ide.getProductID());
            File propsFile = new File(URLFileSystem.getPath((URL)url) + "ide.properties");
            in = new BufferedInputStream(new FileInputStream(propsFile));
            ideProps.load(in);
            String string = ideProps.getProperty(key, null);
            return string;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (in == null) return null;
        try {
            in.close();
            return null;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return null;
    }

    public static final boolean isGloballyIgnored(URL url) {
        PatternFilter matchingFilter = VCSConfigUtils.getPatternFilters().findMatchingFilter(url.getPath());
        return matchingFilter == null || !matchingFilter.isInclude();
    }

    public static final void removeGlobalIgnoreFilter(String ignoreFilterPattern) {
        GlobalIgnoreList ignoreList = (GlobalIgnoreList)Ide.getSettings().getData("global-ignore-list");
        ArrayList pairList = new ArrayList(ignoreList.getList());
        Iterator itr = pairList.iterator();
        while (itr.hasNext()) {
            if (!((Pair)itr.next()).getFirst().equals(ignoreFilterPattern)) continue;
            itr.remove();
        }
        ignoreList.setList(pairList);
    }

    public static final void addGlobalIgnoreFilter(Pair ignoreFilterPair) {
        GlobalIgnoreList ignoreList = (GlobalIgnoreList)Ide.getSettings().getData("global-ignore-list");
        ArrayList<Pair> pairList = new ArrayList<Pair>(ignoreList.getList());
        pairList.add(ignoreFilterPair);
        ignoreList.setList(pairList);
    }

    public static final Pair findGlobalIgnoreFilter(String ignoreFilterPattern) {
        GlobalIgnoreList ignoreList = (GlobalIgnoreList)Ide.getSettings().getData("global-ignore-list");
        for (Object obj : ignoreList.getList()) {
            Pair ignoreFilter;
            if (!(obj instanceof Pair) || !(ignoreFilter = (Pair)obj).getFirst().equals(ignoreFilterPattern)) continue;
            return ignoreFilter;
        }
        return null;
    }

    public static final void fireGlobalIgnoreSettingsChanged() {
        ((GlobalIgnoreList)Ide.getSettings().getData("global-ignore-list")).fireChangeEvent();
        if (!Ide.isStarting()) {
            VCSModelUtils.fireProjectStructuresChanged();
        }
    }

    public static final void registerGlobalIgnoreFilter(String ignoreFilterPattern) {
        if (VCSConfigUtils.findGlobalIgnoreFilter(ignoreFilterPattern) == null) {
            VCSConfigUtils.addGlobalIgnoreFilter(new Pair((Object)ignoreFilterPattern, (Object)Boolean.TRUE));
            VCSConfigUtils.fireGlobalIgnoreSettingsChanged();
        }
        GlobalIgnoreList.registerExcludeFilter((String)ignoreFilterPattern);
    }

    private static final synchronized PatternFilters getPatternFilters() {
        if (_patternFilters == null) {
            _patternFilters = GlobalIgnoreList.getPatternFilters();
        }
        return _patternFilters;
    }

    static void wa$_patternFilters(PatternFilters patternFilters) {
        _patternFilters = patternFilters;
    }

    static final class 1
    implements ChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent ce) {
            Class<VCSConfigUtils> clazz = VCSConfigUtils.class;
            synchronized (VCSConfigUtils.class) {
                VCSConfigUtils.wa$_patternFilters(null);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

