/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.ide.Context;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public final class VCSContextUtils {
    private static final String SUB_PREFIX = "_SUB_";

    private VCSContextUtils() {
    }

    public static final Locatable[] getContextLocatables(Context context, URLFilter filter) {
        Element[] elements = null;
        if (context.getSelection() != null && context.getSelection().length > 0) {
            elements = context.getSelection();
            boolean gotLocatables = false;
            int i = 0;
            while (i < elements.length) {
                URL url;
                if (elements[i] instanceof Locatable && (url = ((Locatable)elements[i]).getURL()) != null && (filter == null || filter.accept(url))) {
                    gotLocatables = true;
                    break;
                }
                ++i;
            }
            if (!gotLocatables) {
                elements = null;
            }
        }
        if (elements == null) {
            LinkedHashSet<Element> directoryFolders = new LinkedHashSet<Element>();
            if (context.getElement() instanceof RelativeDirectoryContextFolder) {
                directoryFolders.add(context.getElement());
            }
            if (context.getSelection() != null) {
                Element[] elementArray = context.getSelection();
                int n = 0;
                while (n < elementArray.length) {
                    Element element = elementArray[n];
                    if (element instanceof RelativeDirectoryContextFolder) {
                        directoryFolders.add(element);
                    }
                    ++n;
                }
            }
            if (!directoryFolders.isEmpty()) {
                elements = directoryFolders.toArray(new Element[0]);
            }
        }
        if (elements == null && context.getNode() != null && !(context.getNode() instanceof Project)) {
            elements = new Element[]{context.getNode()};
        }
        if (elements == null) {
            return new Locatable[0];
        }
        return VCSContextUtils.getExpandedLocatables(context, elements, filter);
    }

    public static final Locatable[] getContextLocatables(Context context) {
        return VCSContextUtils.getContextLocatables(context, null);
    }

    public static final Locatable[] getExpandedLocatables(Element[] elements, URLFilter filter) {
        return VCSContextUtils.getExpandedLocatables(null, elements, filter);
    }

    public static final Locatable[] getExpandedLocatables(Context context, Element[] elements, URLFilter filter) {
        String viewType = VCSContextUtils.getContextViewType(context);
        if (viewType == null) {
            viewType = "ViewTypeThatDoesNotExist";
        }
        LinkedHashSet<Object> expandedElements = new LinkedHashSet<Object>();
        int i = 0;
        while (i < elements.length) {
            URL[] compositeFileUrls = null;
            if (CompositeFileElementRegistry.isCompositeElement((Element)elements[i], (String)viewType)) {
                compositeFileUrls = CompositeFileElementRegistry.getCompositeFileURLs((Element)elements[i], (String)viewType);
            }
            if (compositeFileUrls != null) {
                ArrayList<URL> compositeFileUrls0 = new ArrayList<URL>(Arrays.asList(compositeFileUrls));
                Iterator itr = compositeFileUrls0.iterator();
                while (itr.hasNext()) {
                    if (URLFileSystem.exists((URL)((URL)itr.next()))) continue;
                    itr.remove();
                }
                compositeFileUrls = compositeFileUrls0.toArray(new URL[0]);
            }
            if (compositeFileUrls != null && compositeFileUrls.length > 0) {
                expandedElements.addAll(Arrays.asList(VCSModelUtils.findOrCreateNodes(compositeFileUrls)));
            } else {
                expandedElements.add(elements[i]);
            }
            ++i;
        }
        elements = expandedElements.toArray(new Element[0]);
        return VCSModelUtils.getValidLocatables(elements, filter);
    }

    public static final String getContextViewType(Context context) {
        if (context == null || context.getView() == null) {
            return null;
        }
        return new ViewId(context.getView().getId()).getType().replaceAll(SUB_PREFIX, "");
    }
}

