/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.RegisteredDynamicNode;
import oracle.ide.model.ContentType;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.util.StringTokenizerEx;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VCSFileSystemUtils {
    private VCSFileSystemUtils() {
    }

    public static final Map<URL, Collection<URL>> organizeURLsByParent(URL[] urls) {
        LinkedHashMap<URL, Collection<URL>> map = new LinkedHashMap<URL, Collection<URL>>();
        int i = 0;
        while (i < urls.length) {
            URL parent = URLFileSystem.getParent((URL)urls[i]);
            ArrayList<URL> c = (ArrayList<URL>)map.get(parent);
            if (c == null) {
                c = new ArrayList<URL>();
                map.put(parent, c);
            }
            c.add(urls[i]);
            ++i;
        }
        return map;
    }

    public static final Map<URL, Collection<String>> organizeFilenamesByParent(URL[] urls) {
        LinkedHashMap<URL, Collection<String>> map = new LinkedHashMap<URL, Collection<String>>();
        int i = 0;
        while (i < urls.length) {
            URL parent = URLFileSystem.getParent((URL)urls[i]);
            ArrayList<String> c = (ArrayList<String>)map.get(parent);
            if (c == null) {
                c = new ArrayList<String>();
                map.put(parent, c);
            }
            c.add(URLFileSystem.getFileName((URL)urls[i]));
            ++i;
        }
        return map;
    }

    public static final String[] getURLFileNames(URL[] urls) {
        String[] filenames = new String[urls.length];
        int i = 0;
        while (i < filenames.length) {
            filenames[i] = URLFileSystem.getFileName((URL)urls[i]);
            ++i;
        }
        return filenames;
    }

    public static final URL[] canonicalizeURLs(URL[] urls) {
        URL[] urls2 = new URL[urls.length];
        int i = 0;
        while (i < urls.length) {
            urls2[i] = URLFileSystem.canonicalize((URL)urls[i]);
            ++i;
        }
        return urls2;
    }

    public static final URL searchSystemPath(String name) {
        URL[] urls = VCSFileSystemUtils._searchSystemPath(name, false);
        return urls.length > 0 ? urls[0] : null;
    }

    public static final URL[] searchSystemPathFully(String name) {
        return VCSFileSystemUtils._searchSystemPath(name, true);
    }

    private static final URL[] _searchSystemPath(String name, boolean fullSearch) {
        String path;
        LinkedHashSet<URL> urls = null;
        if (fullSearch) {
            urls = new LinkedHashSet<URL>();
        }
        if ((path = System.getenv("PATH")) == null) {
            return new URL[0];
        }
        StringTokenizerEx tokenizer = new StringTokenizerEx(path, File.pathSeparator, false, true, false);
        URL workingDirectory = URLFactory.newDirURL((File)new File("."));
        while (tokenizer.hasMoreElements()) {
            String entry = tokenizer.nextElement().toString();
            URL dir = new File(entry).isAbsolute() ? URLFactory.newDirURL((String)entry) : URLFactory.newURL((URL)workingDirectory, (String)entry);
            URL url = URLFactory.newURL((URL)dir, (String)(VCSOperatingSystem.isWindows() ? name + ".exe" : name));
            if (URLFileSystem.isDirectory((URL)url) || !URLFileSystem.exists((URL)url)) continue;
            url = URLFileSystem.canonicalize((URL)url);
            if (!fullSearch) {
                return new URL[]{url};
            }
            urls.add(url);
        }
        if (urls == null) {
            return new URL[0];
        }
        return urls.toArray(new URL[0]);
    }

    public static final URL[] getParentURLs(URL url) {
        ArrayList<URL> urls = new ArrayList<URL>();
        while ((url = URLFileSystem.getParent((URL)url)) != null) {
            urls.add(url);
        }
        return urls.toArray(new URL[0]);
    }

    public static final URL[] getParentURLs(URL[] urls) {
        LinkedHashSet<URL> parents = new LinkedHashSet<URL>();
        int i = 0;
        while (i < urls.length) {
            parents.addAll(Arrays.asList(VCSFileSystemUtils.getParentURLs(urls[i])));
            ++i;
        }
        return parents.toArray(new URL[parents.size()]);
    }

    public static final boolean isBaseURLFor(URL url1, URL url2) {
        if (URLFileSystem.isDirectoryPath((URL)url1)) {
            return URLFileSystem.isBaseURLFor((URL)url1, (URL)url2);
        }
        return url1.toString().equals(url2.toString());
    }

    public static final URL[] newTargetURLs(URL[] urls, URL target) {
        URL[] targets = new URL[urls.length];
        int i = 0;
        while (i < targets.length) {
            targets[i] = URLFileSystem.isDirectoryPath((URL)urls[i]) ? URLFactory.newDirURL((URL)target, (String)URLFileSystem.getFileName((URL)urls[i])) : URLFactory.newURL((URL)target, (String)URLFileSystem.getFileName((URL)urls[i]));
            ++i;
        }
        return targets;
    }

    public static final URL newFileURL(String filePath) {
        return filePath.endsWith(File.separator) ? URLFactory.newDirURL((String)filePath) : URLFactory.newFileURL((String)filePath);
    }

    public static final String getPlatformPathName(URL url) {
        String path = URLFileSystem.getPlatformPathName((URL)url);
        return URLFileSystem.isDirectoryPath((URL)url) && !path.endsWith(File.separator) ? (path = path + File.separator) : path;
    }

    public static final URL[] removeRefAndQueryParts(URL[] urls) {
        URL[] urls2 = new URL[urls.length];
        int i = 0;
        while (i < urls.length) {
            urls2[i] = urls[i];
            urls2[i] = URLFactory.replaceRefPart((URL)urls2[i], null);
            urls2[i] = URLFactory.replaceQueryPart((URL)urls2[i], null);
            ++i;
        }
        return urls2;
    }

    public static final ContentType getContentType(String extension) {
        return VCSFileSystemUtils.findContentTypeFromExtension(extension);
    }

    public static final URL[] getContentTypeURLs(URL[] urls, ContentType contentType) {
        ArrayList<URL> contentTypeUrls = new ArrayList<URL>();
        int i = 0;
        while (i < urls.length) {
            if (VCSFileSystemUtils.findContentTypeFromExtension(URLFileSystem.getSuffix((URL)urls[i])) == contentType) {
                contentTypeUrls.add(urls[i]);
            }
            ++i;
        }
        return contentTypeUrls.toArray(new URL[0]);
    }

    private static final ContentType findContentTypeFromExtension(String extension) {
        ContentType contentType = DocumentExtensions.findRecognizerContentType((String)extension);
        if (contentType == null && extension != null && extension.length() > 0 && Recognizer.getClassForExtension((String)extension) != null) {
            return ContentType.TEXT;
        }
        return contentType;
    }

    public static final Map<ContentType, Collection<URL>> organizeURLsByContentType(URL[] urls) {
        LinkedHashMap<ContentType, Collection<URL>> map = new LinkedHashMap<ContentType, Collection<URL>>();
        int i = 0;
        while (i < urls.length) {
            ContentType contentType = VCSFileSystemUtils.findContentTypeFromExtension(URLFileSystem.getSuffix((URL)urls[i]));
            ArrayList<URL> c = (ArrayList<URL>)map.get(contentType);
            if (c == null) {
                c = new ArrayList<URL>();
                map.put(contentType, c);
            }
            c.add(urls[i]);
            ++i;
        }
        return map;
    }

    public static final void registerFileType(String extension, ContentType contentType) {
        if (extension.equals("")) {
            return;
        }
        extension = DocumentExtensions.DocRecord.sanitizeExtensionAsString((String)extension);
        DocumentExtensions.DocRecord docRecord = null;
        DocumentExtensions documentExtensions = (DocumentExtensions)Ide.getSettings().getData("document-extensions-options");
        Map documentMap = documentExtensions._getDocumentMap();
        for (Map.Entry entry : documentMap.entrySet()) {
            DocumentExtensions.DocRecord currentDocRecord = (DocumentExtensions.DocRecord)entry.getValue();
            if (!currentDocRecord.isExtensionInUse(extension)) continue;
            docRecord = currentDocRecord;
            break;
        }
        if (docRecord == null) {
            for (Map.Entry entry : documentMap.entrySet()) {
                DocumentExtensions.DocRecord currentDocRecord = (DocumentExtensions.DocRecord)entry.getValue();
                if (!currentDocRecord.getDocClassName().equals(RegisteredDynamicNode.class.getName())) continue;
                docRecord = currentDocRecord;
                break;
            }
            if (docRecord == null) {
                docRecord = new DocumentExtensions.DocRecord(RegisteredDynamicNode.class, null);
                documentMap.put(RegisteredDynamicNode.class, docRecord);
            }
            DocumentExtensions.ExtInfo extInfo = docRecord.addUserExtension(extension);
            extInfo.setLocked(true);
        }
        documentExtensions._setDocumentMap(documentMap);
        Recognizer.mapExtensionToContentType((String)extension, (ContentType)contentType);
        Ide.getSettings().save();
    }

    public static final URL getDirectoryPathURL(URL url) {
        return URLFileSystem.isDirectoryPath((URL)url) ? url : URLFactory.newDirURL((URL)url, (String)"");
    }

    public static final URL[] coalesceURLs(URL[] urls) {
        ArrayList<URL> urls0 = new ArrayList<URL>(Arrays.asList(urls));
        ArrayList<URL> urls1 = new ArrayList<URL>();
        while (!urls0.isEmpty()) {
            URL shallowUrl = (URL)urls0.iterator().next();
            String shallowUrlExternal = shallowUrl.toExternalForm();
            for (URL currentUrl : urls0) {
                String currentUrlExternal = currentUrl.toExternalForm();
                if (!URLFileSystem.isDirectoryPath((URL)currentUrl) || !shallowUrlExternal.startsWith(currentUrlExternal)) continue;
                shallowUrl = currentUrl;
                shallowUrlExternal = currentUrlExternal;
            }
            if (URLFileSystem.isDirectoryPath((URL)shallowUrl)) {
                Iterator itr = urls0.iterator();
                while (itr.hasNext()) {
                    if (!((URL)itr.next()).toExternalForm().startsWith(shallowUrlExternal)) continue;
                    itr.remove();
                }
            } else {
                urls0.remove(shallowUrl);
            }
            urls1.add(shallowUrl);
        }
        return urls1.toArray(new URL[0]);
    }

    public static void registerDecorator(String protocol, URLFileSystemHelperDecorator decorator) {
        if (protocol != null && protocol.length() > 0 && decorator != null) {
            URLFileSystemHelper helper = URLFileSystem.findHelper((String)protocol);
            if (!(helper instanceof URLFileSystemHelperDecorator)) {
                URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)decorator);
                return;
            }
            while (true) {
                URLFileSystemHelperDecorator thisDecorator;
                URLFileSystemHelper nextHelper;
                if (!((nextHelper = (thisDecorator = (URLFileSystemHelperDecorator)helper).getHelper()) instanceof URLFileSystemHelperDecorator)) {
                    thisDecorator.insertNextDecorator(decorator);
                    break;
                }
                helper = nextHelper;
            }
        }
    }

    public static boolean isNonEditable(URL url) {
        Node node = NodeFactory.find((URL)url);
        return node != null && node.getAttributes().isSet(ElementAttributes.NON_EDITABLE);
    }
}

