/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.Component;
import java.text.Collator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.replace.ReplaceMenuManager;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSExtensionInformation;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.util.VCSDefaultUtils;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdevimpl.vcs.VCSManagerImpl;

public class VCSMenuUtils {
    private static ContextMenuListener _compareContextMenuListener;
    private static ContextMenuListener _replaceContextMenuListener;
    private static Map<JMenuItem, String> _compareMenuItems;
    private static Map<JMenuItem, String> _replaceMenuItems;

    public static JMenu getMainVersioningMenu() {
        JMenu menu = MenuManager.getJMenu((String)"Versioning");
        if (menu == null) {
            throw new IllegalStateException("VCS extension trying to initialize with no Versioning menu");
        }
        return menu;
    }

    public static JMenuItem installVersionHistoryMenuItem(JMenu menu, int cmdId) {
        return VCSMenuUtils.addMenuItem(menu, cmdId, 99.8f);
    }

    public static JMenu createVersioningSubmenu() {
        float section = MenuConstants.SECTION_ADDITIONAL_CTXT_MENU;
        return Ide.getMenubar().createSubMenu(VCSArb.getString(33), VCSMenuConstants.CONTEXT_MENU_MNEMONIC, 0.1f, section);
    }

    public static JMenu installMainSystemMenu(String vcsId, VCSExtensionInformation information) {
        String menuId = "Versioning" + '.' + vcsId;
        if (VCSExtensionUtils.getExtensionCount() <= 1) {
            MenuManager.putJMenu((String)menuId, (JMenu)VCSMenuUtils.getMainVersioningMenu());
            return VCSMenuUtils.getMainVersioningMenu();
        }
        String name = information.getShortLabel();
        JMenu versioningMenu = VCSMenuUtils.getMainVersioningMenu();
        JMenu submenu = Ide.getMenubar().createSubMenu(name, null, 0.0f, 0.0f);
        submenu.setIcon(information.getIcon());
        MenuManager.putJMenu((String)menuId, (JMenu)submenu);
        int i = 0;
        while (i <= versioningMenu.getItemCount()) {
            if (i == versioningMenu.getItemCount()) {
                versioningMenu.add(submenu);
                break;
            }
            JMenuItem menuItem = versioningMenu.getItem(i);
            if (Collator.getInstance().compare(menuItem.getText(), name) > 0) {
                versioningMenu.insert(submenu, i);
                break;
            }
            ++i;
        }
        return submenu;
    }

    public static void installContextMenuListener(ContextMenuListener listener) {
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().addContextMenuListener(listener, null);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(listener, null);
        ((VCSManagerImpl)VCSManager.getVCSManager()).registerContextMenuListener(listener);
    }

    public static void uninstallContextMenuListener(ContextMenuListener listener) {
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().removeContextMenuListener(listener);
        }
        EditorManager.getEditorManager().getContextMenu().removeContextMenuListener(listener);
        ((VCSManagerImpl)VCSManager.getVCSManager()).deregisterContextMenuListener(listener);
    }

    public static KeyStrokeContext registerKeyStrokes(Collection actions, String keyStrokeContextName) {
        IdeAction[] actionArray = new IdeAction[actions.size()];
        actions.toArray(actionArray);
        KeyStrokeContext context = VCSDefaultUtils.createKeyStrokeContext(actionArray, keyStrokeContextName);
        Ide.getKeyStrokeContextRegistry().addContext(context);
        return context;
    }

    public static JMenuItem addMenuItem(JMenu menu, int cmdId, float section) {
        return VCSMenuUtils.addMenuItem(menu, (ToggleAction)IdeAction.find((int)cmdId), section);
    }

    public static JMenuItem addMenuItem(JMenu menu, ToggleAction action, float section) {
        return (JMenuItem)VCSMenuUtils.addMenuItem(menu, Ide.getMenubar().createMenuItem(action), section);
    }

    public static Component addMenuItem(JMenu menu, Component component, float section) {
        Ide.getMenubar().add(component, menu, section);
        return component;
    }

    public static JMenuItem addDynamicMenuItem(JMenu menu, int cmdId, float section, Context context) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (action == null) {
            return null;
        }
        action.updateAction(context);
        if (!action.isEnabled()) {
            return null;
        }
        return VCSMenuUtils.addMenuItem(menu, cmdId, section);
    }

    public static JMenuItem createMenuItem(int cmdId) {
        return Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)cmdId));
    }

    public static JMenuItem createMenuItem(int cmdId, float weight) {
        return Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)cmdId), weight);
    }

    public static void installCompareMenuItem(int cmdId, String vcsId) {
        _compareMenuItems.put(VCSMenuUtils.createMenuItem(cmdId), vcsId);
        if (_compareContextMenuListener != null) {
            return;
        }
        _compareContextMenuListener = new 1(cmdId);
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().getContextMenu().addContextMenuListener(_compareContextMenuListener);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(_compareContextMenuListener);
    }

    public static void installReplaceMenuItem(int cmdId, String vcsId) {
        _replaceMenuItems.put(VCSMenuUtils.createMenuItem(cmdId), vcsId);
        if (_replaceContextMenuListener != null) {
            return;
        }
        _replaceContextMenuListener = new 2(cmdId);
        if (NavigatorManager.getApplicationNavigatorManager() != null) {
            NavigatorManager.getApplicationNavigatorManager().getContextMenu().addContextMenuListener(_replaceContextMenuListener);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(_replaceContextMenuListener);
    }

    public static void addCompareSubmenu(Collection menus, Context context) {
        if (CompareViewer.get() != null) {
            JMenu menu = CompareViewer.get().getContextCompareMenu();
            int i = 0;
            while (i < menu.getItemCount()) {
                JMenuItem item = menu.getItem(i);
                if (item != null && item.getAction() instanceof IdeAction) {
                    ((IdeAction)item.getAction()).updateAction(context);
                }
                if (item != null && item.isEnabled()) {
                    menus.add(menu);
                    break;
                }
                ++i;
            }
        }
    }

    static {
        _compareMenuItems = new HashMap<JMenuItem, String>();
        _replaceMenuItems = new HashMap<JMenuItem, String>();
    }

    static Map ra$_replaceMenuItems() {
        return _replaceMenuItems;
    }

    static Map ra$_compareMenuItems() {
        return _compareMenuItems;
    }

    static final class 1
    implements ContextMenuListener {
        private final /* synthetic */ int v$cmdId;

        public void menuWillShow(ContextMenu contextMenu) {
            CompareViewer compareViewer = CompareViewer.get();
            if (compareViewer == null) {
                Assert.println((String)("Compare viewer is not available. Version control menu item \"" + IdeAction.find((int)this.v$cmdId).getValue("Name") + "\" could not be installed."));
                return;
            }
            for (Map.Entry entry : VCSMenuUtils.ra$_compareMenuItems().entrySet()) {
                JMenu menu = compareViewer.getContextCompareMenu();
                Ide.getMenubar().remove((Component)((JMenuItem)entry.getKey()), menu);
                VCSExtension extension = VCSExtensionUtils.getActiveExtension(contextMenu.getContext());
                if (extension == null || !extension.getId().equals((String)entry.getValue())) continue;
                Ide.getMenubar().add((Component)((JMenuItem)entry.getKey()), menu, 0.5f);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public 1(int n) {
            this.v$cmdId = n;
        }
    }

    static final class 2
    implements ContextMenuListener {
        private final /* synthetic */ int v$cmdId;

        public void menuWillShow(ContextMenu contextMenu) {
            ReplaceMenuManager replaceMenuMgr = ReplaceMenuManager.getInstance();
            if (replaceMenuMgr == null) {
                Assert.println((String)("Menu item \"" + IdeAction.find((int)this.v$cmdId).getValue("Name") + "\" could not be installed."));
                return;
            }
            for (Map.Entry entry : VCSMenuUtils.ra$_replaceMenuItems().entrySet()) {
                JMenu menu = replaceMenuMgr.getContextReplaceMenu();
                Ide.getMenubar().remove((Component)((JMenuItem)entry.getKey()), menu);
                VCSExtension extension = VCSExtensionUtils.getActiveExtension(contextMenu.getContext());
                if (extension == null || !extension.getId().equals((String)entry.getValue())) continue;
                Ide.getMenubar().add((Component)((JMenuItem)entry.getKey()), menu, 1.0f);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public 2(int n) {
            this.v$cmdId = n;
        }
    }
}

