/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.model.Attributes;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentType;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Recognizer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

public final class VCSModelUtils {
    private VCSModelUtils() {
    }

    public static final Locatable[] findOrCreateNodes(URL[] urls) {
        Locatable[] locatables = new Locatable[urls.length];
        int i = 0;
        while (i < urls.length) {
            block7: {
                locatables[i] = NodeFactory.find((URL)urls[i]);
                if (locatables[i] == null) {
                    if (URLFileSystem.isDirectoryPath((URL)urls[i])) {
                        locatables[i] = new 1(urls[i]);
                    } else {
                        try {
                            locatables[i] = NodeFactory.findOrCreate((URL)urls[i]);
                            break block7;
                        }
                        catch (IllegalAccessException iae) {
                            iae.printStackTrace();
                        }
                        catch (InstantiationException ie) {
                            // empty catch block
                        }
                        locatables[i] = new LocatableImpl(urls[i]);
                    }
                }
            }
            ++i;
        }
        return locatables;
    }

    public static final URL[] convertNodesToURLs(Locatable[] locatables) {
        URL[] urls = new URL[locatables.length];
        int i = 0;
        while (i < urls.length) {
            urls[i] = locatables[i].getURL();
            ++i;
        }
        return urls;
    }

    public static final URL[] convertNodesToURLs(Collection locatables) {
        return VCSModelUtils.convertNodesToURLs(locatables.toArray(new Locatable[0]));
    }

    public static final boolean isElementSaveUpdate(Object observed, UpdateMessage change) {
        if (change.getMessageID() != UpdateMessage.ATTRIBUTE_CHANGED) {
            return false;
        }
        if (!(observed instanceof Element)) {
            return false;
        }
        if (change.getModifyObjects() == null || change.getModifyObjects().size() <= 0) {
            return false;
        }
        Attributes bef = (Attributes)change.getModifyObjects().get(0);
        Attributes aft = ((Element)observed).getAttributes();
        if (bef == null || aft == null) {
            return false;
        }
        return bef.isSet(ElementAttributes.DIRTY) && !aft.isSet(ElementAttributes.DIRTY);
    }

    public static final Locatable[] getValidLocatables(Object[] nodes, URLFilter filter) {
        ArrayList<Object> c = new ArrayList<Object>();
        int i = 0;
        while (i < nodes.length) {
            URL url = VCSModelUtils.getLocatableURL(nodes[i]);
            if (url != null && (filter == null || filter.accept(url))) {
                c.add(nodes[i]);
            }
            ++i;
        }
        return c.toArray(new Locatable[0]);
    }

    public static final URL getLocatableURL(Object node) {
        return node instanceof Locatable ? ((Locatable)node).getURL() : null;
    }

    public static final Node[] findCachedNodes(URLFilter filter) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Iterator itr = NodeFactory.getCachedNodes();
        while (itr.hasNext()) {
            Node node = (Node)itr.next();
            URL url = node.getURL();
            if (filter != null && (url == null || !filter.accept(url))) continue;
            nodes.add(node);
        }
        return nodes.toArray(new Node[0]);
    }

    public static final Node[] getDirtyNodes(Node[] nodes) {
        ArrayList<Node> dirtyables = new ArrayList<Node>();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i].isDirty()) {
                dirtyables.add(nodes[i]);
            }
            ++i;
        }
        return dirtyables.toArray(new Node[0]);
    }

    public static final Node[] getCachedDirectoryNodes(URL[] directoryUrls) {
        return VCSModelUtils.findCachedNodes(VCSURLFilters.createDirectoryContentsFilter(directoryUrls));
    }

    public static final Node[] getCachedBaseURLNodes(URL[] baseUrls) {
        return VCSModelUtils.findCachedNodes(VCSURLFilters.createBaseURLContentsFilter(VCSFileSystemUtils.canonicalizeURLs(baseUrls)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] listBinaryExtensions() {
        Map extensionToContentTypeMap;
        HashSet<String> extensions = new HashSet<String>();
        Map map = extensionToContentTypeMap = Recognizer.getExtensionToContentTypeMap();
        synchronized (map) {
            for (File file : extensionToContentTypeMap.keySet()) {
                if (ContentType.BINARY != extensionToContentTypeMap.get(file)) continue;
                extensions.add(file.getPath());
            }
        }
        Object[] extensionsArray = extensions.toArray(new String[extensions.size()]);
        Arrays.sort(extensionsArray);
        return extensionsArray;
    }

    public static final Workspace[] findCachedWorkspaces() {
        if (!EventQueue.isDispatchThread()) {
            Assert.println((String)"VCS: Warning: findCachedWorkspaces() called off the AWT event thread");
        }
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        Iterator itr = Ide.getWorkspaces().getChildren();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof Workspace)) continue;
            workspaces.add((Workspace)o);
        }
        return workspaces.toArray(new Workspace[0]);
    }

    public static final Project[] findCachedProjects() {
        if (!EventQueue.isDispatchThread()) {
            Assert.println((String)"VCS: Warning: findCachedProjects() called off the AWT event thread");
        }
        LinkedHashSet projects = new LinkedHashSet();
        Workspace[] workspaceArray = VCSModelUtils.findCachedWorkspaces();
        int n = 0;
        while (n < workspaceArray.length) {
            Workspace workspace = workspaceArray[n];
            projects.addAll(workspace.projects());
            ++n;
        }
        return projects.toArray(new Project[0]);
    }

    public static final Project[] findCachedProjects(boolean openWorkspaces) {
        return VCSModelUtils.findCachedProjects();
    }

    public static final void fireProjectStructuresChanged() {
        VCSModelUtils.fireProjectStructuresChanged(null);
    }

    public static final void fireProjectStructuresChanged(URL[] projectContentsUrls) {
        Project[] projects = VCSModelUtils.findCachedProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen() && (projectContentsUrls == null || VCSModelUtils.contentSetCanHaveMember(ProjectContent.getInstance((PropertyStorage)projects[i]).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY), projectContentsUrls))) {
                VCSModelUtils.fireStructureChanged((Subject)projects[i]);
            }
            ++i;
        }
    }

    public static final void fireVetoableCanRemoveChildren(Object[] elements) throws ChangeVetoException {
        Project[] projects = VCSModelUtils.findCachedProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen()) {
                ArrayList<Object> removeObjects = null;
                int j = 0;
                while (j < elements.length) {
                    if (!(elements[j] instanceof Workspace) && !(elements[j] instanceof Project) && projects[i].containsChild((Element)elements[j])) {
                        if (removeObjects == null) {
                            removeObjects = new ArrayList<Object>();
                        }
                        removeObjects.add(elements[j]);
                    }
                    ++j;
                }
                if (removeObjects != null) {
                    UpdateMessage.fireCanRemoveChildren((VetoableSubject)projects[i], removeObjects);
                }
            }
            ++i;
        }
    }

    public static final URL[] listProjectURLs(Project project, VCSCancellable cancellable) throws InterruptedException {
        LinkedHashSet urls = new LinkedHashSet();
        urls.addAll(VCSModelUtils.listProjectContentURLs(project, cancellable));
        if (cancellable != null && cancellable.isCancelled()) {
            return urls.toArray(new URL[0]);
        }
        urls.addAll(VCSModelUtils.listProjectDirectoryURLs(project));
        return urls.toArray(new URL[0]);
    }

    private static boolean contentSetCanHaveMember(ContentSet contentSet, URL[] projectContentsUrls) {
        Iterator<URL> itr = Arrays.asList(projectContentsUrls).iterator();
        while (itr.hasNext()) {
            if (!contentSet.canHaveMember(itr.next())) continue;
            return true;
        }
        return false;
    }

    private static void fireStructureChanged(Subject s) {
        EventQueue.invokeLater(new 2(s));
    }

    private static final Collection listProjectContentURLs(Project project, VCSCancellable cancellable) throws InterruptedException {
        ContentSet contentSet = VCSModelUtils.getAllProjectContents(project);
        if (contentSet == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList urls = new ArrayList();
        Iterator itr = contentSet.urlIterator(null);
        while (itr.hasNext() && (cancellable == null || !cancellable.isCancelled())) {
            urls.add(itr.next());
        }
        return urls;
    }

    private static final Collection listProjectDirectoryURLs(Project project) {
        if (!project.isOpen()) {
            return Collections.EMPTY_SET;
        }
        URL[] urls = URLFileSystem.list((URL)URLFileSystem.canonicalize((URL)URLFileSystem.getParent((URL)project.getURL())));
        if (urls == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList<URL> urls0 = new ArrayList<URL>(Arrays.asList(urls));
        Iterator itr = urls0.iterator();
        while (itr.hasNext()) {
            URL url = (URL)itr.next();
            if (URLFileSystem.isDirectoryPath((URL)url)) {
                itr.remove();
                continue;
            }
            if (!GlobalIgnoreList.isGloballyIgnored((URL)url)) continue;
            itr.remove();
        }
        return urls0;
    }

    private static final ContentSet getAllProjectContents(Project project) throws InterruptedException {
        if (!project.isOpen()) {
            return null;
        }
        if (EventQueue.isDispatchThread()) {
            return ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        }
        try {
            ContentSet[] contentSet = new ContentSet[1];
            EventQueue.invokeAndWait(new 3(contentSet, project));
            ContentSet contentSet2 = contentSet[0];
            return contentSet2;
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            return null;
        }
    }

    static final class 1
    extends LocatableImpl {
        public Icon getIcon() {
            return UIManager.getIcon("Tree.closedIcon");
        }

        public 1(URL uRL) {
            super(uRL);
        }
    }

    static final class 2
    implements Runnable {
        private final /* synthetic */ Subject v$s;

        public final void run() {
            UpdateMessage.fireStructureChanged((Subject)this.v$s);
        }

        public 2(Subject subject) {
            this.v$s = subject;
        }
    }

    static final class 3
    implements Runnable {
        private final /* synthetic */ ContentSet[] v$contentSet;
        private final /* synthetic */ Project v$project;

        public void run() {
            this.v$contentSet[0] = ProjectContent.getInstance((PropertyStorage)this.v$project).getAllContents();
        }

        public 3(ContentSet[] contentSetArray, Project project) {
            this.v$project = project;
            this.v$contentSet = contentSetArray;
        }
    }

    private static class LocatableImpl
    extends DefaultElement
    implements Locatable {
        private URL _url;

        LocatableImpl(URL url) {
            this.setURL(url);
        }

        public void setURL(URL url) {
            this._url = url;
        }

        public URL getURL() {
            return this._url;
        }

        public String getShortLabel() {
            return URLFileSystem.getFileName((URL)this.getURL());
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.getURL().equals(((LocatableImpl)((Object)obj)).getURL());
        }
    }
}

