/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.util.ArrayList;
import oracle.ide.config.IdeSettings;
import oracle.ide.panels.Navigable;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSVersioningTraversable;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;

public class VCSNavigableUtils {
    private static Navigable _versioningNavigable;

    private VCSNavigableUtils() {
    }

    public static final Navigable createVersioningNavigable() {
        return new Navigable(VCSArb.getString(11), VCSVersioningTraversable.class);
    }

    public static final Navigable createVersioningNavigable(Class traversableClass) {
        return new Navigable(VCSArb.getString(11), traversableClass);
    }

    public static final Navigable createGeneralNavigable(Class traversableClass) {
        return new Navigable(VCSArb.getString(102), traversableClass);
    }

    public static final synchronized void registerSystemNavigable(Navigable navigable) {
        if (VCSExtensionUtils.getExtensionCount() > 1) {
            if (_versioningNavigable == null) {
                _versioningNavigable = VCSNavigableUtils.createVersioningNavigable();
                IdeSettings.registerUI((Navigable)_versioningNavigable);
            }
            _versioningNavigable.addChildNavigable(navigable);
            return;
        }
        if (_versioningNavigable != null) {
            throw new IllegalStateException();
        }
        _versioningNavigable = new Navigable("", null);
        navigable.copyTo((Object)_versioningNavigable);
        _versioningNavigable.setShortLabel(VCSArb.getString(11));
        IdeSettings.registerUI((Navigable)_versioningNavigable);
    }

    public static final String[] getSystemNavigablePath(String systemShortLabel, String ... relativePath) {
        if (_versioningNavigable == null) {
            throw new IllegalStateException();
        }
        ArrayList<String> path = new ArrayList<String>();
        path.add(_versioningNavigable.getShortLabel());
        if (VCSExtensionUtils.getExtensionCount() > 1) {
            path.add(systemShortLabel);
        }
        if (relativePath != null) {
            String[] stringArray = relativePath;
            int n = 0;
            while (n < stringArray.length) {
                String s = stringArray[n];
                path.add(s);
                ++n;
            }
        }
        return path.toArray(new String[0]);
    }
}

