/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;

public final class VCSURLFilters {
    private VCSURLFilters() {
    }

    public static final URLFilter createProtocolFilter(String protocol) {
        return new ProtocolFilter(protocol, null);
    }

    public static final URLFilter createFileProtocolFilter() {
        return new ProtocolFilter("file", null);
    }

    public static final URLFilter createHttpProtocolFilter() {
        return new ProtocolFilter("http", null);
    }

    public static final URLFilter createFilesFilter() {
        return new 1();
    }

    public static final URLFilter createDirectoriesFilter() {
        return new 2();
    }

    public static final URLFilter createFilePathFilter() {
        return new 3();
    }

    public static final URLFilter createDirectoryPathFilter() {
        return new 4();
    }

    public static final URLFilter createSpecificURLFilter(URL[] urls) {
        urls = VCSFileSystemUtils.removeRefAndQueryParts(urls);
        List<URL> urls2 = Arrays.asList(urls);
        return new 5(urls2);
    }

    public static final URLFilter createDirectoryContentsFilter(URL[] directoryUrls) {
        URL[] directoryUrls2 = VCSFileSystemUtils.removeRefAndQueryParts(directoryUrls);
        return new 6(directoryUrls2);
    }

    public static final URLFilter createBaseURLContentsFilter(URL[] baseUrls) {
        URL[] baseUrls2 = VCSFileSystemUtils.removeRefAndQueryParts(baseUrls);
        return new 7(baseUrls2);
    }

    public static final URLFilter createNullFilter() {
        return new 8();
    }

    public static final URLFilter createFileSuffixFilter(String suffix) {
        return new 9(suffix);
    }

    public static final URLFilter createChainedANDFilter(URLFilter[] filters) {
        return new 10(filters);
    }

    public static final URLFilter createChainedORFilter(URLFilter[] filters) {
        return new 11(filters);
    }

    static final class 1
    implements URLFilter {
        public boolean accept(URL url) {
            return URLFileSystem.exists((URL)url) && !URLFileSystem.isDirectory((URL)url);
        }
    }

    static final class 2
    implements URLFilter {
        public boolean accept(URL url) {
            return URLFileSystem.isDirectory((URL)url);
        }
    }

    static final class 3
    implements URLFilter {
        public boolean accept(URL url) {
            return URLFileSystem.isDirectoryPath((URL)url) ^ true;
        }
    }

    static final class 4
    implements URLFilter {
        public boolean accept(URL url) {
            return URLFileSystem.isDirectoryPath((URL)url);
        }
    }

    static final class 5
    implements URLFilter {
        private final /* synthetic */ Collection v$urls2;

        public boolean accept(URL url) {
            return this.v$urls2.contains(url);
        }

        public 5(Collection collection) {
            this.v$urls2 = collection;
        }
    }

    static final class 6
    implements URLFilter {
        private final /* synthetic */ URL[] v$directoryUrls2;

        public boolean accept(URL url) {
            URL parent = URLFileSystem.getParent((URL)url);
            int i = 0;
            while (i < this.v$directoryUrls2.length) {
                if (URLFileSystem.equals((URL)this.v$directoryUrls2[i], (URL)parent)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public 6(URL[] uRLArray) {
            this.v$directoryUrls2 = uRLArray;
        }
    }

    static final class 7
    implements URLFilter {
        private final /* synthetic */ URL[] v$baseUrls2;

        public boolean accept(URL url) {
            int i = 0;
            while (i < this.v$baseUrls2.length) {
                if (VCSFileSystemUtils.isBaseURLFor(this.v$baseUrls2[i], url)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public 7(URL[] uRLArray) {
            this.v$baseUrls2 = uRLArray;
        }
    }

    static final class 8
    implements URLFilter {
        public boolean accept(URL url) {
            return true;
        }
    }

    static final class 9
    implements URLFilter {
        private final /* synthetic */ String v$suffix;
        private String _suffix;

        private void $init$() {
            this._suffix = this.removeDot(this.v$suffix);
        }

        public boolean accept(URL url) {
            if (URLFileSystem.isDirectoryPath((URL)url)) {
                return false;
            }
            String suffix2 = URLFileSystem.getSuffix((URL)url);
            return suffix2 != null ? this.removeDot(suffix2).equals(this._suffix) : false;
        }

        private String removeDot(String s) {
            return s.startsWith(".") ? s.substring(1) : s;
        }

        public 9(String string) {
            this.v$suffix = string;
            this.$init$();
        }
    }

    static final class 10
    implements URLFilter {
        private final /* synthetic */ URLFilter[] v$filters;

        public boolean accept(URL url) {
            int i = 0;
            while (i < this.v$filters.length) {
                if (!this.v$filters[i].accept(url)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public 10(URLFilter[] uRLFilterArray) {
            this.v$filters = uRLFilterArray;
        }
    }

    static final class 11
    implements URLFilter {
        private final /* synthetic */ URLFilter[] v$filters;

        public boolean accept(URL url) {
            int i = 0;
            while (i < this.v$filters.length) {
                if (this.v$filters[i].accept(url)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public 11(URLFilter[] uRLFilterArray) {
            this.v$filters = uRLFilterArray;
        }
    }

    private static final class ProtocolFilter
    implements URLFilter {
        private String _protocol;

        private ProtocolFilter(String protocol) {
            this._protocol = protocol;
        }

        public boolean accept(URL url) {
            String protocol = url.getProtocol();
            if (protocol == null) {
                return false;
            }
            return protocol.equals(this._protocol);
        }

        ProtocolFilter(String string, 1 var2_2) {
            this(string);
        }

        public final class 1 {
        }
    }
}

