/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.versionhistory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.jdeveloper.resource.VCSArb;

public class VersionHistoryURLHelper
extends URLFileSystemHelper {
    public static final String PROTOCOL = "ide.scm.versionhistory";

    public static URL newHistoryURL(URL realUrl) {
        return URLFactory.newIdeURL((String)PROTOCOL, (URL)realUrl);
    }

    public static URL getRealURL(URL versionHistoryUrl) {
        if (versionHistoryUrl == null) {
            return null;
        }
        String protocol = versionHistoryUrl.getProtocol();
        int i = protocol.lastIndexOf(".");
        if (i < 0) {
            return versionHistoryUrl;
        }
        return URLFactory.replaceProtocolPart((URL)versionHistoryUrl, (String)protocol.substring(i + 1));
    }

    public String getFileName(URL url) {
        return VCSArb.format(39, URLFileSystem.getFileName((URL)VersionHistoryURLHelper.getRealURL(url)));
    }

    public String getPlatformPathName(URL url) {
        return VCSArb.format(39, URLFileSystem.getPlatformPathName((URL)VersionHistoryURLHelper.getRealURL(url)));
    }

    public String getSuffix(URL url) {
        return "";
    }

    public InputStream openInputStream(URL url) {
        return new ByteArrayInputStream(new byte[0]);
    }
}

