/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.versionhistory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.ide.Context;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.SplitPanelView;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.DefaultHistoryModel;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryNode;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryURLHelper;
import oracle.jdevimpl.history.HistoryFilterComponent;
import oracle.jdevimpl.history.HistoryManagerImpl;
import oracle.jdevimpl.history.HistoryViewer;

public class VersionHistoryViewer
extends HistoryViewer {
    private JLabel _rightLabel;
    private HistoryFilterComponent _rightFilter;
    private Toolbar _rightToolbar;
    private JSplitPane _historySplitPane;
    private SplitListener _splitListener;

    private void $init$() {
        this._rightToolbar = new Toolbar();
        this._rightToolbar.setMinimumSize(new Dimension(0, 0));
    }

    public Component getFixedTopMargin() {
        return null;
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        View.updateToolbarActions((Toolbar)super.getToolbar());
        View.updateToolbarActions((Toolbar)this._rightToolbar);
    }

    public void open() {
        Node node = this.getContext().getNode();
        try {
            if (node instanceof VersionHistoryNode) {
                node.open();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        super.open();
    }

    public void close() {
        super.close();
        Node node = this.getContext().getNode();
        try {
            if (node instanceof VersionHistoryNode) {
                node.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void refresh() {
        HistoryContext.setHistoryEntrySelectorLHS((Context)this.getContext(), null);
        super.refresh();
    }

    protected String getTablePersistenceKeyLHS() {
        return "VersionHistoryViewer.LHS.DisplaySettings";
    }

    protected String getTablePersistenceKeyRHS() {
        return "VersionHistoryViewer.RHS.DisplaySettings";
    }

    protected void enableAllDefaultProperties(DefaultHistoryModel model) {
    }

    protected URL getRealURL() {
        return VersionHistoryURLHelper.getRealURL(super.getRealURL());
    }

    protected Component createNoHistoryPanel() {
        JPanel noHistoryPanel = new JPanel(new BorderLayout());
        Component noHistoryLabel = super.createNoHistoryPanel();
        if (noHistoryLabel instanceof JComponent) {
            ((JComponent)noHistoryLabel).setBorder(this.createRightLineBorder());
        }
        noHistoryPanel.add(noHistoryLabel, "Center");
        noHistoryPanel.add(Box.createHorizontalStrut(BaseCompareView.calculateRightEditorInset()), "East");
        return noHistoryPanel;
    }

    protected HistoryComponent createHistoryComponent() {
        HistoryComponent historyComponent = super.createHistoryComponent();
        historyComponent.setUseScrollPane(true);
        return historyComponent;
    }

    protected HistoryFilterComponent createHistoryFilter() {
        HistoryFilterComponent leftFilter = this.createHistoryFilter(this.getLeftHistoryComponent());
        this._rightFilter = this.createHistoryFilter(this.getRightHistoryComponent());
        return leftFilter;
    }

    protected void refilterModel() {
        super.refilterModel();
        this._rightFilter.refilter();
    }

    protected JLabel createHistoryFilterLabel(HistoryFilterComponent filter) {
        JLabel leftLabel = this.createToolbarLabel();
        ResourceUtils.resLabel((JLabel)leftLabel, (Component)filter, (String)VCSArb.getString(0));
        this._rightLabel = this.createToolbarLabel();
        ResourceUtils.resLabel((JLabel)this._rightLabel, (Component)this._rightFilter, (String)VCSArb.getString(176));
        return leftLabel;
    }

    protected void disposeHistoryFilters() {
        super.disposeHistoryFilters();
        this._rightFilter.detachCustomFilterObserver();
    }

    protected void layoutHistoryPanel(JPanel historyPanel) {
        this._historySplitPane = new JSplitPane(1);
        this._historySplitPane.setDividerSize(50);
        this._historySplitPane.setContinuousLayout(true);
        JPanel leftPanel = new JPanel(new BorderLayout());
        JPanel rightPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)super.getToolbar(), "North");
        leftPanel.add((Component)this.getLeftHistoryComponent(), "Center");
        rightPanel.add((Component)this._rightToolbar, "North");
        rightPanel.add((Component)this.getRightHistoryComponent(), "Center");
        this._historySplitPane.setBorder(this.createRightLineBorder());
        this._historySplitPane.setResizeWeight(0.5);
        this._historySplitPane.setLeftComponent(leftPanel);
        this._historySplitPane.setRightComponent(rightPanel);
        historyPanel.setLayout(new BorderLayout());
        historyPanel.add((Component)this._historySplitPane, "Center");
        historyPanel.add(Box.createHorizontalStrut(BaseCompareView.calculateRightEditorInset()), "East");
        this._historySplitPane.addComponentListener(new 1());
    }

    protected double getDefaultDividerLocation() {
        return 0.5;
    }

    protected HistoryModel updateHistoryModel(HistoryComponent historyComponent, HistoryFilterComponent filter) {
        if (historyComponent == this.getRightHistoryComponent()) {
            filter = this._rightFilter;
        }
        HistoryModel historyModel = this.updateHistoryModelImpl(historyComponent, filter);
        if (historyComponent == this.getLeftHistoryComponent()) {
            HistoryContext.setHistoryEntrySelectorLHS((Context)this.getContext(), (HistoryEntrySelector)HistoryEntrySelector.PREVIOUS_REVISION);
        }
        if (historyComponent == this.getRightHistoryComponent()) {
            HistoryContext.setHistoryEntrySelectorRHS((Context)this.getContext(), (HistoryEntrySelector)HistoryEntrySelector.CURRENT_REVISION);
        }
        return historyModel;
    }

    protected Collection getHistoryProviders() {
        ArrayList providers = new ArrayList(HistoryManager.getHistoryManager().getProviders());
        providers.remove(((HistoryManagerImpl)HistoryManager.getHistoryManager()).getLocalHistoryProvider());
        return providers;
    }

    protected CompareView createCompareView(CompareModel model) {
        CompareView compareView;
        if (this._splitListener != null) {
            this._splitListener.detach();
            this._splitListener = null;
        }
        if ((compareView = super.createCompareView(model)) instanceof SplitPanelView) {
            this._splitListener = new SplitListener(this._historySplitPane, (SplitPanelView)compareView);
            this._splitListener.attach();
        }
        return compareView;
    }

    protected void initializeToolbars() {
        super.initializeToolbars();
        if (this._rightFilter != null) {
            this._rightToolbar.add((Component)this._rightLabel);
            this._rightToolbar.add((Component)this._rightFilter);
            return;
        }
        int height = 0;
        Toolbar leftToolbar = super.getToolbar();
        int i = 0;
        while (i < leftToolbar.getComponentCount()) {
            height = Math.max(leftToolbar.getComponent((int)i).getPreferredSize().height, height);
            ++i;
        }
        this._rightToolbar.add(Box.createVerticalStrut(height));
        leftToolbar.setMinimumSize(new Dimension(0, 0));
        this._rightToolbar.setMinimumSize(new Dimension(0, 0));
    }

    protected boolean isEditableRHS() {
        return false;
    }

    private Border createRightLineBorder() {
        return BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getColor("controlShadow"));
    }

    public VersionHistoryViewer() {
        this.$init$();
    }

    static JSplitPane ra$_historySplitPane(VersionHistoryViewer versionHistoryViewer) {
        return versionHistoryViewer._historySplitPane;
    }

    final class oracle.jdeveloper.vcs.versionhistory.VersionHistoryViewer$1
    extends ComponentAdapter {
        public void componentShown(ComponentEvent ce) {
            EventQueue.invokeLater(new 1());
            VersionHistoryViewer.ra$_historySplitPane(VersionHistoryViewer.this).removeComponentListener(this);
        }

        final class 1
        implements Runnable {
            public void run() {
                VersionHistoryViewer.ra$_historySplitPane(VersionHistoryViewer.this).setDividerLocation(0.5);
            }
        }
    }

    private class SplitListener
    implements PropertyChangeListener {
        private final JSplitPane _splitPane;
        private final SplitPanelView _splitPanelView;
        private int _dividerWidthDelta;

        SplitListener(JSplitPane splitPane, SplitPanelView splitPanelView) {
            this._splitPane = splitPane;
            this._splitPanelView = splitPanelView;
        }

        void attach() {
            this._splitPanelView.getLeftOrCenterSplitter().addPropertyChangeListener(this);
            this._splitPane.addPropertyChangeListener(this);
            this._dividerWidthDelta = this._splitPane.getDividerSize() / 2;
        }

        void detach() {
            this._splitPanelView.getLeftOrCenterSplitter().removePropertyChangeListener(this);
            this._splitPane.removePropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("lastSplitterLocation")) {
                this.detach();
                this._splitPane.setDividerLocation((Integer)pce.getNewValue() - this._dividerWidthDelta);
                this.attach();
            }
            if (pce.getPropertyName().equals("dividerLocation")) {
                this.detach();
                this._splitPanelView.setSplitterLocation(this._splitPanelView.getLeftOrCenterSplitter(), (Integer)pce.getNewValue() + this._dividerWidthDelta);
                this.attach();
            }
        }
    }
}

