/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.vop;

import java.awt.Component;
import java.net.URL;
import javax.swing.JTable;
import javax.swing.UIManager;
import oracle.ide.model.Displayable;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.icons.OracleIcons;

public class DisplayableCellRenderer
extends NiceTableCellRenderer {
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
        this.setIcon(null);
        URL url = null;
        if (value instanceof Locatable) {
            url = ((Locatable)value).getURL();
        }
        if (url != null && URLFileSystem.isDirectoryPath((URL)url)) {
            this.setIcon(UIManager.getIcon("Tree.closedIcon"));
        } else if (value instanceof Displayable) {
            this.setIcon(((Displayable)value).getIcon());
        }
        if (this.getIcon() == null) {
            this.setIcon(OracleIcons.getIcon((String)"file.png"));
        }
        if (url != null) {
            this.setText(URLFileSystem.getFileName((URL)url));
            this.setToolTipText(url.toString());
        } else if (value instanceof Displayable) {
            Displayable displayable = (Displayable)value;
            this.setText(displayable.getShortLabel());
            this.setToolTipText(displayable.getToolTipText());
        }
        return this;
    }
}

