/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.vop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.jdeveloper.vcs.vop.DisplayableCellRenderer;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModelEvent;
import oracle.jdeveloper.vcs.vop.VersionOperationModelListener;
import oracle.jdeveloper.vcs.vop.VersionOperationTableModel;

public class VersionOperationPanel
extends JPanel {
    private final NiceTable _table;
    private final JScrollPane _scrollPane;
    private Component _optionsComponent;
    private VersionOperationModel _model;
    private MouseListener _rightClickListener;
    private int _optionsLocation;
    private boolean _optionsResizeable;
    private JSplitPane _splitPane;
    public static final int BORDER_LOOK_NOT_FLAT = 0;
    public static final int BORDER_LOOK_FLAT_CHANGELIST = 1;
    public static final int BORDER_LOOK_FLAT_HISTORY = 2;

    private void $init$() {
        this._optionsLocation = 3;
    }

    public VersionOperationPanel() {
        this.$init$();
        this._table = new NiceTable();
        this._table.setShowToolTips(false);
        this._table.setUseTransferHandler(false);
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        this._scrollPane = this._table.getScrollPaneForTable();
        this._table.setDefaultRenderer(Displayable.class, (TableCellRenderer)((Object)new DisplayableCellRenderer()));
        this.initializePreferredSize();
        this.layoutComponents();
    }

    public void addMouseListener(MouseListener ml) {
        this._table.addMouseListener(ml);
        this._scrollPane.addMouseListener(ml);
    }

    public void removeMouseListener(MouseListener ml) {
        this._table.removeMouseListener(ml);
        this._scrollPane.removeMouseListener(ml);
    }

    public void setSelectOnRightClick(boolean isSet) {
        if (isSet) {
            if (this._rightClickListener == null) {
                this._rightClickListener = new 1();
                this.addMouseListener(this._rightClickListener);
            }
        } else if (this._rightClickListener != null) {
            this.removeMouseListener(this._rightClickListener);
            this._rightClickListener = null;
        }
    }

    public NiceTable getTable() {
        return this._table;
    }

    public VersionOperationModel getModel() {
        return this._model;
    }

    public void setBorderLook(int look) {
        if (look == 0) {
            this._scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        } else if (look == 1) {
            this._scrollPane.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, UIManager.getColor("controlShadow")));
        } else if (look == 2) {
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void reapplySort() {
        int sortColumn = this._table.getSortColumn();
        boolean sortAscending = this._table.isSortAscending();
        if (sortColumn >= 0) {
            this._table.setSortColumn(sortColumn, sortAscending);
        }
    }

    public void setOptionsLocation(int location) {
        if (this._optionsLocation != location) {
            this._optionsLocation = location;
            if (this._optionsComponent != null) {
                this.setOptionsComponent(this._optionsComponent);
            }
        }
    }

    public void setOptionsResizeable(boolean optionsResizeable) {
        this._optionsResizeable = optionsResizeable;
        this.layoutComponents();
    }

    public void setOptionsComponent(Component c) {
        this._optionsComponent = c;
        this.layoutComponents();
    }

    public Component getOptionsComponent() {
        return this._optionsComponent;
    }

    public final void setOptionsVisible(boolean isVisible) {
        if (this._optionsComponent != null && isVisible != this._optionsComponent.isVisible()) {
            this._optionsComponent.setVisible(isVisible);
            this.layoutComponents();
            this.firePropertyChange("optionsVisible", isVisible ^ true, isVisible);
        }
    }

    public final boolean isOptionsVisible() {
        if (this._optionsComponent != null) {
            return this._optionsComponent.isVisible();
        }
        return false;
    }

    public void installModel(VersionOperationModel model) {
        this._model = model;
        VersionOperationTableModel tableModel = new VersionOperationTableModel(model);
        this._table.setModel((TableModel)tableModel);
        this._table.setAutoResizeMode(0);
        this._table.setSorted(true);
        this.autoSizeColumnsToFit();
        if (!model.isComplete()) {
            2 l = new 2(this, model);
            model.addVersionOperationModelListener(l);
        } else {
            this.reapplySort();
        }
        this.initializePreferredSize();
    }

    public void autoSizeColumnsToFit() {
        VersionOperationTableModel tableModel = (VersionOperationTableModel)this._table.getBaseModel();
        Object[] prototypeValues = new Object[tableModel.getColumnCount()];
        int i = 0;
        while (i < prototypeValues.length) {
            prototypeValues[i] = tableModel.getProperty(i).getPrototypeValue();
            ++i;
        }
        this._table.autoSizeColumnsToFit(prototypeValues);
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this._table.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeSelectionListener(ListSelectionListener listener) {
        this._table.getSelectionModel().removeListSelectionListener(listener);
    }

    public Element[] getSelection() {
        int[] selectedRows = this._table.getSelectedRowsInModel();
        if (selectedRows != null && selectedRows.length > 0) {
            ArrayList<Displayable> selection = new ArrayList<Displayable>(selectedRows.length);
            int i = 0;
            while (i < selectedRows.length) {
                int rowIndex = selectedRows[i];
                if (rowIndex < this._model.getCount()) {
                    selection.add(this._model.getItem(rowIndex));
                }
                ++i;
            }
            Element[] arr = new Element[selection.size()];
            selection.toArray(arr);
            return arr;
        }
        return new Element[0];
    }

    public void selectAll() {
        int rows = this._table.getRowCount();
        if (rows > 0) {
            this._table.setRowSelectionInterval(0, rows - 1);
        }
    }

    private void initializePreferredSize() {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setText("Dummy");
        Insets i = this._scrollPane.getInsets();
        int width = this._table.getPreferredSize().width;
        width += this._scrollPane.getVerticalScrollBar().getPreferredSize().width;
        width += i.left;
        int height = this._table.getTableHeader().getPreferredSize().height;
        height += renderer.getPreferredSize().height * 5;
        height += i.top;
        this._scrollPane.setPreferredSize(new Dimension(width += i.right, height += i.bottom));
    }

    private void layoutComponents() {
        this.removeAll();
        try {
            if (!this._optionsResizeable || this._optionsComponent == null || !this._optionsComponent.isVisible()) {
                this.add((Component)this._scrollPane, "Center");
                if (this._optionsComponent != null && this._optionsComponent.isVisible()) {
                    this.add(this._optionsComponent, this._optionsLocation == 1 ? "North" : "South");
                }
                return;
            }
            JPanel tablePanel = new JPanel(new BorderLayout());
            tablePanel.add((Component)this._scrollPane, "Center");
            tablePanel.setMinimumSize(new Dimension(0, 0));
            this._splitPane = this._optionsLocation == 1 ? new JSplitPane(0, this._optionsComponent, tablePanel) : new JSplitPane(0, tablePanel, this._optionsComponent);
            this._splitPane.setOneTouchExpandable(true);
            this.add((Component)this._splitPane, "Center");
        }
        finally {
            this._table.validate();
            this._table.invalidate();
            this.validate();
            this.invalidate();
            this.repaint();
        }
    }

    static NiceTable ra$_table(VersionOperationPanel versionOperationPanel) {
        return versionOperationPanel._table;
    }

    final class 1
    extends MouseAdapter {
        private void selectOnRightClick(MouseEvent me) {
            int row = VersionOperationPanel.ra$_table(VersionOperationPanel.this).rowAtPoint(me.getPoint());
            if (row < 0 || row >= VersionOperationPanel.ra$_table(VersionOperationPanel.this).getModel().getRowCount()) {
                return;
            }
            if (!VersionOperationPanel.ra$_table(VersionOperationPanel.this).isRowSelected(row)) {
                VersionOperationPanel.ra$_table(VersionOperationPanel.this).setRowSelectionInterval(row, row);
            }
            VersionOperationPanel.this.requestFocus();
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.selectOnRightClick(me);
            }
        }

        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.selectOnRightClick(me);
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.selectOnRightClick(me);
            }
        }
    }

    final class 2
    implements VersionOperationModelListener {
        private final /* synthetic */ VersionOperationModel v$model;
        final /* synthetic */ VersionOperationPanel this$0;

        public void completenessChanged(VersionOperationModelEvent event) {
            if (this.v$model.isComplete()) {
                VersionOperationPanel.ra$_table(this.this$0).setSortColumn(0, true);
                VersionOperationPanel.ra$_table(this.this$0).repaint();
                this.v$model.removeVersionOperationListener(this);
            }
        }

        public void itemsRemoved(VersionOperationModelEvent event) {
        }

        public void itemsChanged(VersionOperationModelEvent event) {
        }

        public void itemsInserted(VersionOperationModelEvent event) {
        }

        public 2(VersionOperationPanel versionOperationPanel, VersionOperationModel versionOperationModel) {
            this.v$model = versionOperationModel;
            this.this$0 = versionOperationPanel;
        }
    }
}

