/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.merge;

import oracle.ide.util.Copyable;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class MergeOptions
extends HashStructureAdapter
implements Copyable {
    public static final String DATA_KEY = "oracle.jdevimpl.merge.MergeOptions";
    public static final String KEY = "mergeOptions";
    private static final String XML_MERGE_ENABLED = "xmlMergeEnabled";
    private static final String MAXIMUM_FILE_SIZE = "maximumFileSize";
    private static final String REFORMAT_RESULT = "reformatResult";
    private static final String VALIDATE_RESULT = "validateResult";
    private static final boolean DEFAULT_XML_MERGE_ENABLED = true;
    private static final int DEFAULT_MAXIMUM_FILE_SIZE = 64;
    private static final boolean DEFAULT_REFORMAT_RESULT = true;
    private static final boolean DEFAULT_VALIDATE_RESULT = false;

    private MergeOptions(HashStructure hash) {
        super(hash);
    }

    public static MergeOptions getInstance(PropertyStorage prefs) {
        return new MergeOptions(MergeOptions.findOrCreate((PropertyStorage)prefs, (String)DATA_KEY));
    }

    public boolean isXMLMergeEnabled() {
        return this._hash.getBoolean(XML_MERGE_ENABLED, true);
    }

    public void setXMLMergeEnabled(boolean xmlMergeEnabled) {
        this._hash.putBoolean(XML_MERGE_ENABLED, xmlMergeEnabled);
    }

    public int getMaximumFileSize() {
        return this._hash.getInt(MAXIMUM_FILE_SIZE, 64);
    }

    public void setMaximumFileSize(int maximumFileSize) {
        this._hash.putInt(MAXIMUM_FILE_SIZE, maximumFileSize);
    }

    public boolean isReformatResult() {
        return this._hash.getBoolean(REFORMAT_RESULT, true);
    }

    public void setReformatResult(boolean reformatResult) {
        this._hash.putBoolean(REFORMAT_RESULT, reformatResult);
    }

    void setValidateResult(boolean validateResult) {
        this._hash.putBoolean(VALIDATE_RESULT, validateResult);
    }

    public boolean isValidateResult() {
        return this._hash.getBoolean(VALIDATE_RESULT, false);
    }
}

