/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.merge;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.jdevimpl.compare.ComparePreferencesPanel;
import oracle.jdevimpl.merge.MergeOptions;
import oracle.jdevimpl.resource.MergeArb;

public final class MergePreferencesPanel
extends ComparePreferencesPanel {
    private final JCheckBox _xmlMergeCheckBox;
    private final JLabel _maxFileSizeLabel;
    private final JSpinner _maxFileSizeSpinner;
    private final JCheckBox _reformatResultCheckBox;
    private final JCheckBox _validateMergeCheckBox;
    private final JPanel _panel;

    private void $init$() {
        this._xmlMergeCheckBox = new JCheckBox();
        this._maxFileSizeLabel = new JLabel();
        this._maxFileSizeSpinner = new JSpinner();
        this._reformatResultCheckBox = new JCheckBox();
        this._validateMergeCheckBox = new JCheckBox();
    }

    public MergePreferencesPanel() {
        this.$init$();
        this._maxFileSizeSpinner.setModel(new SpinnerNumberModel(4, 4, 1024, 4));
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._xmlMergeCheckBox, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._reformatResultCheckBox, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._validateMergeCheckBox, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._maxFileSizeLabel, insets, 1, false, true);
        layoutBuilder.add((Component)this._maxFileSizeSpinner, insets, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        this._panel = new JPanel();
        layoutBuilder.addToPanel((Container)this._panel);
        ResourceUtils.resButton((AbstractButton)this._xmlMergeCheckBox, (String)MergeArb.getString(0));
        ResourceUtils.resLabel((JLabel)this._maxFileSizeLabel, (Component)this._maxFileSizeSpinner, (String)MergeArb.getString(3));
        ResourceUtils.resButton((AbstractButton)this._reformatResultCheckBox, (String)MergeArb.getString(1));
        ResourceUtils.resButton((AbstractButton)this._validateMergeCheckBox, (String)MergeArb.getString(2));
        this._xmlMergeCheckBox.addActionListener(new 1());
        this.updateComponentsEnabled();
        this.setHelpID("f1_idedidesetcompare_html");
    }

    protected void addToLayout() {
        super.addToLayout();
        this.add(Box.createVerticalStrut(LayoutBuilder.VERTICAL_GAP.height));
        this.add(this._panel);
    }

    private void updateComponentsEnabled() {
        boolean xmlMergeEnabled = this._xmlMergeCheckBox.isSelected();
        this._maxFileSizeLabel.setEnabled(xmlMergeEnabled);
        this._maxFileSizeSpinner.setEnabled(xmlMergeEnabled);
        this._reformatResultCheckBox.setEnabled(xmlMergeEnabled);
        this._validateMergeCheckBox.setEnabled(xmlMergeEnabled);
    }

    public void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        MergeOptions options = MergePreferencesPanel.getMergeOptions(tc);
        this._xmlMergeCheckBox.setSelected(options.isXMLMergeEnabled());
        this._maxFileSizeSpinner.setValue(options.getMaximumFileSize());
        this._reformatResultCheckBox.setSelected(options.isReformatResult());
        this._validateMergeCheckBox.setSelected(options.isValidateResult());
        this.updateComponentsEnabled();
    }

    public void onExit(TraversableContext tc) {
        super.onExit(tc);
        MergeOptions options = MergePreferencesPanel.getMergeOptions(tc);
        options.setXMLMergeEnabled(this._xmlMergeCheckBox.isSelected());
        options.setMaximumFileSize(((Number)this._maxFileSizeSpinner.getValue()).intValue());
        options.setReformatResult(this._reformatResultCheckBox.isSelected());
        options.setValidateResult(this._validateMergeCheckBox.isSelected());
    }

    private static MergeOptions getMergeOptions(TraversableContext tc) {
        return MergeOptions.getInstance(tc.getPropertyStorage());
    }

    static void mav$updateComponentsEnabled(MergePreferencesPanel mergePreferencesPanel) {
        mergePreferencesPanel.updateComponentsEnabled();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            MergePreferencesPanel.mav$updateComponentsEnabled(MergePreferencesPanel.this);
        }
    }
}

